/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.seasar.doma.jdbc.AbstractSqlFileRepository;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.dialect.Dialect;

public class GreedyCacheSqlFileRepository
extends AbstractSqlFileRepository {
    protected final ConcurrentMap<String, SqlFile> sqlFileMap = new ConcurrentHashMap<String, SqlFile>(200);

    @Override
    protected SqlFile getSqlFileWithCacheControl(Method method, String path, Dialect dialect) {
        SqlFile file = (SqlFile)this.sqlFileMap.get(path);
        if (file != null) {
            return file;
        }
        file = this.createSqlFile(method, path, dialect);
        SqlFile current = this.sqlFileMap.putIfAbsent(path, file);
        return current != null ? current : file;
    }

    @Override
    public void clearCache() {
        this.sqlFileMap.clear();
    }
}

