/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.seasar.doma.internal.Constants;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;

public final class IOUtil {
    protected static final int BUF_SIZE = 8192;

    public static String readAsString(InputStream inputStream) throws WrapException {
        AssertionUtil.assertNotNull(inputStream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Constants.UTF_8));
        StringBuilder buf = new StringBuilder(200);
        try {
            CharBuffer c = CharBuffer.allocate(8192);
            while (reader.read(c) > -1) {
                c.flip();
                buf.append(c);
                c.clear();
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        finally {
            IOUtil.close(reader);
        }
        return buf.toString();
    }

    public static String readAsString(File file) throws WrapException {
        String string;
        AssertionUtil.assertNotNull(file);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            string = IOUtil.readAsString(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new WrapException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
        }
        IOUtil.close(inputStream);
        return string;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean endsWith(File file, String pathname) {
        Path path = file.toPath();
        Path other = Paths.get(pathname, new String[0]);
        int i = path.getNameCount() - 1;
        for (int j = other.getNameCount() - 1; i >= 0 && j >= 0; --i, --j) {
            String otherElement;
            String element = path.getName(i).toString();
            if (element.equals(otherElement = other.getName(j).toString())) continue;
            return false;
        }
        return true;
    }
}

