/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.scalar;

import java.util.Optional;
import java.util.function.Supplier;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.wrapper.Wrapper;

public class OptionalBasicScalar<BASIC>
implements Scalar<BASIC, Optional<BASIC>> {
    protected final Wrapper<BASIC> wrapper;

    public OptionalBasicScalar(Wrapper<BASIC> wrapper) {
        AssertionUtil.assertNotNull(wrapper);
        this.wrapper = wrapper;
        AssertionUtil.assertNotNull(wrapper);
    }

    public OptionalBasicScalar(Supplier<Wrapper<BASIC>> supplier) {
        AssertionUtil.assertNotNull(supplier);
        this.wrapper = supplier.get();
        AssertionUtil.assertNotNull(this.wrapper);
    }

    @Override
    public Optional<Class<?>> getDomainClass() {
        return Optional.empty();
    }

    @Override
    public Optional<BASIC> cast(Object value) {
        return (Optional)value;
    }

    @Override
    public Optional<BASIC> get() {
        return Optional.ofNullable(this.wrapper.get());
    }

    @Override
    public Object getAsNonOptional() {
        return ((Optional)this.get()).orElse(null);
    }

    @Override
    public Optional<BASIC> getDefault() {
        return Optional.empty();
    }

    @Override
    public void set(Optional<BASIC> optional) {
        if (optional == null) {
            this.wrapper.set(null);
        } else {
            this.wrapper.set(optional.orElse(null));
        }
    }

    @Override
    public Wrapper<BASIC> getWrapper() {
        return this.wrapper;
    }

    public String toString() {
        return this.wrapper.toString();
    }
}

