/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.AutoModifyQuery;
import org.seasar.doma.jdbc.query.DeleteQuery;

public class AutoDeleteQuery<ENTITY>
extends AutoModifyQuery<ENTITY>
implements DeleteQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoDeleteQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entityType);
        this.executable = true;
        this.preDelete();
        this.prepareSpecialPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preDelete() {
        AutoPreDeleteContext context = new AutoPreDeleteContext(this.entityType, this.method, this.config);
        this.entityType.preDelete(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareSql() {
        Property property;
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.DELETE, this.sqlLogType);
        builder.appendSql("delete from ");
        builder.appendSql(this.entityType.getQualifiedTableName(naming::apply, dialect::applyQuote));
        boolean whereClauseAppended = false;
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            whereClauseAppended = true;
            for (EntityPropertyType propertyType : this.idPropertyTypes) {
                Property property2 = propertyType.createProperty();
                property2.load(this.entity);
                builder.appendSql(propertyType.getColumnName(naming::apply, dialect::applyQuote));
                builder.appendSql(" = ");
                builder.appendParameter(property2.asInParameter());
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.versionPropertyType.createProperty();
            property.load(this.entity);
            builder.appendSql(this.versionPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        if (this.tenantIdPropertyType != null) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.tenantIdPropertyType.createProperty();
            property.load(this.entity);
            builder.appendSql(this.tenantIdPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        this.sql = builder.build(this::comment);
    }

    @Override
    public void complete() {
        this.postDelete();
    }

    protected void postDelete() {
        AutoPostDeleteContext context = new AutoPostDeleteContext(this.entityType, this.method, this.config);
        this.entityType.postDelete(this.entity, context);
        if (context.getNewEntity() != null) {
            this.entity = context.getNewEntity();
        }
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoPostDeleteContext<E>
    extends AbstractPostDeleteContext<E> {
        public AutoPostDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class AutoPreDeleteContext<E>
    extends AbstractPreDeleteContext<E> {
        public AutoPreDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }
}

