/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.seasar.doma.FetchType;
import org.seasar.doma.internal.jdbc.command.PreparedSqlParameterBinder;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionException;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.query.SelectQuery;

public class SelectCommand<RESULT>
implements Command<RESULT> {
    protected final SelectQuery query;
    protected final PreparedSql sql;
    protected final ResultSetHandler<RESULT> resultSetHandler;

    public SelectCommand(SelectQuery query, ResultSetHandler<RESULT> resultSetHandler) {
        AssertionUtil.assertNotNull((Object)query, resultSetHandler);
        this.query = query;
        this.sql = query.getSql();
        this.resultSetHandler = resultSetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RESULT execute() {
        Supplier<RESULT> supplier = null;
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            PreparedStatement preparedStatement = JdbcUtil.prepareStatement(connection, this.sql);
            try {
                this.log();
                this.setupOptions(preparedStatement);
                this.bindParameters(preparedStatement);
                supplier = this.executeQuery(preparedStatement);
            }
            catch (SQLException e) {
                Dialect dialect = this.query.getConfig().getDialect();
                throw new SqlExecutionException(this.query.getConfig().getExceptionSqlLogType(), this.sql, e, dialect.getRootCause(e));
            }
            finally {
                this.close(supplier, () -> JdbcUtil.close(preparedStatement, this.query.getConfig().getJdbcLogger()));
            }
        }
        finally {
            this.close(supplier, () -> JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger()));
        }
        return supplier.get();
    }

    protected void log() {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), this.sql);
    }

    protected void setupOptions(PreparedStatement preparedStatement) throws SQLException {
        if (this.query.getFetchSize() > 0) {
            preparedStatement.setFetchSize(this.query.getFetchSize());
        }
        if (this.query.getMaxRows() > 0) {
            preparedStatement.setMaxRows(this.query.getMaxRows());
        }
        if (this.query.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void bindParameters(PreparedStatement preparedStatement) throws SQLException {
        PreparedSqlParameterBinder binder = new PreparedSqlParameterBinder(this.query);
        binder.bind(preparedStatement, this.sql.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Supplier<RESULT> executeQuery(PreparedStatement preparedStatement) throws SQLException {
        Supplier<RESULT> supplier = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            Supplier<RESULT> supplier2 = supplier = this.handleResultSet(resultSet);
            return supplier2;
        }
        finally {
            this.close(supplier, () -> JdbcUtil.close(resultSet, this.query.getConfig().getJdbcLogger()));
        }
    }

    protected Supplier<RESULT> handleResultSet(ResultSet resultSet) throws SQLException {
        return this.resultSetHandler.handle(resultSet, this.query, (index, next) -> {
            if (index == -1L && !next.booleanValue() && this.query.isResultEnsured()) {
                PreparedSql sql = this.query.getSql();
                throw new NoResultException(this.query.getConfig().getExceptionSqlLogType(), sql);
            }
        });
    }

    protected void close(Supplier<RESULT> supplier, Runnable closeHandler) {
        if (supplier != null && this.query.isResultStream() && this.query.getFetchType() == FetchType.LAZY) {
            RESULT result = supplier.get();
            if (result instanceof Stream) {
                Stream stream = (Stream)result;
                stream.onClose(closeHandler);
            } else {
                closeHandler.run();
            }
        } else {
            closeHandler.run();
        }
    }
}

