/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.entity.NamingType;

public interface Naming {
    public static final Naming NONE = new Adapter(NamingType.NONE);
    public static final Naming LOWER_CASE = new Adapter(NamingType.LOWER_CASE);
    public static final Naming UPPER_CASE = new Adapter(NamingType.UPPER_CASE);
    public static final Naming SNAKE_LOWER_CASE = new Adapter(NamingType.SNAKE_LOWER_CASE);
    public static final Naming SNAKE_UPPER_CASE = new Adapter(NamingType.SNAKE_UPPER_CASE);
    public static final Naming LENIENT_SNAKE_LOWER_CASE = new Adapter(NamingType.LENIENT_SNAKE_LOWER_CASE);
    public static final Naming LENIENT_SNAKE_UPPER_CASE = new Adapter(NamingType.LENIENT_SNAKE_UPPER_CASE);
    public static final Naming DEFAULT = NONE;

    public String apply(NamingType var1, String var2);

    public String revert(NamingType var1, String var2);

    public static class Adapter
    implements Naming {
        protected final NamingType namingType;

        private Adapter(NamingType namingType) {
            if (namingType == null) {
                throw new DomaNullPointerException("namingType");
            }
            this.namingType = namingType;
        }

        @Override
        public String apply(NamingType namingType, String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            if (namingType == null) {
                return this.namingType.apply(text);
            }
            return namingType.apply(text);
        }

        @Override
        public String revert(NamingType namingType, String text) {
            if (text == null) {
                throw new DomaNullPointerException("text");
            }
            if (namingType == null) {
                return this.namingType.revert(text);
            }
            return namingType.revert(text);
        }
    }
}

