/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NonUniqueResultException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.command.ResultSetRowIndexConsumer;
import org.seasar.doma.jdbc.query.SelectQuery;

public abstract class AbstractSingleResultHandler<RESULT>
implements ResultSetHandler<RESULT> {
    protected final ResultSetHandler<RESULT> handler;

    public AbstractSingleResultHandler(ResultSetHandler<RESULT> handler) {
        AssertionUtil.assertNotNull(handler);
        this.handler = handler;
    }

    @Override
    public Supplier<RESULT> handle(ResultSet resultSet, SelectQuery query, ResultSetRowIndexConsumer consumer) throws SQLException {
        Supplier<RESULT> result = this.handler.handle(resultSet, query, (index, next) -> {
            consumer.accept(index, next);
            if (index == 0L && next.booleanValue()) {
                PreparedSql sql = query.getSql();
                throw new NonUniqueResultException(query.getConfig().getExceptionSqlLogType(), sql);
            }
        });
        return result;
    }
}

