/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.ExternalDomain;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.generator.ExternalDomainDescGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMeta;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractGeneratingProcessor;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.ExternalDomain"})
@SupportedOptions(value={"doma.version.validation", "doma.resources.dir", "doma.test", "doma.debug", "doma.config.path"})
public class ExternalDomainProcessor
extends AbstractGeneratingProcessor<ExternalDomainMeta> {
    public ExternalDomainProcessor() {
        super(ExternalDomain.class);
    }

    protected ExternalDomainMetaFactory createTypeElementMetaFactory() {
        return new ExternalDomainMetaFactory(this.ctx);
    }

    @Override
    protected ClassName createClassName(TypeElement typeElement, ExternalDomainMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name name = this.ctx.getNames().createExternalDomainName(meta.asType());
        return ClassNames.newExternalDomainDescClassName(name);
    }

    @Override
    protected Generator createGenerator(ClassName className, Printer printer, ExternalDomainMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new ExternalDomainDescGenerator(this.ctx, className, printer, meta);
    }
}

