/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Domain;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.generator.DomainDescGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.domain.DomainMeta;
import org.seasar.doma.internal.apt.meta.domain.DomainMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractGeneratingProcessor;
import org.seasar.doma.internal.util.AssertionUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Domain"})
@SupportedOptions(value={"doma.version.validation", "doma.resources.dir", "doma.lombok.Value", "doma.test", "doma.debug", "doma.config.path"})
public class DomainProcessor
extends AbstractGeneratingProcessor<DomainMeta> {
    public DomainProcessor() {
        super(Domain.class);
    }

    protected DomainMetaFactory createTypeElementMetaFactory() {
        return new DomainMetaFactory(this.ctx);
    }

    @Override
    protected ClassName createClassName(TypeElement typeElement, DomainMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newDomainDescClassName(binaryName);
    }

    @Override
    protected Generator createGenerator(ClassName className, Printer printer, DomainMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new DomainDescGenerator(this.ctx, className, printer, meta);
    }
}

