/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.message.Message;

public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    protected Class<? extends Annotation> supportedAnnotationType;
    protected Context ctx;

    protected AbstractProcessor(Class<? extends Annotation> supportedAnnotationType) {
        this.supportedAnnotationType = supportedAnnotationType;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.ctx = new Context(processingEnv);
        this.ctx.init();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected void handleTypeElement(TypeElement typeElement, Consumer<TypeElement> handler) {
        Annotation annotation = typeElement.getAnnotation(this.supportedAnnotationType);
        if (annotation == null) {
            return;
        }
        if (this.ctx.getOptions().isDebugEnabled()) {
            this.ctx.getReporter().debug(Message.DOMA4090, new Object[]{this.getClass().getName(), typeElement.getQualifiedName()});
        }
        try {
            handler.accept(typeElement);
        }
        catch (AptException e) {
            this.ctx.getReporter().report(e);
        }
        catch (AptIllegalOptionException e) {
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, e.getMessage(), typeElement);
            throw e;
        }
        catch (AptIllegalStateException e) {
            String stackTrace = this.getStackTraceAsString(e);
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, Message.DOMA4039, typeElement, new Object[]{stackTrace});
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            String stackTrace = this.getStackTraceAsString((Throwable)e);
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, Message.DOMA4016, typeElement, new Object[]{stackTrace});
            throw e;
        }
        if (this.ctx.getOptions().isDebugEnabled()) {
            this.ctx.getReporter().debug(Message.DOMA4091, new Object[]{this.getClass().getName(), typeElement.getQualifiedName()});
        }
    }

    private String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return ((Object)stringWriter).toString();
    }
}

