/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.GeneratedValue;
import org.seasar.doma.Id;
import org.seasar.doma.SequenceGenerator;
import org.seasar.doma.TableGenerator;
import org.seasar.doma.TenantId;
import org.seasar.doma.Version;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.ColumnAnnot;
import org.seasar.doma.internal.apt.annot.SequenceGeneratorAnnot;
import org.seasar.doma.internal.apt.annot.TableGeneratorAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.id.IdentityIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.SequenceIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.id.TableIdGeneratorMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class EntityPropertyMetaFactory {
    private final Context ctx;
    private final EntityMeta entityMeta;
    private final VariableElement fieldElement;

    public EntityPropertyMetaFactory(Context ctx, EntityMeta entityMeta, VariableElement fieldElement) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)entityMeta, (Object)fieldElement);
        this.ctx = ctx;
        this.entityMeta = entityMeta;
        this.fieldElement = fieldElement;
    }

    public EntityPropertyMeta createEntityPropertyMeta() {
        AssertionUtil.assertNotNull((Object)this.fieldElement, (Object)this.entityMeta);
        TypeElement entityElement = this.ctx.getMoreElements().toTypeElement(this.fieldElement.getEnclosingElement());
        if (entityElement == null) {
            throw new AptIllegalStateException(this.fieldElement.toString());
        }
        CtType ctType = this.ctx.getCtTypes().newCtType(this.fieldElement.asType(), new CtTypeValidator());
        String fieldPrefix = this.ctx.getOptions().getEntityFieldPrefix();
        EntityPropertyMeta propertyMeta = new EntityPropertyMeta(ctType, fieldPrefix);
        this.doName(propertyMeta);
        this.doId(propertyMeta);
        this.doVersion(propertyMeta);
        this.doTenantId(propertyMeta);
        this.doColumn(propertyMeta);
        return propertyMeta;
    }

    private void doName(EntityPropertyMeta propertyMeta) {
        String name = this.fieldElement.getSimpleName().toString();
        if (name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, this.fieldElement, new Object[]{"__"});
        }
        propertyMeta.setName(name);
    }

    private void doId(EntityPropertyMeta propertyMeta) {
        Id id = this.fieldElement.getAnnotation(Id.class);
        if (id == null) {
            GeneratedValue generatedValue = this.fieldElement.getAnnotation(GeneratedValue.class);
            if (generatedValue == null) {
                this.validateSequenceGeneratorNotExistent(propertyMeta);
                this.validateTableGeneratorNotExistent(propertyMeta);
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4033, this.fieldElement, new Object[0]);
        }
        if (propertyMeta.isEmbedded()) {
            throw new AptException((MessageResource)Message.DOMA4302, this.fieldElement, new Object[0]);
        }
        propertyMeta.setId(true);
        GeneratedValue generatedValue = this.fieldElement.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            this.validateSequenceGeneratorNotExistent(propertyMeta);
            this.validateTableGeneratorNotExistent(propertyMeta);
            return;
        }
        if (propertyMeta.isEmbedded()) {
            throw new AptException((MessageResource)Message.DOMA4303, this.fieldElement, new Object[0]);
        }
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            throw new AptException((MessageResource)Message.DOMA4037, this.fieldElement, new Object[0]);
        }
        if (!this.isNumber(propertyMeta.getCtType())) {
            throw new AptException((MessageResource)Message.DOMA4095, this.fieldElement, new Object[0]);
        }
        switch (generatedValue.strategy()) {
            case IDENTITY: {
                this.doIdentityIdGeneratorMeta(propertyMeta);
                break;
            }
            case SEQUENCE: {
                this.doSequenceIdGeneratorMeta(propertyMeta);
                break;
            }
            case TABLE: {
                this.doTableIdGeneratorMeta(propertyMeta);
                break;
            }
            default: {
                AssertionUtil.assertUnreachable();
            }
        }
    }

    private void validateSequenceGeneratorNotExistent(EntityPropertyMeta propertyMeta) {
        SequenceGenerator sequenceGenerator = this.fieldElement.getAnnotation(SequenceGenerator.class);
        if (sequenceGenerator != null) {
            throw new AptException((MessageResource)Message.DOMA4030, this.fieldElement, new Object[0]);
        }
    }

    private void validateTableGeneratorNotExistent(EntityPropertyMeta propertyMeta) {
        TableGenerator tableGenerator = this.fieldElement.getAnnotation(TableGenerator.class);
        if (tableGenerator != null) {
            throw new AptException((MessageResource)Message.DOMA4031, this.fieldElement, new Object[0]);
        }
    }

    private void doIdentityIdGeneratorMeta(EntityPropertyMeta propertyMeta) {
        propertyMeta.setIdGeneratorMeta(new IdentityIdGeneratorMeta());
    }

    private void doSequenceIdGeneratorMeta(EntityPropertyMeta propertyMeta) {
        SequenceGeneratorAnnot sequenceGeneratorAnnot = this.ctx.getAnnotations().newSequenceGeneratorAnnot(this.fieldElement);
        if (sequenceGeneratorAnnot == null) {
            throw new AptException((MessageResource)Message.DOMA4034, this.fieldElement, new Object[0]);
        }
        this.validateSequenceIdGenerator(propertyMeta, sequenceGeneratorAnnot);
        SequenceIdGeneratorMeta idGeneratorMeta = new SequenceIdGeneratorMeta(sequenceGeneratorAnnot);
        propertyMeta.setIdGeneratorMeta(idGeneratorMeta);
    }

    private void validateSequenceIdGenerator(EntityPropertyMeta propertyMeta, SequenceGeneratorAnnot sequenceGeneratorAnnot) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(sequenceGeneratorAnnot.getImplementerValue());
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4170, this.fieldElement, sequenceGeneratorAnnot.getAnnotationMirror(), sequenceGeneratorAnnot.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
        ExecutableElement constructor = this.ctx.getMoreElements().getNoArgConstructor(typeElement);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4171, this.fieldElement, sequenceGeneratorAnnot.getAnnotationMirror(), sequenceGeneratorAnnot.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
    }

    private void doTableIdGeneratorMeta(EntityPropertyMeta propertyMeta) {
        TableGeneratorAnnot tableGeneratorAnnot = this.ctx.getAnnotations().newTableGeneratorAnnot(this.fieldElement);
        if (tableGeneratorAnnot == null) {
            throw new AptException((MessageResource)Message.DOMA4035, this.fieldElement, new Object[0]);
        }
        this.validateTableIdGenerator(propertyMeta, tableGeneratorAnnot);
        TableIdGeneratorMeta idGeneratorMeta = new TableIdGeneratorMeta(tableGeneratorAnnot);
        propertyMeta.setIdGeneratorMeta(idGeneratorMeta);
    }

    private void validateTableIdGenerator(EntityPropertyMeta propertyMeta, TableGeneratorAnnot tableGeneratorAnnot) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(tableGeneratorAnnot.getImplementerValue());
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4168, this.fieldElement, tableGeneratorAnnot.getAnnotationMirror(), tableGeneratorAnnot.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
        ExecutableElement constructor = this.ctx.getMoreElements().getNoArgConstructor(typeElement);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4169, this.fieldElement, tableGeneratorAnnot.getAnnotationMirror(), tableGeneratorAnnot.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
    }

    private void doVersion(EntityPropertyMeta propertyMeta) {
        Version version = this.fieldElement.getAnnotation(Version.class);
        if (version != null) {
            if (propertyMeta.isEmbedded()) {
                throw new AptException((MessageResource)Message.DOMA4304, this.fieldElement, new Object[0]);
            }
            if (this.entityMeta.hasVersionPropertyMeta()) {
                throw new AptException((MessageResource)Message.DOMA4024, this.fieldElement, new Object[0]);
            }
            if (!this.isNumber(propertyMeta.getCtType())) {
                throw new AptException((MessageResource)Message.DOMA4093, this.fieldElement, new Object[0]);
            }
            propertyMeta.setVersion(true);
        }
    }

    private void doTenantId(EntityPropertyMeta propertyMeta) {
        TenantId tenantId = this.fieldElement.getAnnotation(TenantId.class);
        if (tenantId != null) {
            if (propertyMeta.isEmbedded()) {
                throw new AptException((MessageResource)Message.DOMA4441, this.fieldElement, new Object[0]);
            }
            if (this.entityMeta.hasTenantIdPropertyMeta()) {
                throw new AptException((MessageResource)Message.DOMA4442, this.fieldElement, new Object[0]);
            }
            propertyMeta.setTenantId(true);
        }
    }

    private void doColumn(EntityPropertyMeta propertyMeta) {
        ColumnAnnot columnAnnot = this.ctx.getAnnotations().newColumnAnnot(this.fieldElement);
        if (columnAnnot == null) {
            return;
        }
        if (propertyMeta.isEmbedded()) {
            throw new AptException((MessageResource)Message.DOMA4306, (Element)this.fieldElement, columnAnnot.getAnnotationMirror(), new Object[0]);
        }
        if (propertyMeta.isId() || propertyMeta.isVersion()) {
            if (!columnAnnot.getInsertableValue()) {
                throw new AptException((MessageResource)Message.DOMA4088, this.fieldElement, columnAnnot.getAnnotationMirror(), columnAnnot.getInsertable(), new Object[0]);
            }
            if (!columnAnnot.getUpdatableValue()) {
                throw new AptException((MessageResource)Message.DOMA4089, this.fieldElement, columnAnnot.getAnnotationMirror(), columnAnnot.getUpdatable(), new Object[0]);
            }
        }
        propertyMeta.setColumnAnnot(columnAnnot);
    }

    private boolean isNumber(CtType ctType) {
        Boolean isNumber = ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

            @Override
            public Boolean visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
                return ctType.getElementCtType().accept(this, p);
            }

            @Override
            public Boolean visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                return ctType.getBasicCtType().accept(this, p);
            }

            @Override
            public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                TypeMirror boxedType = EntityPropertyMetaFactory.this.ctx.getMoreTypes().boxIfPrimitive(ctType.getType());
                return EntityPropertyMetaFactory.this.ctx.getMoreTypes().isAssignableWithErasure(boxedType, Number.class);
            }
        }, null);
        return isNumber == Boolean.TRUE;
    }

    private class CtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, AptException> {
        private CtTypeValidator() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void aVoid) throws AptException {
            throw new AptException((MessageResource)Message.DOMA4096, EntityPropertyMetaFactory.this.fieldElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitEmbeddableCtType(EmbeddableCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType optionalCtType, Void aVoid) throws AptException {
            if (optionalCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4232, EntityPropertyMetaFactory.this.fieldElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            if (optionalCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4233, EntityPropertyMetaFactory.this.fieldElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType domainCtType, Void aVoid) throws AptException {
            if (domainCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4204, EntityPropertyMetaFactory.this.fieldElement, new Object[]{domainCtType.getQualifiedName()});
            }
            if (domainCtType.hasWildcard() || domainCtType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4205, EntityPropertyMetaFactory.this.fieldElement, new Object[]{domainCtType.getQualifiedName()});
            }
            return null;
        }
    }
}

