/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.AccessLevel;
import org.seasar.doma.AnnotationTarget;
import org.seasar.doma.internal.apt.annot.AnnotateWithAnnot;
import org.seasar.doma.internal.apt.annot.AnnotationAnnot;
import org.seasar.doma.internal.apt.annot.DaoAnnot;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.dao.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.util.AssertionUtil;

public class DaoMeta
implements TypeElementMeta {
    private final List<QueryMeta> queryMetas = new ArrayList<QueryMeta>();
    private final DaoAnnot daoAnnot;
    private AnnotateWithAnnot annotateWithAnnot;
    private TypeMirror type;
    private TypeElement typeElement;
    private String name;
    private boolean error;
    private ParentDaoMeta parentDaoMeta;
    private String singletonMethodName;
    private String singletonFieldName;

    public DaoMeta(DaoAnnot daoAnnot) {
        AssertionUtil.assertNotNull(daoAnnot);
        this.daoAnnot = daoAnnot;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public void setType(TypeMirror type) {
        this.type = type;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    public void addQueryMeta(QueryMeta queryMeta) {
        this.queryMetas.add(queryMeta);
    }

    public List<QueryMeta> getQueryMetas() {
        return this.queryMetas;
    }

    public boolean hasUserDefinedConfig() {
        return this.daoAnnot.hasUserDefinedConfig();
    }

    DaoAnnot getDaoAnnot() {
        return this.daoAnnot;
    }

    public TypeMirror getConfigType() {
        return this.daoAnnot.getConfigValue();
    }

    public AccessLevel getAccessLevel() {
        return this.daoAnnot.getAccessLevelValue();
    }

    public AnnotateWithAnnot getAnnotateWithAnnot() {
        return this.annotateWithAnnot;
    }

    public void setAnnotateWithAnnot(AnnotateWithAnnot annotateWithAnnot) {
        this.annotateWithAnnot = annotateWithAnnot;
    }

    public List<AnnotationAnnot> getAnnotationMirrors(AnnotationTarget target) {
        AssertionUtil.assertNotNull((Object)target);
        if (this.annotateWithAnnot == null || this.annotateWithAnnot.getAnnotationsValue() == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationAnnot> results = new ArrayList<AnnotationAnnot>();
        for (AnnotationAnnot annotationAnnot : this.annotateWithAnnot.getAnnotationsValue()) {
            if (!target.name().contentEquals(annotationAnnot.getTargetValue().getSimpleName())) continue;
            results.add(annotationAnnot);
        }
        return results;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public ParentDaoMeta getParentDaoMeta() {
        return this.parentDaoMeta;
    }

    public void setParentDaoMeta(ParentDaoMeta parentDaoMeta) {
        this.parentDaoMeta = parentDaoMeta;
    }

    public String getSingletonMethodName() {
        return this.singletonMethodName;
    }

    public void setSingletonMethodName(String singletonMethodName) {
        this.singletonMethodName = singletonMethodName;
    }

    public String getSingletonFieldName() {
        return this.singletonFieldName;
    }

    public void setSingletonFieldName(String singletonFieldName) {
        this.singletonFieldName = singletonFieldName;
    }
}

