/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.FetchType;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.SelectType;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.dao.DaoMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.CallableSqlParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.CallableSqlParameterMetaVisitor;
import org.seasar.doma.internal.apt.meta.parameter.DomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.EntityListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.EntityResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.MapListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.MapResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongResultListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongSingleResultParameterMeta;
import org.seasar.doma.internal.apt.meta.query.AbstractCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.ArrayCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoModuleQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoProcedureQueryMeta;
import org.seasar.doma.internal.apt.meta.query.BlobCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.ClobCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.DefaultQueryMeta;
import org.seasar.doma.internal.apt.meta.query.NClobCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryMetaVisitor;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.SQLXMLCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileScriptQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileSelectQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlProcessorQueryMeta;
import org.seasar.doma.internal.jdbc.command.AbstractSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.BasicCollectorHandler;
import org.seasar.doma.internal.jdbc.command.BasicResultListHandler;
import org.seasar.doma.internal.jdbc.command.BasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.BasicStreamHandler;
import org.seasar.doma.internal.jdbc.command.DomainCollectorHandler;
import org.seasar.doma.internal.jdbc.command.DomainResultListHandler;
import org.seasar.doma.internal.jdbc.command.DomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.DomainStreamHandler;
import org.seasar.doma.internal.jdbc.command.EntityCollectorHandler;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.EntityStreamHandler;
import org.seasar.doma.internal.jdbc.command.MapCollectorHandler;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.internal.jdbc.command.MapSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.MapStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalBasicStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDomainStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalDoubleStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalEntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalIntStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongCollectorHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongResultListHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.OptionalLongStreamHandler;
import org.seasar.doma.internal.jdbc.command.OptionalMapSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.ScalarCollectorHandler;
import org.seasar.doma.internal.jdbc.command.ScalarResultListHandler;
import org.seasar.doma.internal.jdbc.command.ScalarSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.ScalarStreamHandler;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainResultListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListParameter;
import org.seasar.doma.internal.jdbc.sql.EntityResultListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListParameter;
import org.seasar.doma.internal.jdbc.sql.MapResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalBasicSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDomainSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalDoubleSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalIntSingleResultParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongInOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongInParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongOutParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongResultListParameter;
import org.seasar.doma.internal.jdbc.sql.OptionalLongSingleResultParameter;
import org.seasar.doma.internal.util.AssertionUtil;

public class DaoImplMethodGenerator
extends AbstractGenerator
implements QueryMetaVisitor<Void> {
    private final DaoMeta daoMeta;
    private final QueryMeta queryMeta;
    private final String methodName;

    DaoImplMethodGenerator(Context ctx, ClassName className, Printer printer, DaoMeta daoMeta, QueryMeta queryMeta, int index) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)daoMeta, (Object)queryMeta);
        this.daoMeta = daoMeta;
        this.queryMeta = queryMeta;
        this.methodName = "__method" + index;
    }

    @Override
    public void generate() {
        this.printMethod();
    }

    private void printMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public ", new Object[0]);
        if (!this.queryMeta.getTypeParameterNames().isEmpty()) {
            this.print("<%1$s> ", this.queryMeta.getTypeParameterNames());
        }
        this.print("%1$s %2$s(", this.queryMeta.getReturnMeta().getType(), this.queryMeta.getName());
        Iterator<QueryParameterMeta> it = this.queryMeta.getParameterMetas().iterator();
        while (it.hasNext()) {
            QueryParameterMeta parameterMeta = it.next();
            String parameterTypeName = this.ctx.getMoreTypes().getTypeName(parameterMeta.getType());
            if (!it.hasNext() && this.queryMeta.isVarArgs()) {
                parameterTypeName = parameterTypeName.replace("[]", "...");
            }
            this.print("%1$s %2$s", parameterTypeName, parameterMeta.getName());
            if (!it.hasNext()) continue;
            this.print(", ", new Object[0]);
        }
        this.print(") ", new Object[0]);
        if (!this.queryMeta.getThrownTypes().isEmpty()) {
            this.print("throws %1$s ", this.queryMeta.getThrownTypes());
        }
        this.print("{%n", new Object[0]);
        this.indent();
        this.queryMeta.accept(this);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    @Override
    public Void visitSqlFileSelectQueryMeta(SqlFileSelectQueryMeta m) {
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setSqlFilePath(\"%1$s\");%n", m.getPath());
        if (m.getSelectOptionsCtType() != null) {
            this.iprint("__query.setOptions(%1$s);%n", m.getSelectOptionsParameterName());
        }
        if (m.getEntityCtType() != null) {
            this.iprint("__query.setEntityType(%1$s);%n", m.getEntityCtType().getDescCode());
        }
        this.printAddParameterStatements(m.getParameterMetas());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setResultEnsured(%1$s);%n", m.getEnsureResult());
        this.iprint("__query.setResultMappingEnsured(%1$s);%n", m.getEnsureResultMapping());
        if (m.getSelectStrategyType() == SelectType.RETURN) {
            this.iprint("__query.setFetchType(%1$s.%2$s);%n", new Object[]{FetchType.class, FetchType.LAZY});
        } else {
            this.iprint("__query.setFetchType(%1$s.%2$s);%n", new Object[]{FetchType.class, m.getFetchType()});
        }
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setMaxRows(%1$s);%n", m.getMaxRows());
        this.iprint("__query.setFetchSize(%1$s);%n", m.getFetchSize());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        if (m.isResultStream()) {
            this.iprint("__query.setResultStream(true);%n", new Object[0]);
        }
        this.iprint("__query.prepare();%n", new Object[0]);
        QueryReturnMeta returnMeta = m.getReturnMeta();
        if (m.getSelectStrategyType() == SelectType.RETURN) {
            CtType returnCtType = returnMeta.getCtType();
            returnCtType.accept(new SqlFileSelectQueryReturnCtTypeVisitor(m), false);
            this.iprint("%1$s __result = __command.execute();%n", returnMeta.getType());
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
            this.iprint("return __result;%n", new Object[0]);
        } else {
            if (m.getSelectStrategyType() == SelectType.STREAM) {
                FunctionCtType functionCtType = m.getFunctionCtType();
                functionCtType.getTargetCtType().accept(new SqlFileSelectQueryFunctionCtTypeVisitor(m), null);
            } else if (m.getSelectStrategyType() == SelectType.COLLECT) {
                CollectorCtType collectorCtType = m.getCollectorCtType();
                collectorCtType.getTargetCtType().accept(new SqlFileSelectQueryCollectorCtTypeVisitor(m), false);
            }
            if (returnMeta.getType().getKind() == TypeKind.VOID) {
                this.iprint("__command.execute();%n", new Object[0]);
                this.iprint("__query.complete();%n", new Object[0]);
                this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", this.className, m.getName());
            } else {
                this.iprint("%1$s __result = __command.execute();%n", returnMeta.getType());
                this.iprint("__query.complete();%n", new Object[0]);
                this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
                this.iprint("return __result;%n", new Object[0]);
            }
        }
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitSqlFileScriptQueryMeta(SqlFileScriptQueryMeta m) {
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setScriptFilePath(\"%1$s\");%n", m.getPath());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setBlockDelimiter(\"%1$s\");%n", m.getBlockDelimiter());
        this.iprint("__query.setHaltOnError(%1$s);%n", m.getHaltOnError());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), this.methodName);
        this.iprint("__command.execute();%n", new Object[0]);
        this.iprint("__query.complete();%n", new Object[0]);
        this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", this.className, m.getName());
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitAutoModifyQueryMeta(AutoModifyQueryMeta m) {
        Boolean suppressOptimisticLockException;
        Boolean includeUnchanged;
        List<String> exclude;
        List<String> include;
        Boolean ignoreVersion;
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%4$s(%5$s, %3$s);%n", m.getQueryClass().getName(), m.getEntityCtType().getType(), m.getEntityCtType().getDescCode(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setEntity(%1$s);%n", m.getEntityParameterName());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        Boolean excludeNull = m.getExcludeNull();
        if (excludeNull != null) {
            this.iprint("__query.setNullExcluded(%1$s);%n", excludeNull);
        }
        if ((ignoreVersion = m.getIgnoreVersion()) != null) {
            this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
        }
        if ((include = m.getInclude()) != null) {
            this.iprint("__query.setIncludedPropertyNames(%1$s);%n", this.toConstants(include));
        }
        if ((exclude = m.getExclude()) != null) {
            this.iprint("__query.setExcludedPropertyNames(%1$s);%n", this.toConstants(exclude));
        }
        if ((includeUnchanged = m.getIncludeUnchanged()) != null) {
            this.iprint("__query.setUnchangedPropertyIncluded(%1$s);%n", includeUnchanged);
        }
        if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
            this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
        }
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), this.methodName);
        EntityCtType entityCtType = m.getEntityCtType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            this.iprint("int __count = __command.execute();%n", new Object[0]);
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("%1$s __result = new %1$s(__count, __query.getEntity());%n", m.getReturnMeta().getType());
        } else {
            this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getType());
            this.iprint("__query.complete();%n", new Object[0]);
        }
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitSqlFileModifyQueryMeta(SqlFileModifyQueryMeta m) {
        Boolean suppressOptimisticLockException;
        Boolean includeUnchanged;
        List<String> exclude;
        List<String> include;
        Boolean ignoreVersion;
        Boolean excludeNull;
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setSqlFilePath(\"%1$s\");%n", m.getPath());
        this.printAddParameterStatements(m.getParameterMetas());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        if (m.getEntityParameterName() != null && m.getEntityCtType() != null) {
            this.iprint("__query.setEntityAndEntityType(\"%1$s\", %2$s, %3$s);%n", m.getEntityParameterName(), m.getEntityParameterName(), m.getEntityCtType().getDescCode());
        }
        if ((excludeNull = m.getExcludeNull()) != null) {
            this.iprint("__query.setNullExcluded(%1$s);%n", excludeNull);
        }
        if ((ignoreVersion = m.getIgnoreVersion()) != null) {
            this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
        }
        if ((include = m.getInclude()) != null) {
            this.iprint("__query.setIncludedPropertyNames(%1$s);%n", this.toConstants(include));
        }
        if ((exclude = m.getExclude()) != null) {
            this.iprint("__query.setExcludedPropertyNames(%1$s);%n", this.toConstants(exclude));
        }
        if ((includeUnchanged = m.getIncludeUnchanged()) != null) {
            this.iprint("__query.setUnchangedPropertyIncluded(%1$s);%n", includeUnchanged);
        }
        if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
            this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
        }
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), this.methodName);
        EntityCtType entityCtType = m.getEntityCtType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            this.iprint("int __count = __command.execute();%n", new Object[0]);
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("%1$s __result = new %1$s(__count, __query.getEntity(%2$s.class));%n", m.getReturnMeta().getType(), entityCtType.getQualifiedName());
        } else {
            this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getType());
            this.iprint("__query.complete();%n", new Object[0]);
        }
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitAutoBatchModifyQueryMeta(AutoBatchModifyQueryMeta m) {
        Boolean suppressOptimisticLockException;
        List<String> exclude;
        List<String> include;
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%4$s(%5$s, %3$s);%n", m.getQueryClass().getName(), m.getEntityCtType().getType(), m.getEntityCtType().getDescCode(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setEntities(%1$s);%n", m.getEntitiesParameterName());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setBatchSize(%1$s);%n", m.getBatchSize());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        Boolean ignoreVersion = m.getIgnoreVersion();
        if (ignoreVersion != null) {
            this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
        }
        if ((include = m.getInclude()) != null) {
            this.iprint("__query.setIncludedPropertyNames(%1$s);%n", this.toConstants(include));
        }
        if ((exclude = m.getExclude()) != null) {
            this.iprint("__query.setExcludedPropertyNames(%1$s);%n", this.toConstants(exclude));
        }
        if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
            this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
        }
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), this.methodName);
        EntityCtType entityCtType = m.getEntityCtType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            this.iprint("int[] __counts = __command.execute();%n", new Object[0]);
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("%1$s __result = new %1$s(__counts, __query.getEntities());%n", m.getReturnMeta().getType());
        } else {
            this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getType());
            this.iprint("__query.complete();%n", new Object[0]);
        }
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitSqlFileBatchModifyQueryMeta(SqlFileBatchModifyQueryMeta m) {
        Boolean suppressOptimisticLockException;
        List<String> exclude;
        List<String> include;
        Boolean ignoreVersion;
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%4$s(%5$s, %3$s.class);%n", m.getQueryClass().getName(), m.getElementCtType().getType(), m.getElementCtType().getQualifiedName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setElements(%1$s);%n", m.getElementsParameterName());
        this.iprint("__query.setSqlFilePath(\"%1$s\");%n", m.getPath());
        this.iprint("__query.setParameterName(\"%1$s\");%n", m.getElementsParameterName());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setBatchSize(%1$s);%n", m.getBatchSize());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        if (m.getEntityType() != null) {
            this.iprint("__query.setEntityType(%1$s);%n", m.getEntityType().getDescCode());
        }
        if ((ignoreVersion = m.getIgnoreVersion()) != null) {
            this.iprint("__query.setVersionIgnored(%1$s);%n", ignoreVersion);
        }
        if ((include = m.getInclude()) != null) {
            this.iprint("__query.setIncludedPropertyNames(%1$s);%n", this.toConstants(include));
        }
        if ((exclude = m.getExclude()) != null) {
            this.iprint("__query.setExcludedPropertyNames(%1$s);%n", this.toConstants(exclude));
        }
        if ((suppressOptimisticLockException = m.getSuppressOptimisticLockException()) != null) {
            this.iprint("__query.setOptimisticLockExceptionSuppressed(%1$s);%n", suppressOptimisticLockException);
        }
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), this.methodName);
        EntityCtType entityCtType = m.getEntityType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            this.iprint("int[] __counts = __command.execute();%n", new Object[0]);
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("%1$s __result = new %1$s(__counts, __query.getEntities());%n", m.getReturnMeta().getType());
        } else {
            this.iprint("%1$s __result = __command.execute();%n", m.getReturnMeta().getType());
            this.iprint("__query.complete();%n", new Object[0]);
        }
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitAutoFunctionQueryMeta(AutoFunctionQueryMeta m) {
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        QueryReturnMeta returnMeta = m.getReturnMeta();
        this.iprint("%1$s<%2$s> __query = getQueryImplementors().create%3$s(%4$s);%n", m.getQueryClass().getName(), returnMeta.getBoxedType(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setCatalogName(\"%1$s\");%n", m.getCatalogName());
        this.iprint("__query.setSchemaName(\"%1$s\");%n", m.getSchemaName());
        this.iprint("__query.setFunctionName(\"%1$s\");%n", m.getFunctionName());
        this.iprint("__query.setQuoteRequired(%1$s);%n", m.isQuoteRequired());
        CallableSqlParameterStatementGenerator parameterGenerator = new CallableSqlParameterStatementGenerator();
        m.getResultParameterMeta().accept(parameterGenerator, m);
        for (CallableSqlParameterMeta parameterMeta : m.getCallableSqlParameterMetas()) {
            parameterMeta.accept(parameterGenerator, m);
        }
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query);%n", m.getCommandClass().getName(), returnMeta.getBoxedType(), m.getCommandClass().getSimpleName(), this.methodName);
        this.iprint("%1$s __result = __command.execute();%n", returnMeta.getType());
        this.iprint("__query.complete();%n", new Object[0]);
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitAutoProcedureQueryMeta(AutoProcedureQueryMeta m) {
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setCatalogName(\"%1$s\");%n", m.getCatalogName());
        this.iprint("__query.setSchemaName(\"%1$s\");%n", m.getSchemaName());
        this.iprint("__query.setProcedureName(\"%1$s\");%n", m.getProcedureName());
        this.iprint("__query.setQuoteRequired(%1$s);%n", m.isQuoteRequired());
        CallableSqlParameterStatementGenerator parameterGenerator = new CallableSqlParameterStatementGenerator();
        for (CallableSqlParameterMeta parameterMeta : m.getCallableSqlParameterMetas()) {
            parameterMeta.accept(parameterGenerator, m);
        }
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setQueryTimeout(%1$s);%n", m.getQueryTimeout());
        this.iprint("__query.setSqlLogType(%1$s.%2$s);%n", new Object[]{((Object)((Object)m.getSqlLogType())).getClass(), m.getSqlLogType()});
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s __command = getCommandImplementors().create%2$s(%3$s, __query);%n", m.getCommandClass().getName(), m.getCommandClass().getSimpleName(), this.methodName);
        this.iprint("__command.execute();%n", new Object[0]);
        this.iprint("__query.complete();%n", new Object[0]);
        this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", this.className, m.getName());
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitArrayCreateQueryMeta(ArrayCreateQueryMeta m) {
        this.printArrayCreateEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        QueryReturnMeta resultMeta = m.getReturnMeta();
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.setTypeName(\"%1$s\");%n", m.getArrayTypeName());
        this.iprint("__query.setElements(%1$s);%n", m.getParameterName());
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query);%n", m.getCommandClass().getName(), resultMeta.getBoxedType(), m.getCommandClass().getSimpleName(), this.methodName);
        this.iprint("%1$s __result = __command.execute();%n", resultMeta.getType());
        this.iprint("__query.complete();%n", new Object[0]);
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitBlobCreateQueryMeta(BlobCreateQueryMeta m) {
        return this.visitAbstractCreateQueryMeta(m);
    }

    @Override
    public Void visitClobCreateQueryMeta(ClobCreateQueryMeta m) {
        return this.visitAbstractCreateQueryMeta(m);
    }

    @Override
    public Void visitNClobCreateQueryMeta(NClobCreateQueryMeta m) {
        return this.visitAbstractCreateQueryMeta(m);
    }

    @Override
    public Void visitSQLXMLCreateQueryMeta(SQLXMLCreateQueryMeta m) {
        return this.visitAbstractCreateQueryMeta(m);
    }

    private Void visitAbstractCreateQueryMeta(AbstractCreateQueryMeta m) {
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        QueryReturnMeta resultMeta = m.getReturnMeta();
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.prepare();%n", new Object[0]);
        this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query);%n", m.getCommandClass().getName(), resultMeta.getType(), m.getCommandClass().getSimpleName(), this.methodName);
        this.iprint("%1$s __result = __command.execute();%n", resultMeta.getType());
        this.iprint("__query.complete();%n", new Object[0]);
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        this.iprint("return __result;%n", new Object[0]);
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitDefaultQueryMeta(DefaultQueryMeta m) {
        this.printEnteringStatements(m);
        QueryReturnMeta resultMeta = m.getReturnMeta();
        if (resultMeta.getType().getKind() == TypeKind.VOID) {
            this.iprint("Object __result = null;%n", new Object[0]);
            this.iprint("", new Object[0]);
        } else {
            this.iprint("%1$s __result = ", resultMeta.getType());
        }
        this.print("%1$s.super.%2$s(", this.daoMeta.getTypeElement(), m.getName());
        Iterator<QueryParameterMeta> it = m.getParameterMetas().iterator();
        while (it.hasNext()) {
            QueryParameterMeta parameterMeta = it.next();
            this.print("%1$s", parameterMeta.getName());
            if (!it.hasNext()) continue;
            this.print(", ", new Object[0]);
        }
        this.print(");%n", new Object[0]);
        this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
        if (resultMeta.getType().getKind() != TypeKind.VOID) {
            this.iprint("return __result;%n", new Object[0]);
        }
        this.printThrowingStatements(m);
        return null;
    }

    @Override
    public Void visitSqlProcessorQueryMeta(SqlProcessorQueryMeta m) {
        this.printEnteringStatements(m);
        this.printPrerequisiteStatements(m);
        this.iprint("%1$s __query = getQueryImplementors().create%2$s(%3$s);%n", m.getQueryClass().getName(), m.getQueryClass().getSimpleName(), this.methodName);
        this.iprint("__query.setMethod(%1$s);%n", this.methodName);
        this.iprint("__query.setConfig(__config);%n", new Object[0]);
        this.iprint("__query.setSqlFilePath(\"%1$s\");%n", m.getPath());
        this.printAddParameterStatements(m.getParameterMetas());
        this.iprint("__query.setCallerClassName(\"%1$s\");%n", this.className);
        this.iprint("__query.setCallerMethodName(\"%1$s\");%n", m.getName());
        this.iprint("__query.prepare();%n", new Object[0]);
        QueryReturnMeta returnMeta = m.getReturnMeta();
        this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%3$s(%4$s, __query, %5$s);%n", m.getCommandClass().getName(), m.getBiFunctionCtType().getResultCtType().getType(), m.getCommandClass().getSimpleName(), this.methodName, m.getBiFunctionParameterName());
        if (returnMeta.getType().getKind() == TypeKind.VOID) {
            this.iprint("__command.execute();%n", new Object[0]);
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("exiting(\"%1$s\", \"%2$s\", null);%n", this.className, m.getName());
        } else {
            this.iprint("%1$s __result = __command.execute();%n", returnMeta.getType());
            this.iprint("__query.complete();%n", new Object[0]);
            this.iprint("exiting(\"%1$s\", \"%2$s\", __result);%n", this.className, m.getName());
            this.iprint("return __result;%n", new Object[0]);
        }
        this.printThrowingStatements(m);
        return null;
    }

    private void printEnteringStatements(QueryMeta m) {
        this.iprint("entering(\"%1$s\", \"%2$s\"", this.className, m.getName());
        for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
            if (parameterMeta.getType().getKind() != TypeKind.ARRAY) {
                this.print(", %1$s", parameterMeta.getName());
                continue;
            }
            this.print(", (Object) %1$s", parameterMeta.getName());
        }
        this.print(");%n", new Object[0]);
        this.iprint("try {%n", new Object[0]);
        this.indent();
    }

    private void printArrayCreateEnteringStatements(ArrayCreateQueryMeta m) {
        this.iprint("entering(\"%1$s\", \"%2$s\", (Object)%3$s);%n", this.className, m.getName(), m.getParameterName());
        this.iprint("try {%n", new Object[0]);
        this.indent();
    }

    private void printThrowingStatements(QueryMeta m) {
        this.unindent();
        this.iprint("} catch (%1$s __e) {%n", RuntimeException.class);
        this.indent();
        this.iprint("throwing(\"%1$s\", \"%2$s\", __e);%n", this.className, m.getName());
        this.iprint("throw __e;%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printPrerequisiteStatements(QueryMeta m) {
        for (QueryParameterMeta parameterMeta : m.getParameterMetas()) {
            if (parameterMeta.isNullable()) continue;
            String paramName = parameterMeta.getName();
            this.iprint("if (%1$s == null) {%n", paramName);
            this.iprint("    throw new %1$s(\"%2$s\");%n", DomaNullPointerException.class, paramName);
            this.iprint("}%n", new Object[0]);
        }
    }

    private void printAddParameterStatements(List<QueryParameterMeta> ParameterMetas) {
        for (final QueryParameterMeta parameterMeta : ParameterMetas) {
            if (!parameterMeta.isBindable()) continue;
            CtType ctType = parameterMeta.getCtType();
            ctType.accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(CtType ctType, Void p) {
                    DaoImplMethodGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s);%n", parameterMeta.getName(), ctType.getQualifiedName());
                    return null;
                }

                @Override
                public Void visitOptionalCtType(OptionalCtType ctType, Void p) {
                    DaoImplMethodGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.orElse(null));%n", parameterMeta.getName(), ctType.getElementCtType().getQualifiedName());
                    return null;
                }

                @Override
                public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) {
                    DaoImplMethodGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.isPresent() ? %1$s.getAsInt() : null);%n", parameterMeta.getName(), Integer.class);
                    return null;
                }

                @Override
                public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) {
                    DaoImplMethodGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.isPresent() ? %1$s.getAsLong() : null);%n", parameterMeta.getName(), Long.class);
                    return null;
                }

                @Override
                public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) {
                    DaoImplMethodGenerator.this.iprint("__query.addParameter(\"%1$s\", %2$s.class, %1$s.isPresent() ? %1$s.getAsDouble() : null);%n", parameterMeta.getName(), Double.class);
                    return null;
                }
            }, null);
        }
    }

    private List<String> toConstants(List<String> values) {
        return values.stream().map(this.ctx.getMoreElements()::getConstantExpression).collect(Collectors.toList());
    }

    private class SqlFileSelectQueryReturnCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Boolean, RuntimeException> {
        private final SqlFileSelectQueryMeta m;
        private final TypeMirror resultBoxedType;
        private final Class<?> commandClass;
        private final String commandName;

        private SqlFileSelectQueryReturnCtTypeVisitor(SqlFileSelectQueryMeta m) {
            this.m = m;
            this.resultBoxedType = this.m.getReturnMeta().getBoxedType();
            this.commandClass = m.getCommandClass();
            this.commandName = m.getCommandClass().getSimpleName();
        }

        @Override
        public Void visitBasicCtType(BasicCtType basicCtType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%5$s>(%4$s));%n", this.commandClass, this.resultBoxedType, this.getBasicSingleResultHandler(optional), basicCtType.getWrapperSupplierCode(), basicCtType.getBoxedType(), this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%8$s, %5$s>(%4$s));%n", this.commandClass, this.resultBoxedType, this.getDomainSingleResultHandler(optional), ctType.getDescCode(), ctType.getType(), this.commandName, DaoImplMethodGenerator.this.methodName, ctType.getBasicCtType().getBoxedType());
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Boolean optional) {
            MapKeyNamingType namingType = this.m.getMapKeyNamingType();
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s(%4$s.%5$s));%n", this.commandClass, this.resultBoxedType, this.getMapSingleResultHandler(optional), namingType.getDeclaringClass().getName(), namingType.name(), this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%5$s>(%4$s));%n", this.commandClass, this.resultBoxedType, this.getEntitySingleResultHandler(optional), ctType.getDescCode(), ctType.getType(), this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Boolean optional) {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", this.commandClass, this.resultBoxedType, OptionalIntSingleResultHandler.class, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", this.commandClass, this.resultBoxedType, OptionalLongSingleResultHandler.class, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", this.commandClass, this.resultBoxedType, OptionalDoubleSingleResultHandler.class, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitIterableCtType(IterableCtType iterableCtType, Boolean __) {
            iterableCtType.getElementCtType().accept(new SimpleCtTypeVisitor<Void, Boolean, RuntimeException>(){

                @Override
                public Void visitBasicCtType(BasicCtType basicCtType, Boolean optional) {
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%4$s>(%5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, SqlFileSelectQueryReturnCtTypeVisitor.this.getBasicResultListHandler(optional), basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName);
                    return null;
                }

                @Override
                public Void visitDomainCtType(DomainCtType ctType, Boolean optional) {
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%8$s, %4$s>(%5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, SqlFileSelectQueryReturnCtTypeVisitor.this.getDomainResultListHandler(optional), ctType.getType(), ctType.getDescCode(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName, ctType.getBasicCtType().getBoxedType());
                    return null;
                }

                @Override
                public Void visitMapCtType(MapCtType ctType, Boolean optional) {
                    MapKeyNamingType namingType = SqlFileSelectQueryReturnCtTypeVisitor.this.m.getMapKeyNamingType();
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s(%4$s.%5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, MapResultListHandler.class, namingType.getDeclaringClass().getName(), namingType.name(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName);
                    return null;
                }

                @Override
                public Void visitEntityCtType(EntityCtType ctType, Boolean optional) {
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%6$s(%7$s, __query, new %3$s<%4$s>(%5$s));%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, EntityResultListHandler.class, ctType.getType(), ctType.getDescCode(), SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName);
                    return null;
                }

                @Override
                public Void visitOptionalCtType(OptionalCtType ctType, Boolean __) {
                    return ctType.getElementCtType().accept(this, true);
                }

                @Override
                public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) {
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, OptionalIntResultListHandler.class, SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName);
                    return null;
                }

                @Override
                public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) {
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, OptionalLongResultListHandler.class, SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName);
                    return null;
                }

                @Override
                public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) {
                    DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%4$s(%5$s, __query, new %3$s());%n", SqlFileSelectQueryReturnCtTypeVisitor.this.commandClass, SqlFileSelectQueryReturnCtTypeVisitor.this.resultBoxedType, OptionalDoubleResultListHandler.class, SqlFileSelectQueryReturnCtTypeVisitor.this.commandName, DaoImplMethodGenerator.this.methodName);
                    return null;
                }
            }, false);
            return null;
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Boolean __) {
            ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(this.m, this.resultBoxedType, this.commandClass, this.commandName, Function.class.getName() + ".identity()"), false);
            return null;
        }

        private Class<? extends ScalarSingleResultHandler> getBasicSingleResultHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicSingleResultHandler.class;
            }
            return BasicSingleResultHandler.class;
        }

        private Class<? extends ScalarResultListHandler> getBasicResultListHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicResultListHandler.class;
            }
            return BasicResultListHandler.class;
        }

        private Class<? extends ScalarSingleResultHandler> getDomainSingleResultHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainSingleResultHandler.class;
            }
            return DomainSingleResultHandler.class;
        }

        private Class<? extends ScalarResultListHandler> getDomainResultListHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainResultListHandler.class;
            }
            return DomainResultListHandler.class;
        }

        private Class<? extends AbstractSingleResultHandler<?>> getMapSingleResultHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalMapSingleResultHandler.class;
            }
            return MapSingleResultHandler.class;
        }

        private Class<? extends AbstractSingleResultHandler> getEntitySingleResultHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalEntitySingleResultHandler.class;
            }
            return EntitySingleResultHandler.class;
        }
    }

    private class SqlFileSelectQueryCollectorCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Boolean, RuntimeException> {
        private final SqlFileSelectQueryMeta m;
        private final QueryReturnMeta resultMeta;
        private final Class<?> commandClass;
        private final String commandName;
        private final String collectorParamName;

        private SqlFileSelectQueryCollectorCtTypeVisitor(SqlFileSelectQueryMeta m) {
            this.m = m;
            this.resultMeta = m.getReturnMeta();
            this.commandClass = m.getCommandClass();
            this.commandName = m.getCommandClass().getSimpleName();
            this.collectorParamName = m.getCollectorParameterName();
        }

        @Override
        public Void visitBasicCtType(BasicCtType basicCtType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s, %6$s));%n", this.commandClass, this.resultMeta.getBoxedType(), this.getBasicCollectorHandler(optional), basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%9$s, %4$s, %2$s>(%5$s, %6$s));%n", this.commandClass, this.resultMeta.getBoxedType(), this.getDomainCollectorHandler(optional), ctType.getType(), ctType.getDescCode(), this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName, ctType.getBasicCtType().getBoxedType());
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Boolean optional) {
            MapKeyNamingType namingType = this.m.getMapKeyNamingType();
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%2$s>(%4$s.%5$s, %6$s));%n", this.commandClass, this.resultMeta.getBoxedType(), MapCollectorHandler.class, namingType.getDeclaringClass().getName(), namingType.name(), this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s, %6$s));%n", this.commandClass, this.resultMeta.getBoxedType(), EntityCollectorHandler.class, ctType.getType(), ctType.getDescCode(), this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Boolean optional) {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClass, this.resultMeta.getBoxedType(), OptionalIntCollectorHandler.class, this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClass, this.resultMeta.getBoxedType(), OptionalLongCollectorHandler.class, this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClass, this.resultMeta.getBoxedType(), OptionalDoubleCollectorHandler.class, this.collectorParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        private Class<? extends ScalarCollectorHandler> getBasicCollectorHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicCollectorHandler.class;
            }
            return BasicCollectorHandler.class;
        }

        private Class<? extends ScalarCollectorHandler> getDomainCollectorHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainCollectorHandler.class;
            }
            return DomainCollectorHandler.class;
        }
    }

    private class StreamElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Boolean, RuntimeException> {
        private final SqlFileSelectQueryMeta m;
        private final TypeMirror resultBoxedType;
        private final Class<?> commandClass;
        private final String commandName;
        private final String functionParamName;

        private StreamElementCtTypeVisitor(SqlFileSelectQueryMeta m, TypeMirror resultBoxedType, Class<?> commandClass, String commandName, String functionParamName) {
            this.m = m;
            this.resultBoxedType = resultBoxedType;
            this.commandClass = commandClass;
            this.commandName = commandName;
            this.functionParamName = functionParamName;
        }

        @Override
        public Void visitBasicCtType(BasicCtType basicCtType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s, %6$s));%n", this.commandClass, this.resultBoxedType, this.getBasicStreamHandler(optional), basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%9$s, %4$s, %2$s>(%5$s, %6$s));%n", this.commandClass, this.resultBoxedType, this.getDomainStreamHandler(optional), ctType.getType(), ctType.getDescCode(), this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName, ctType.getBasicCtType().getBoxedType());
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Boolean optional) {
            MapKeyNamingType namingType = this.m.getMapKeyNamingType();
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%2$s>(%4$s.%5$s, %6$s));%n", this.commandClass, this.resultBoxedType, MapStreamHandler.class, namingType.getDeclaringClass(), namingType.name(), this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Boolean optional) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%7$s(%8$s, __query, new %3$s<%4$s, %2$s>(%5$s, %6$s));%n", this.commandClass, this.resultBoxedType, EntityStreamHandler.class, ctType.getType(), ctType.getDescCode(), this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Boolean optional) {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClass, this.resultBoxedType, OptionalIntStreamHandler.class, this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClass, this.resultBoxedType, OptionalLongStreamHandler.class, this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) {
            DaoImplMethodGenerator.this.iprint("%1$s<%2$s> __command = getCommandImplementors().create%5$s(%6$s, __query, new %3$s<%2$s>(%4$s));%n", this.commandClass, this.resultBoxedType, OptionalDoubleStreamHandler.class, this.functionParamName, this.commandName, DaoImplMethodGenerator.this.methodName);
            return null;
        }

        private Class<? extends ScalarStreamHandler> getBasicStreamHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalBasicStreamHandler.class;
            }
            return BasicStreamHandler.class;
        }

        private Class<? extends ScalarStreamHandler> getDomainStreamHandler(Boolean optional) {
            if (Boolean.TRUE == optional) {
                return OptionalDomainStreamHandler.class;
            }
            return DomainStreamHandler.class;
        }
    }

    private class SqlFileSelectQueryFunctionCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        private final SqlFileSelectQueryMeta m;
        private final QueryReturnMeta resultMeta;
        private final Class<?> commandClass;
        private final String commandName;
        private final String functionParamName;

        private SqlFileSelectQueryFunctionCtTypeVisitor(SqlFileSelectQueryMeta m) {
            this.m = m;
            this.resultMeta = m.getReturnMeta();
            this.commandClass = m.getCommandClass();
            this.commandName = m.getCommandClass().getSimpleName();
            this.functionParamName = m.getFunctionParameterName();
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) {
            ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(this.m, this.resultMeta.getBoxedType(), this.commandClass, this.commandName, this.functionParamName), false);
            return null;
        }
    }

    private class CallableSqlParameterStatementGenerator
    implements CallableSqlParameterMetaVisitor<Void, AutoModuleQueryMeta> {
        private CallableSqlParameterStatementGenerator() {
        }

        @Override
        public Void visitBasicListParameterMeta(BasicListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s, \"%4$s\"));%n", BasicListParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), m.getName());
            return null;
        }

        @Override
        public Void visitDomainListParameterMeta(DomainListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s, \"%5$s\"));%n", DomainListParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitEntityListParameterMeta(EntityListParameterMeta m, AutoModuleQueryMeta p) {
            EntityCtType entityCtType = m.getEntityCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s, \"%4$s\", %5$s));%n", EntityListParameter.class, entityCtType.getType(), entityCtType.getDescCode(), m.getName(), m.getEnsureResultMapping());
            return null;
        }

        @Override
        public Void visitMapListParameterMeta(MapListParameterMeta m, AutoModuleQueryMeta p) {
            MapKeyNamingType namingType = p.getMapKeyNamingType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s.%3$s, %4$s, \"%4$s\"));%n", MapListParameter.class, namingType.getDeclaringClass().getName(), namingType.name(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicInOutParameterMeta(BasicInOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s));%n", BasicInOutParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), m.getName());
            return null;
        }

        @Override
        public Void visitDomainInOutParameterMeta(DomainInOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainInOutParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicOutParameterMeta(BasicOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s));%n", BasicOutParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), m.getName());
            return null;
        }

        @Override
        public Void visitDomainOutParameterMeta(DomainOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainOutParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicInParameterMeta(BasicInParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%4$s>(%2$s, %3$s));%n", BasicInParameter.class, basicCtType.getWrapperSupplierCode(), m.getName(), basicCtType.getBoxedType());
            return null;
        }

        @Override
        public Void visitDomainInParameterMeta(DomainInParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", DomainInParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitBasicResultListParameterMeta(BasicResultListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s));%n", BasicResultListParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode());
            return null;
        }

        @Override
        public Void visitDomainResultListParameterMeta(DomainResultListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", DomainResultListParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode());
            return null;
        }

        @Override
        public Void visitEntityResultListParameterMeta(EntityResultListParameterMeta m, AutoModuleQueryMeta p) {
            EntityCtType entityCtType = m.getEntityCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s, %4$s));%n", EntityResultListParameter.class, entityCtType.getType(), entityCtType.getDescCode(), m.getEnsureResultMapping());
            return null;
        }

        @Override
        public Void visitMapResultListParameterMeta(MapResultListParameterMeta m, AutoModuleQueryMeta p) {
            MapKeyNamingType namingType = p.getMapKeyNamingType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s(%2$s.%3$s));%n", MapResultListParameter.class, namingType.getDeclaringClass().getName(), namingType.name());
            return null;
        }

        @Override
        public Void visitBasicSingleResultParameterMeta(BasicSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s));%n", BasicSingleResultParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode());
            return null;
        }

        @Override
        public Void visitDomainSingleResultParameterMeta(DomainSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", DomainSingleResultParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode());
            return null;
        }

        @Override
        public Void visitOptionalBasicInParameterMeta(OptionalBasicInParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%4$s>(%2$s, %3$s));%n", OptionalBasicInParameter.class, basicCtType.getWrapperSupplierCode(), m.getName(), basicCtType.getBoxedType());
            return null;
        }

        @Override
        public Void visitOptionalBasicOutParameterMeta(OptionalBasicOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s));%n", OptionalBasicOutParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalBasicInOutParameterMeta(OptionalBasicInOutParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s));%n", OptionalBasicInOutParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalBasicListParameterMeta(OptionalBasicListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s>(%3$s, %4$s, \"%4$s\"));%n", OptionalBasicListParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalBasicSingleResultParameterMeta(OptionalBasicSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s));%n", OptionalBasicSingleResultParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode());
            return null;
        }

        @Override
        public Void visitOptionalBasicResultListParameterMeta(OptionalBasicResultListParameterMeta m, AutoModuleQueryMeta p) {
            BasicCtType basicCtType = m.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s>(%3$s));%n", OptionalBasicResultListParameter.class, basicCtType.getBoxedType(), basicCtType.getWrapperSupplierCode());
            return null;
        }

        @Override
        public Void visitOptionalDomainInParameterMeta(OptionalDomainInParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", OptionalDomainInParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainOutParameterMeta(OptionalDomainOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", OptionalDomainOutParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainInOutParameterMeta(OptionalDomainInOutParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s));%n", OptionalDomainInOutParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainListParameterMeta(OptionalDomainListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s<%2$s, %3$s>(%4$s, %5$s, \"%5$s\"));%n", OptionalDomainListParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode(), m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDomainSingleResultParameterMeta(OptionalDomainSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", OptionalDomainSingleResultParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode());
            return null;
        }

        @Override
        public Void visitOptionalDomainResultListParameterMeta(OptionalDomainResultListParameterMeta m, AutoModuleQueryMeta p) {
            DomainCtType domainCtType = m.getDomainCtType();
            BasicCtType basicCtType = domainCtType.getBasicCtType();
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s<%2$s, %3$s>(%4$s));%n", OptionalDomainResultListParameter.class, basicCtType.getBoxedType(), domainCtType.getType(), domainCtType.getDescCode());
            return null;
        }

        @Override
        public Void visitOptionalIntInOutParameterMeta(OptionalIntInOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalIntInOutParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntInParameterMeta(OptionalIntInParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalIntInParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntListParameterMeta(OptionalIntListParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s, \"%2$s\"));%n", OptionalIntListParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntOutParameterMeta(OptionalIntOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalIntOutParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalIntSingleResultParameterMeta(OptionalIntSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalIntSingleResultParameter.class);
            return null;
        }

        @Override
        public Void visitOptionalIntResultListParameterMeta(OptionalIntResultListParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalIntResultListParameter.class);
            return null;
        }

        @Override
        public Void visitOptionalLongOutParameterMeta(OptionalLongOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalLongOutParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongSingleResultParameterMeta(OptionalLongSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalLongSingleResultParameter.class);
            return null;
        }

        @Override
        public Void visitOptionalLongResultListParameterMeta(OptionalLongResultListParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalLongResultListParameter.class);
            return null;
        }

        @Override
        public Void visitOptionalLongInOutParameterMeta(OptionalLongInOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalLongInOutParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongInParameterMeta(OptionalLongInParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalLongInParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalLongListParameterMeta(OptionalLongListParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s, \"%2$s\"));%n", OptionalLongListParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleOutParameterMeta(OptionalDoubleOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalDoubleOutParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleSingleResultParameterMeta(OptionalDoubleSingleResultParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalDoubleSingleResultParameter.class);
            return null;
        }

        @Override
        public Void visitOptionalDoubleResultListParameterMeta(OptionalDoubleResultListParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.setResultParameter(new %1$s());%n", OptionalDoubleResultListParameter.class);
            return null;
        }

        @Override
        public Void visitOptionalDoubleInOutParameterMeta(OptionalDoubleInOutParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalDoubleInOutParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleInParameterMeta(OptionalDoubleInParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s));%n", OptionalDoubleInParameter.class, m.getName());
            return null;
        }

        @Override
        public Void visitOptionalDoubleListParameterMeta(OptionalDoubleListParameterMeta m, AutoModuleQueryMeta p) {
            DaoImplMethodGenerator.this.iprint("__query.addParameter(new %1$s(%2$s, \"%2$s\"));%n", OptionalDoubleListParameter.class, m.getName());
            return null;
        }
    }
}

