/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.function.Function;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.sql.DataSource;
import org.seasar.doma.AnnotationTarget;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.AnnotationAnnot;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.apt.generator.DaoImplMethodGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.dao.DaoMeta;
import org.seasar.doma.internal.apt.meta.dao.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.jdbc.dao.AbstractDao;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;

public class DaoImplGenerator
extends AbstractGenerator {
    private final DaoMeta daoMeta;
    private final Function<TypeElement, ClassName> classNameProvider;

    public DaoImplGenerator(Context ctx, ClassName className, Printer printer, DaoMeta daoMeta, Function<TypeElement, ClassName> classNameProvider) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)daoMeta, classNameProvider);
        this.daoMeta = daoMeta;
        this.classNameProvider = classNameProvider;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        for (AnnotationAnnot annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CLASS)) {
            this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.printGenerated();
        this.iprint("%4$s class %1$s extends %2$s implements %3$s {%n", this.simpleName, this.getParentClassName(), this.daoMeta.getType(), this.daoMeta.getAccessLevel().getModifier());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printStaticFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.print("}%n", new Object[0]);
    }

    private CharSequence getParentClassName() {
        ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
        return parentDaoMeta == null ? AbstractDao.class.getName() : (CharSequence)this.classNameProvider.apply(parentDaoMeta.getTypeElement());
    }

    private void printStaticFields() {
        int index = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            QueryKind kind = queryMeta.getQueryKind();
            if (kind != QueryKind.DEFAULT) {
                this.iprint("private static final %1$s __method%2$s = %3$s.getDeclaredMethod(%4$s.class, \"%5$s\"", Method.class, index, AbstractDao.class, this.daoMeta.getTypeElement(), queryMeta.getName());
                for (QueryParameterMeta parameterMeta : queryMeta.getParameterMetas()) {
                    this.print(", %1$s.class", parameterMeta.getQualifiedName());
                }
                this.print(");%n", new Object[0]);
                this.print("%n", new Object[0]);
            }
            ++index;
        }
    }

    private void printConstructors() {
        if (this.daoMeta.hasUserDefinedConfig()) {
            Code configCode = this.createConfigCode();
            this.printNoArgConstructor(configCode);
            if (this.daoMeta.getAnnotateWithAnnot() == null) {
                boolean required = this.areJdbcConstructorsRequired();
                if (required) {
                    this.printConnectionArgConstructor(configCode);
                    this.printDataSourceArgConstructor(configCode);
                }
                this.printConfigArgConstructor();
                if (required) {
                    this.printConfigAndConnectionArgsConstructor();
                    this.printConfigAndDataSourceArgsConstructor();
                }
            } else {
                this.printAnnotatedConstructor();
            }
        } else {
            this.printAnnotatedConstructor();
        }
    }

    private boolean areJdbcConstructorsRequired() {
        ParentDaoMeta parentDaoMeta = this.daoMeta.getParentDaoMeta();
        return parentDaoMeta == null || parentDaoMeta.hasUserDefinedConfig();
    }

    private Code createConfigCode() {
        TypeMirror type = this.daoMeta.getConfigType();
        String method = this.daoMeta.getSingletonMethodName();
        String field = this.daoMeta.getSingletonFieldName();
        return new Code(p -> {
            if (method == null) {
                if (field == null) {
                    p.print("new %1$s()", type);
                } else {
                    p.print("%1$s.%2$s", type, field);
                }
            } else {
                p.print("%1$s.%2$s()", type, method);
            }
        });
    }

    private void printNoArgConstructor(Code configCode) {
        this.iprint("/** */%n", new Object[0]);
        this.iprint("public %1$s() {%n", this.simpleName);
        this.iprint("    super(%1$s);%n", configCode);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printConnectionArgConstructor(Code configCode) {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param connection the connection%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public %1$s(%2$s connection) {%n", this.simpleName, Connection.class);
        this.iprint("    super(%1$s, connection);%n", configCode);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printDataSourceArgConstructor(Code configCode) {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param dataSource the dataSource%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public %1$s(%2$s dataSource) {%n", this.simpleName, DataSource.class);
        this.iprint("    super(%1$s, dataSource);%n", configCode);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printConfigArgConstructor() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param config the configuration%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("protected %1$s(%2$s config) {%n", this.simpleName, Config.class);
        this.iprint("    super(config);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printConfigAndConnectionArgsConstructor() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param config the configuration%n", new Object[0]);
        this.iprint(" * @param connection the connection%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("protected %1$s(%2$s config, %3$s connection) {%n", this.simpleName, Config.class, Connection.class);
        this.indent();
        this.iprint("super(config, connection);%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printConfigAndDataSourceArgsConstructor() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param config the configuration%n", new Object[0]);
        this.iprint(" * @param dataSource the dataSource%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("protected %1$s(%2$s config, %3$s dataSource) {%n", this.simpleName, Config.class, DataSource.class);
        this.indent();
        this.iprint("super(config, dataSource);%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printAnnotatedConstructor() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param config the config%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        for (AnnotationAnnot annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR)) {
            this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.iprint("public %1$s(", this.simpleName);
        for (AnnotationAnnot annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR_PARAMETER)) {
            this.print("@%1$s(%2$s) ", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.print("%1$s config) {%n", Config.class);
        this.indent();
        this.iprint("super(config);%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        int index = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            DaoImplMethodGenerator generator = new DaoImplMethodGenerator(this.ctx, this.className, this.printer, this.daoMeta, queryMeta, index);
            generator.generate();
            ++index;
        }
    }
}

