/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class ValueAnnot
extends AbstractAnnot {
    private static final String STATIC_CONSTRUCTOR = "staticConstructor";
    private final AnnotationValue staticConstructor;

    ValueAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.staticConstructor = AssertionUtil.assertNonNullValue(values, STATIC_CONSTRUCTOR);
    }

    public AnnotationValue getStaticConstructor() {
        return this.staticConstructor;
    }

    public String getStaticConstructorValue() {
        String value = AnnotationValueUtil.toString(this.staticConstructor);
        if (value == null) {
            throw new AptIllegalStateException(STATIC_CONSTRUCTOR);
        }
        return value;
    }
}

