/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class SingletonConfigAnnot
extends AbstractAnnot {
    private static final String METHOD = "method";
    private final AnnotationValue method;

    SingletonConfigAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.method = AssertionUtil.assertNonNullValue(values, METHOD);
    }

    public AnnotationValue getMethod() {
        return this.method;
    }

    public String getMethodValue() {
        String methodName = AnnotationValueUtil.toString(this.method);
        if (methodName == null) {
            throw new AptIllegalStateException(METHOD);
        }
        return methodName;
    }
}

