/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import org.seasar.doma.internal.Artifact;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.util.AssertionUtil;

public final class Options {
    public static final String TEST = "doma.test";
    public static final String DEBUG = "doma.debug";
    public static final String DAO_PACKAGE = "doma.dao.package";
    public static final String DAO_SUBPACKAGE = "doma.dao.subpackage";
    public static final String DAO_SUFFIX = "doma.dao.suffix";
    public static final String ENTITY_FIELD_PREFIX = "doma.entity.field.prefix";
    public static final String EXPR_FUNCTIONS = "doma.expr.functions";
    public static final String DOMAIN_CONVERTERS = "doma.domain.converters";
    public static final String SQL_VALIDATION = "doma.sql.validation";
    public static final String VERSION_VALIDATION = "doma.version.validation";
    public static final String CONFIG_PATH = "doma.config.path";
    public static final String RESOURCES_DIR = "doma.resources.dir";
    public static final String LOMBOK_ALL_ARGS_CONSTRUCTOR = "doma.lombok.AllArgsConstructor";
    public static final String LOMBOK_VALUE = "doma.lombok.Value";
    private final Context ctx;
    private final Map<String, String> options;
    private final Map<String, Map<String, String>> configCache = new ConcurrentHashMap<String, Map<String, String>>();

    Options(Context ctx, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)env);
        this.ctx = ctx;
        this.options = env.getOptions();
    }

    public boolean isTestEnabled() {
        String test = this.getOption(TEST);
        return Boolean.valueOf(test);
    }

    public String getVersion() {
        if (this.isTestEnabled()) {
            return "@VERSION@";
        }
        return Artifact.getVersion();
    }

    public Date getDate() {
        if (this.isTestEnabled()) {
            return new Date(0L);
        }
        return new Date();
    }

    public boolean isDebugEnabled() {
        String debug = this.getOption(DEBUG);
        return Boolean.valueOf(debug);
    }

    public String getDaoPackage() {
        return this.getOption(DAO_PACKAGE);
    }

    public String getDaoSubpackage() {
        return this.getOption(DAO_SUBPACKAGE);
    }

    public String getDaoSuffix() {
        String suffix = this.getOption(DAO_SUFFIX);
        return suffix != null ? suffix : "Impl";
    }

    public String getEntityFieldPrefix() {
        String prefix = this.getOption(ENTITY_FIELD_PREFIX);
        if ("none".equalsIgnoreCase(prefix)) {
            return "";
        }
        return prefix != null ? prefix : "$";
    }

    public String getExprFunctions() {
        return this.getOption(EXPR_FUNCTIONS);
    }

    public String getDomainConverters() {
        return this.getOption(DOMAIN_CONVERTERS);
    }

    public boolean getSqlValidation() {
        String v = this.getOption(SQL_VALIDATION);
        return v != null ? Boolean.valueOf(v) : true;
    }

    public boolean getVersionValidation() {
        String v = this.getOption(VERSION_VALIDATION);
        return v != null ? Boolean.valueOf(v) : true;
    }

    public String getConfigPath() {
        String configPath = this.options.get(CONFIG_PATH);
        return configPath != null ? configPath : "doma.compile.config";
    }

    public String getLombokAllArgsConstructor() {
        String name = this.getOption(LOMBOK_ALL_ARGS_CONSTRUCTOR);
        return name != null ? name : "lombok.AllArgsConstructor";
    }

    public String getLombokValue() {
        String name = this.getOption(LOMBOK_VALUE);
        return name != null ? name : "lombok.Value";
    }

    private String getOption(String key) {
        String v = this.options.get(key);
        if (v != null) {
            return v;
        }
        return this.getConfig().get(key);
    }

    private Map<String, String> getConfig() {
        FileObject config = this.getFileObject(this.getConfigPath());
        if (config == null) {
            return Collections.emptyMap();
        }
        return this.configCache.computeIfAbsent(config.toUri().getPath(), configPath -> {
            try {
                return this.loadProperties(config);
            }
            catch (IOException e) {
                return Collections.emptyMap();
            }
        });
    }

    private FileObject getFileObject(String path) {
        try {
            return this.ctx.getResources().getResource(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> loadProperties(FileObject config) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Constants {
        public static final String DEFAULT_DAO_SUFFIX = "Impl";
        public static final String DEFAULT_ENTITY_FIELD_PREFIX = "$";
        public static final String DEFAULT_CONFIG_PATH = "doma.compile.config";
        public static final String DEFAULT_LOMBOK_ALL_ARGS_CONSTRUCTOR = "lombok.AllArgsConstructor";
        public static final String DEFAULT_LOMBOK_VALUE = "lombok.Value";
    }
}

