/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.processor;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.kitec.modeljs.GeometryData;
import jp.kitec.modeljs.processor.Processor;
import jp.kitec.modeljs.processor.Stretch;
import jp.kitec.modeljs.util.GeomUtil;

public class StretchProcessor
extends Processor<Stretch> {
    private static final Vector3d[] elist = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 1.0)};

    @Override
    public GeometryData process(GeometryData gd, Stretch deform) {
        GeometryData cp = GeomUtil.copy(gd);
        Vector3d lower = new Vector3d();
        Vector3d upper = new Vector3d();
        Vector3d v = new Vector3d();
        Vector3d[] vector3dArray = elist;
        int n = elist.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3d axis = vector3dArray[n2];
            if (axis.epsilonEquals((Tuple3d)deform.axis, 0.0)) {
                lower.set((Tuple3d)axis);
                upper.set((Tuple3d)axis);
                lower.scale(-deform.diff / 2.0);
                upper.scale(deform.diff / 2.0);
            }
            ++n2;
        }
        float[] array = cp.attributes.position.array;
        int verticesLength = array.length / 3;
        int i = 0;
        while (i < verticesLength) {
            v.set((double)array[i * 3], (double)array[i * 3 + 1], (double)array[i * 3 + 2]);
            if (v.dot(deform.axis) < deform.c) {
                v.add((Tuple3d)lower);
            } else {
                v.add((Tuple3d)upper);
            }
            array[i * 3] = (float)v.x;
            array[i * 3 + 1] = (float)v.y;
            array[i * 3 + 2] = (float)v.z;
            ++i;
        }
        return cp;
    }
}

