/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.processor;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.kitec.modeljs.GeometryData;
import jp.kitec.modeljs.processor.Processor;
import jp.kitec.modeljs.processor.Stretch2;
import jp.kitec.modeljs.util.GeomUtil;

public class Stretch2Processor
extends Processor<Stretch2> {
    @Override
    public GeometryData process(GeometryData gd, Stretch2 deform) {
        GeometryData cp = GeomUtil.copy(gd);
        Vector3d v = new Vector3d();
        Vector3d work = new Vector3d();
        double dot0 = deform.axis.dot(deform.n);
        float[] array = cp.attributes.position.array;
        int vsize = array.length / 3;
        int i = 0;
        while (i < vsize) {
            v.set((double)array[i * 3], (double)array[i * 3 + 1], (double)array[i * 3 + 2]);
            double dot = deform.n.dot(v);
            if (deform.max < dot) {
                work.set((Tuple3d)deform.axis);
                work.scale(-(dot - deform.max) / dot0);
                v.add((Tuple3d)work);
                array[i * 3] = (float)v.x;
                array[i * 3 + 1] = (float)v.y;
                array[i * 3 + 2] = (float)v.z;
            }
            ++i;
        }
        return cp;
    }
}

