/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.model.converter;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.kitec.lib5.util.RefList;
import nethome5.presentation.primitive.GPoint2Df;
import nethome5.util.ToolMath;
import org.apache.commons.lang3.ArrayUtils;

public class ToolTesseTryangle {
    private static final int FLAG_COMPLEX = 1;
    private static final int FLAG_DISABLE = 2;
    private static final int FLAG_EXCEPTION = 4;
    private static final int MAX_TRIANGLE = 256;
    private static final int MAX_INTERSECTIONTEST = 5;
    private static final Vector3d ZERO_VECTOR = new Vector3d(0.0, 0.0, 0.0);
    public short[] mIndex = new short[1024];
    private int mIndexPt = 0;
    private short[] mSrc = new short[256];

    public short[] culcTryangles(Point3d[] vertices, Vector3d normal) {
        RefList<GPoint2Df> pts = null;
        pts = normal == null || normal.epsilonEquals((Tuple3d)ZERO_VECTOR, (double)0.001f) ? this.projection2D(vertices) : this.projection2D(vertices, normal);
        boolean res = this.culc(pts);
        return this.convTriangles();
    }

    public RefList<GPoint2Df> projection2D(Point3d[] vertices) {
        GPoint2Df firstP;
        int vNum = vertices.length;
        Point3d p0 = vertices[0];
        Point3d p1 = vertices[vNum - 1];
        Vector3d v10 = new Vector3d();
        v10.sub((Tuple3d)p0, (Tuple3d)p1);
        Vector3d v02 = null;
        Vector3d normal = new Vector3d();
        Vector3d zeroV = new Vector3d(0.0, 0.0, 0.0);
        boolean isRegular = false;
        int i = 1;
        while (i < vNum) {
            Point3d p2 = vertices[i];
            v02 = new Vector3d();
            v02.sub((Tuple3d)p2, (Tuple3d)p0);
            normal.cross(v10, v02);
            if (!normal.epsilonEquals((Tuple3d)zeroV, (double)0.001f)) {
                isRegular = true;
                break;
            }
            p1 = p0;
            p0 = p2;
            v10 = v02;
            ++i;
        }
        RefList pts = new RefList();
        if (!isRegular) {
            return pts;
        }
        normal.normalize();
        v02.scale(1.0 / v02.lengthSquared());
        Vector3d v03 = new Vector3d();
        v03.cross(normal, v02);
        Point3d[] point3dArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Point3d p = point3dArray[n2];
            Vector3d pp0 = new Vector3d();
            pp0.sub((Tuple3d)p, (Tuple3d)p0);
            pts.addElement((Object)new GPoint2Df((double)((float)pp0.dot(v02)), (double)((float)pp0.dot(v03))));
            ++n2;
        }
        double area = 0.0;
        GPoint2Df prevP = firstP = (GPoint2Df)pts.get(0);
        int i2 = 1;
        while (i2 < vNum) {
            GPoint2Df nextP = (GPoint2Df)pts.get(i2);
            area += prevP.x * nextP.y - nextP.x * prevP.y;
            prevP = nextP;
            ++i2;
        }
        if ((area += prevP.x * firstP.y - firstP.x * prevP.y) < (double)-0.001f) {
            for (GPoint2Df p : pts) {
                p.y *= -1.0;
            }
        }
        return pts;
    }

    public RefList<GPoint2Df> projection2D(Point3d[] vertices, Vector3d normal) {
        RefList pts = new RefList();
        if (vertices.length < 3) {
            return pts;
        }
        Point3d p0 = vertices[0];
        Vector3d v02 = new Vector3d();
        v02.sub((Tuple3d)vertices[1], (Tuple3d)p0);
        v02.scale(1.0 / v02.lengthSquared());
        Vector3d v03 = new Vector3d();
        v03.cross(normal, v02);
        Point3d[] point3dArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Point3d p = point3dArray[n2];
            Vector3d pp0 = new Vector3d();
            pp0.sub((Tuple3d)p, (Tuple3d)p0);
            pts.addElement((Object)new GPoint2Df((double)((float)pp0.dot(v02)), (double)((float)pp0.dot(v03))));
            ++n2;
        }
        return pts;
    }

    public short[] convTriangles() {
        short[] triangles = new short[this.mIndexPt * 3];
        int seq = 0;
        int head = 0;
        while (head < this.mIndexPt) {
            short polySize = this.mIndex[head];
            int start = head + 1;
            int end = start + polySize;
            int i = start + 2;
            while (i < end) {
                triangles[seq++] = this.mIndex[start];
                triangles[seq++] = this.mIndex[i - 1];
                triangles[seq++] = this.mIndex[i];
                ++i;
            }
            head = (short)(head + (polySize + 1));
        }
        return ArrayUtils.subarray((short[])triangles, (int)0, (int)seq);
    }

    public boolean culc(RefList<? extends GPoint2Df> pts) {
        this.mIndexPt = 0;
        this.mSrc = new short[pts.size()];
        int i = 0;
        while (i < pts.size()) {
            ((GPoint2Df)pts.elementAt((int)i)).wideUseFlag = 0;
            this.mSrc[i] = (short)i;
            ++i;
        }
        i = 0;
        while (i < this.mIndex.length) {
            this.mIndex[i] = 0;
            ++i;
        }
        return this.tessellation(pts, this.mSrc, pts.size());
    }

    private boolean tessellation(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
        if (length < 3) {
            return false;
        }
        if (length == 3) {
            this.mIndex[this.mIndexPt++] = (short)length;
            int i = 0;
            while (i < length) {
                this.mIndex[this.mIndexPt++] = src[i];
                ++i;
            }
            return false;
        }
        boolean complex = this.checkComplex(vtx, src, length);
        int i = 0;
        while (i < length) {
            if ((((GPoint2Df)vtx.elementAt((int)src[i])).wideUseFlag & 4) != 0) {
                int j = i;
                while (j < length - 1) {
                    src[j] = src[j + 1];
                    ++j;
                }
                --length;
                --i;
            }
            ++i;
        }
        if (complex) {
            this.division(vtx, src, length);
            return true;
        }
        this.mIndex[this.mIndexPt++] = (short)length;
        i = 0;
        while (i < length) {
            this.mIndex[this.mIndexPt++] = src[i];
            ++i;
        }
        return false;
    }

    private boolean checkComplex(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
        int complex = 0;
        int i = 0;
        while (i < length) {
            GPoint2Df v = (GPoint2Df)vtx.elementAt((int)src[i]);
            GPoint2Df v1 = (GPoint2Df)vtx.elementAt((int)src[i - 1 < 0 ? length - 1 : i - 1]);
            GPoint2Df v2 = (GPoint2Df)vtx.elementAt((int)src[i + 1 >= length ? 0 : i + 1]);
            float angl = (float)ToolMath.getAngle2Lines((double)v2.x, (double)v2.y, (double)v.x, (double)v.y, (double)v1.x, (double)v1.y);
            if (Math.abs((double)angl - Math.PI) < (double)0.001f) {
                v.wideUseFlag = (short)4;
            } else if ((double)angl <= Math.PI) {
                v.wideUseFlag = 0;
            } else {
                v.wideUseFlag = 1;
                ++complex;
            }
            ++i;
        }
        return complex != 0;
    }

    private void division(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
        GPoint2Df t;
        int i = 0;
        while (i < length) {
            if ((((GPoint2Df)vtx.elementAt((int)src[i])).wideUseFlag & 1) > 0) break;
            ++i;
        }
        int base = i;
        GPoint2Df v1 = (GPoint2Df)vtx.elementAt((int)src[base]);
        GPoint2Df v2 = (GPoint2Df)vtx.elementAt((int)src[base - 1 < 0 ? length - 1 : base - 1]);
        GPoint2Df v3 = (GPoint2Df)vtx.elementAt((int)src[base + 1 >= length ? 0 : base + 1]);
        v1.wideUseFlag = (short)(v1.wideUseFlag | 2);
        v2.wideUseFlag = (short)(v2.wideUseFlag | 2);
        v3.wideUseFlag = (short)(v3.wideUseFlag | 2);
        float angl1 = (float)ToolMath.getAngle2Lines((double)v3.x, (double)v3.y, (double)v1.x, (double)v1.y, (double)v2.x, (double)v2.y);
        i = 0;
        while (i < length) {
            float angl2;
            t = (GPoint2Df)vtx.elementAt((int)src[i]);
            if ((t.wideUseFlag & 2) == 0 && (angl2 = (float)ToolMath.getAngle2Lines((double)v3.x, (double)v3.y, (double)v1.x, (double)v1.y, (double)t.x, (double)t.y)) > angl1) {
                t.wideUseFlag = (short)(t.wideUseFlag | 2);
            }
            ++i;
        }
        if (length > 5) {
            i = 0;
            while (i < length) {
                t = (GPoint2Df)vtx.elementAt((int)src[i]);
                if ((t.wideUseFlag & 2) == 0) {
                    int j = 0;
                    while (j < length) {
                        if (this.intersection(v1, t, (GPoint2Df)vtx.elementAt((int)src[j]), (GPoint2Df)vtx.elementAt((int)src[(j + 1) % length]))) {
                            t.wideUseFlag = (short)(t.wideUseFlag | 2);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        float da = Float.MAX_VALUE;
        int target = -1;
        i = 0;
        while (i < length) {
            float angl2;
            float dat;
            GPoint2Df t2 = (GPoint2Df)vtx.elementAt((int)src[i]);
            if ((t2.wideUseFlag & 2) == 0 && (dat = Math.abs(angl1 / 2.0f - (angl1 - (angl2 = (float)ToolMath.getAngle2Lines((double)v3.x, (double)v3.y, (double)v1.x, (double)v1.y, (double)t2.x, (double)t2.y))))) < da) {
                da = dat;
                target = i;
            }
            ++i;
        }
        if (target < 0) {
            return;
        }
        short[] dst = new short[length];
        int p = base;
        i = 0;
        int c = 0;
        while (i < length) {
            dst[i] = src[p];
            ++c;
            if (p == target) break;
            if (++p >= length) {
                p = 0;
            }
            ++i;
        }
        this.tessellation(vtx, dst, c);
        i = 0;
        c = 0;
        while (i < length) {
            dst[i] = src[p];
            ++c;
            if (p == base) break;
            if (++p >= length) {
                p = 0;
            }
            ++i;
        }
        this.tessellation(vtx, dst, c);
    }

    private boolean intersection(GPoint2Df p1, GPoint2Df p2, GPoint2Df p3, GPoint2Df p4) {
        return ((p1.x - p2.x) * (p3.y - p1.y) + (p1.y - p2.y) * (p1.x - p3.x)) * ((p1.x - p2.x) * (p4.y - p1.y) + (p1.y - p2.y) * (p1.x - p4.x)) < 0.0 && ((p3.x - p4.x) * (p1.y - p3.y) + (p3.y - p4.y) * (p3.x - p1.x)) * ((p3.x - p4.x) * (p2.y - p3.y) + (p3.y - p4.y) * (p3.x - p2.x)) < 0.0;
    }
}

