/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Color;
import java.util.StringTokenizer;
import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathArc;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathLine;
import option.io.pdfcommon.path.PathLink;
import option.io.pdfcommon.path.PathMulti;
import option.io.pdfcommon.path.PathMultiElementBezier;
import option.io.pdfcommon.path.PathMultiElementClose;
import option.io.pdfcommon.path.PathMultiElementLine;
import option.io.pdfcommon.path.PathMultiElementMove;
import option.io.pdfcommon.path.PathPolygon;
import option.io.pdfcommon.path.PathPolyline;
import option.io.pdfcommon.path.PathRectangle;
import option.io.pdfcommon.path.PathText;

public class PdfDrawCommandParser
implements PdfDataConst {
    protected String mBase;

    public PdfDrawCommandParser(String string) {
        this.mBase = string;
    }

    public Path parseDrawCommand(String string) {
        Path path = null;
        Object object = new StringTokenizer(string, ", ");
        if (!((StringTokenizer)object).hasMoreTokens()) {
            return null;
        }
        if (((String)(object = ((StringTokenizer)object).nextToken().trim())).equals("line")) {
            path = this.createLine(string);
        } else if (((String)object).equals("text")) {
            path = this.createText(string);
        } else if (((String)object).equals("rect")) {
            path = this.createRect(string);
        } else if (((String)object).equals("arc")) {
            path = this.createArc(string);
        } else if (((String)object).equals("polygon")) {
            path = this.createPolygon(string);
        } else if (((String)object).equals("polyline")) {
            path = this.createPolyline(string);
        } else if (((String)object).equals("image")) {
            path = this.createImage(string);
        } else if (((String)object).equals("jpeg")) {
            path = this.createJpegImage(string);
        } else if (((String)object).equals("link")) {
            path = this.createLink(string);
        } else if (((String)object).equals("3d")) {
            path = this.create3D(string);
        }
        return path;
    }

    protected Path createArc(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n >= 14) {
            ((StringTokenizer)object).nextToken();
            float f = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f6 = Float.parseFloat(((StringTokenizer)object).nextToken()) - f5;
            Color color = this.parseColor((StringTokenizer)object);
            boolean bl = this.parseFill((StringTokenizer)object);
            float f7 = Float.parseFloat(((StringTokenizer)object).nextToken());
            return new PathArc(f, f2, f3, f4, f5, f6, new LineStyle(f7, new DashPattern(this.parseLinePattern((StringTokenizer)object))), color, bl);
        }
        return null;
    }

    protected PathImage createImage(String string) {
        return null;
    }

    protected Path createJpegImage(String string) {
        return null;
    }

    protected Path createLine(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n >= 11) {
            ((StringTokenizer)object).nextToken();
            float f = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
            Color color = this.parseColor((StringTokenizer)object);
            float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
            try {
                return new PathLine(f, f2, f3, f4, new LineStyle(f5, new DashPattern(this.parseLinePattern((StringTokenizer)object))), color);
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected Path createLink(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n != 7) {
            return null;
        }
        ((StringTokenizer)object).nextToken();
        String string = ((StringTokenizer)object).nextToken();
        float f = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
        return new PathLink(string, f, f2, f3, f4, f5);
    }

    protected Path createMultiPath(String object) {
        PathMulti pathMulti = new PathMulti();
        object = new StringTokenizer((String)object, "\r\n");
        while (((StringTokenizer)object).hasMoreElements()) {
            Object object2 = ((StringTokenizer)object).nextToken();
            Object object3 = ((StringTokenizer)(object2 = new StringTokenizer((String)object2, ", "))).nextToken();
            if (object3 == null) break;
            if (((String)object3).equalsIgnoreCase("moveto")) {
                float f = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f2 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                pathMulti.addPath(new PathMultiElementMove(f, f2));
                continue;
            }
            if (((String)object3).equalsIgnoreCase("lineto")) {
                float f = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f3 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                pathMulti.addPath(new PathMultiElementLine(f, f3));
                continue;
            }
            if (((String)object3).equalsIgnoreCase("bezier1")) {
                float f = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f4 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f5 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f6 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f7 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                float f8 = Float.parseFloat(((StringTokenizer)object2).nextToken());
                pathMulti.addPath(new PathMultiElementBezier(f, f4, f5, f6, f7, f8));
                continue;
            }
            if (((String)object3).equalsIgnoreCase("close")) {
                pathMulti.addPath(new PathMultiElementClose());
                continue;
            }
            if (((String)object3).equalsIgnoreCase("fill")) {
                pathMulti.addDrawFlag(2);
                int n = Integer.parseInt(((StringTokenizer)object2).nextToken());
                Color color = this.parseColor((StringTokenizer)object2);
                pathMulti.setWindingRule(n);
                pathMulti.setFillColor(color);
                continue;
            }
            if (((String)object3).equalsIgnoreCase("stroke")) {
                pathMulti.addDrawFlag(1);
                object3 = this.parseColor((StringTokenizer)object2);
                float f = Float.parseFloat(((StringTokenizer)object2).nextToken());
                LineStyle lineStyle = new LineStyle(f, new DashPattern(this.parseLinePattern((StringTokenizer)object2)));
                pathMulti.setStrokeColor((Color)object3);
                pathMulti.setLineStyle(lineStyle);
                continue;
            }
            if (!((String)object3).equalsIgnoreCase("shadestroke")) continue;
            pathMulti.addDrawFlag(4);
            object3 = ((StringTokenizer)object2).nextToken();
            float f = Float.parseFloat(((StringTokenizer)object2).nextToken());
            LineStyle lineStyle = new LineStyle(f, new DashPattern(this.parseLinePattern((StringTokenizer)object2)));
            pathMulti.setLineStyle(lineStyle);
            pathMulti.setShading((String)object3);
        }
        return pathMulti;
    }

    protected Path createPolygon(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n < 10) {
            return null;
        }
        ((StringTokenizer)object).nextToken();
        Color color = this.parseColor((StringTokenizer)object);
        boolean bl = this.parseFill((StringTokenizer)object);
        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
        float[] fArray = new float[n2 << 1];
        for (int i = 0; i < n2; ++i) {
            fArray[i << 1] = Float.parseFloat(((StringTokenizer)object).nextToken());
            fArray[(i << 1) + 1] = Float.parseFloat(((StringTokenizer)object).nextToken());
        }
        float f = Float.parseFloat(((StringTokenizer)object).nextToken());
        return new PathPolygon(fArray, new LineStyle(f, new DashPattern(this.parseLinePattern((StringTokenizer)object))), color, bl);
    }

    protected Path createPolyline(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n < 9) {
            return null;
        }
        ((StringTokenizer)object).nextToken();
        Color color = this.parseColor((StringTokenizer)object);
        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
        float[] fArray = new float[n2 << 1];
        for (int i = 0; i < n2; ++i) {
            fArray[i << 1] = Float.parseFloat(((StringTokenizer)object).nextToken());
            fArray[(i << 1) + 1] = Float.parseFloat(((StringTokenizer)object).nextToken());
        }
        float f = Float.parseFloat(((StringTokenizer)object).nextToken());
        return new PathPolyline(fArray, new LineStyle(f, new DashPattern(this.parseLinePattern((StringTokenizer)object))), color);
    }

    protected Path createRect(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n >= 12) {
            ((StringTokenizer)object).nextToken();
            float f = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
            Color color = this.parseColor((StringTokenizer)object);
            boolean bl = this.parseFill((StringTokenizer)object);
            float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
            return new PathRectangle(f < f3 ? f : f3, f2 < f4 ? f2 : f4, Math.abs(f3 - f), Math.abs(f4 - f2), new LineStyle(f5, new DashPattern(this.parseLinePattern((StringTokenizer)object))), color, bl);
        }
        return null;
    }

    protected PathText createText(String object) {
        int n = ((String)object).indexOf("#");
        int n2 = ((String)object).lastIndexOf("#");
        if (n < 0 || n2 < 0 || n == n2) {
            return null;
        }
        String string = ((String)object).substring(n + 1, n2);
        object = ((String)object).substring(n2 + 1, ((String)object).length());
        n2 = ((StringTokenizer)(object = new StringTokenizer((String)object, "*"))).countTokens();
        if (n2 < 7 || n2 > 14 || n2 == 12) {
            return null;
        }
        float f = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
        String string2 = ((StringTokenizer)object).nextToken().trim();
        float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
        Color color = this.parseColor((StringTokenizer)object);
        boolean bl = false;
        if (n2 > 7) {
            boolean bl2 = bl = Float.parseFloat(((StringTokenizer)object).nextToken()) > 0.0f;
        }
        if (n2 <= 8) {
            return new PathText(string, f, f2, string2, f3, color, bl);
        }
        int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
        if (n2 <= 9) {
            return new PathText(string, f, f2, string2, f3, color, bl, n3);
        }
        float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f5 = 0.0f;
        if (n2 > 10) {
            f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
        }
        if (n2 <= 11) {
            return new PathText(string, f, f2, string2, f3, color, bl, n3, f4, f5);
        }
        float f6 = Float.parseFloat(((StringTokenizer)object).nextToken());
        String string3 = ((StringTokenizer)object).nextToken().trim();
        if (n2 == 13) {
            return new PathText(string, f, f2, string2, f3, color, bl, n3, f4, f5, f6, string3);
        }
        boolean bl3 = Float.parseFloat(((StringTokenizer)object).nextToken()) > 0.0f;
        return new PathText(string, f, f2, string2, f3, color, bl, n3, f4, f5, f6, string3, bl3);
    }

    protected Path create3D(String string) {
        return null;
    }

    protected float[] parseLinePattern(StringTokenizer stringTokenizer) {
        int n = stringTokenizer.countTokens();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
        }
        return fArray;
    }

    protected Color parseColor(StringTokenizer stringTokenizer) {
        return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
    }

    protected boolean parseFill(StringTokenizer stringTokenizer) {
        return Integer.parseInt(stringTokenizer.nextToken()) > 0;
    }
}

