/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import com.kt.io.AbstFile;
import d.d;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import option.io.pdfcommon.command.PdfCommandImage;
import option.io.pdfcommon.command.PdfCommandImageJpeg;
import option.io.pdfcommon.command.PdfDrawCommandParser;
import option.io.pdfcommon.command.PdfFormatFactory;
import option.io.pdfcommon.command.StreamGobbler;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.PageSize;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.path.Format;
import option.io.pdfcommon.path.Item;
import option.io.pdfcommon.path.ItemAttribute;
import option.io.pdfcommon.path.ItemImage;
import option.io.pdfcommon.path.ItemText;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.Path3D;
import option.io.pdfcommon.path.PathClip;
import option.io.pdfcommon.path.PathGroupPolygon;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathImageJpeg;
import option.io.pdfcommon.path.PathPolygon;
import option.io.pdfcommon.path.PdfDrawer;
import option.io.pdfcommon.util.PdfRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCommandParser
extends PdfDrawCommandParser {
    protected PageSize mPageSize;
    protected PdfDrawer mCmdDrawer;
    protected AbstFile mCmdReader;
    protected Map<String, byte[]> mPdfData;
    protected String mFileName;
    protected String mForceFileName;
    protected String mEncoding;
    private String b;
    private String c;
    protected boolean mIsCompress = true;
    protected boolean mAllowFormatLoad = false;
    protected static String mIDTFConverter = null;

    public PdfCommandParser(Map<String, byte[]> map, String string, String string2) {
        this(map, string, string2, null);
    }

    public PdfCommandParser(Map<String, byte[]> map, String string, String string2, String string3) {
        this(map, string, string2, string3, null);
    }

    public PdfCommandParser(Map<String, byte[]> object, String string, String string2, String string3, String string4) {
        super(string);
        this.mPdfData = object;
        this.b = string2;
        this.c = string3;
        this.mForceFileName = string4;
        byte[] byArray = this.mPdfData.get("ENCODING");
        object = byArray;
        object = byArray == null ? null : new String((byte[])object);
        this.mEncoding = object == null ? "MS932" : object;
    }

    public void setAllowFormatLoad(boolean bl) {
        this.mAllowFormatLoad = bl;
    }

    public void setCompressMode(boolean bl) {
        this.mIsCompress = bl;
    }

    public String createPdf() {
        String string = null;
        if (this.mPdfData != null && this.mBase != null) {
            try {
                string = this.parsePdfCommand();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        return string;
    }

    public static void loadFormat(File file) {
        PdfCommandParser.loadFormat(file, "MS932");
    }

    public static void loadFormat(File fileArray, String string) {
        if (!(fileArray = new File((File)fileArray, "format")).isDirectory()) {
            throw new IllegalArgumentException();
        }
        for (File file : fileArray.listFiles()) {
            if (!file.getName().endsWith(".fmt")) continue;
            PdfFormatFactory pdfFormatFactory = PdfFormatFactory.getInstance();
            pdfFormatFactory.getOrCreateFormat(file.getAbsolutePath(), string);
        }
    }

    protected String parsePdfCommand() {
        byte[] byArray = this.mPdfData.get("DATA");
        if (byArray == null) {
            System.err.println("DATA is null or unsuitable Object");
            return null;
        }
        if (d.d) {
            byte[] byArray2 = byArray;
            String string = "testout.txt";
            Object object = this;
            try {
                object = new BufferedOutputStream(new FileOutputStream(((PdfCommandParser)object).mBase + File.separator + string));
                ((FilterOutputStream)object).write(byArray2);
                ((FilterOutputStream)object).close();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        }
        return this.a(byArray);
    }

    private String a(byte[] object) {
        this.mPageSize = new PageSize();
        this.mCmdDrawer = new PdfDrawer();
        this.mCmdReader = new AbstFile();
        this.mCmdReader.setData((byte[])object);
        if (this.mCmdReader.openReadFileFromBuffer(this.mEncoding) == null) {
            System.err.println("data from a client cann't be read");
            return null;
        }
        while ((object = this.mCmdReader.readLineFromBuffer()) != null) {
            if (((String)object).indexOf("pdfstart") < 0) continue;
            while (((String)object).indexOf("pdfend") < 0 && (object = this.mCmdReader.readLineFromBuffer()) != null) {
                if (((String)object).trim().indexOf("#") == 0 || ((String)object).indexOf("filestart") < 0) continue;
                Object object2 = new StringTokenizer((String)object, ", ");
                ((StringTokenizer)object2).nextToken();
                this.mFileName = this.mForceFileName;
                if (this.mFileName == null && ((StringTokenizer)object2).hasMoreTokens()) {
                    this.mFileName = ((StringTokenizer)object2).nextToken();
                }
                this.mCmdDrawer.openFile(this.b + File.separator + this.mFileName);
                object2 = null;
                while ((object2 = this.mCmdReader.readLineFromBuffer()) != null && ((String)object2).indexOf("fileend") < 0) {
                    if (((String)object2).indexOf("pagestart") < 0) continue;
                    this.parsePageCommand((String)object2);
                }
                this.mCmdDrawer.closeFile();
            }
        }
        this.mCmdReader.closeReadFileFromBuffer();
        if (this.mCmdDrawer.writeToFile()) {
            this.mCmdDrawer.flush();
            this.mCmdDrawer.close();
            return this.mFileName;
        }
        return null;
    }

    protected void parsePageCommand(String object) {
        object = new Vector();
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        String string = null;
        while ((string = this.mCmdReader.readLineFromBuffer()) != null && string.indexOf("pageend") < 0) {
            Object object2;
            if (string.trim().indexOf("[multiline]") == 0) {
                string = "";
                while ((object2 = this.mCmdReader.readLineFromBuffer()) != null && ((String)object2).trim().indexOf("[multiline]") != 0) {
                    if (string.length() > 0) {
                        string = string + "\r\n";
                    }
                    string = string + (String)object2;
                }
            }
            if (string.indexOf("pagesize") >= 0) {
                int n;
                object2 = new StringTokenizer(string, ", ");
                ((StringTokenizer)object2).nextToken();
                string = ((StringTokenizer)object2).nextToken().trim().toUpperCase();
                int n2 = 0;
                if (((StringTokenizer)object2).hasMoreElements()) {
                    n2 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                }
                if (((StringTokenizer)object2).hasMoreElements() && (n = (int)Float.parseFloat(((StringTokenizer)object2).nextToken())) > 0) {
                    this.mPageSize.setDpi(n);
                }
                if ((object2 = this.mPageSize.getPageRect(string, n2)) == null) break;
                this.mCmdDrawer.addPage((PdfRect)object2);
                this.mCmdDrawer.getNowContents().setFlagCompress(this.mIsCompress);
                continue;
            }
            if (string.indexOf("formstart") >= 0 || (object2 = this.parseDrawCommand(string)) == null) continue;
            if (object2 instanceof Format) {
                vector.addElement(object2);
                continue;
            }
            if (object2 instanceof Item) {
                vector2.addElement(object2);
                continue;
            }
            ((Vector)object).addElement(object2);
        }
        this.drawPaths(this.mCmdDrawer.getNowContents(), vector, vector2, (Vector)object);
    }

    @Override
    public Path parseDrawCommand(String string) {
        Object object = new StringTokenizer(string, ", ");
        if (!((StringTokenizer)object).hasMoreTokens()) {
            return null;
        }
        if (((String)(object = ((StringTokenizer)object).nextToken().trim())).equals("format")) {
            return this.createFormat(string);
        }
        if (((String)object).equals("itemtext")) {
            return this.createItemText(string);
        }
        if (((String)object).equals("itemimage")) {
            return this.createItemImage(string);
        }
        if (((String)object).equals("grouppolygon")) {
            return this.createGroupPolygon(string);
        }
        if (((String)object).equals("pattern")) {
            return this.createPatternedPath(string);
        }
        if (((String)object).equals("shading")) {
            return this.createShadingPath(string);
        }
        if (((String)object).equals("clip")) {
            return this.createClip(string);
        }
        if (((String)object).equals("unclip")) {
            return this.createUnclip(string);
        }
        if (((String)object).equals("path")) {
            return this.createMultiPath(string);
        }
        return super.parseDrawCommand(string);
    }

    @Override
    protected PathImage createImage(String object) {
        block5: {
            int[] nArray;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            block7: {
                Object object2;
                block6: {
                    int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
                    if (n != 9) break block5;
                    ((StringTokenizer)object).nextToken();
                    Object object3 = ((StringTokenizer)object).nextToken();
                    object2 = "im" + (String)object3;
                    f7 = Float.parseFloat(((StringTokenizer)object).nextToken());
                    f6 = Float.parseFloat(((StringTokenizer)object).nextToken());
                    f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
                    f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
                    f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
                    f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
                    f = Float.parseFloat(((StringTokenizer)object).nextToken());
                    nArray = null;
                    byte[] byArray = this.mPdfData.get(object2);
                    object2 = byArray;
                    if (byArray != null) break block6;
                    if ((object3 = this.getImage((String)object3)) == null) break block7;
                    nArray = ((PdfCommandImage)object3).getPixels();
                    if (f7 <= 0.0f) {
                        f7 = ((PdfCommandImage)object3).getWidth();
                    }
                    if (f6 <= 0.0f) {
                        f6 = ((PdfCommandImage)object3).getHeight();
                    }
                    if (f3 == f5) {
                        f3 = f5 + f7 * 0.35278347f;
                    }
                    if (f2 != f4) break block7;
                    f2 = f4 - f6 * 0.35278347f;
                    break block7;
                }
                nArray = new int[((Object)object2).length / 4];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = object2[i << 2] << 24 | object2[(i << 2) + 1] << 16 | object2[(i << 2) + 2] << 8 | object2[(i << 2) + 3];
                }
            }
            if (nArray != null) {
                float f8 = f5 < f3 ? f5 : f3;
                float f9 = f4 < f2 ? f4 : f2;
                return new PathImage(nArray, f7, f6, f8, f9, Math.abs(f3 - f5), Math.abs(f2 - f4), f);
            }
        }
        return null;
    }

    @Override
    protected Path createJpegImage(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n == 9) {
            ((StringTokenizer)object).nextToken();
            Object object2 = ((StringTokenizer)object).nextToken();
            Object object3 = "im" + (String)object2;
            float f = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f6 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f7 = Float.parseFloat(((StringTokenizer)object).nextToken());
            PdfCommandImageJpeg pdfCommandImageJpeg = new PdfCommandImageJpeg();
            byte[] byArray = this.mPdfData.get(object3);
            object3 = byArray;
            if (byArray == null) {
                pdfCommandImageJpeg.setFile(this.getImagePath((String)object2));
                try {
                    pdfCommandImageJpeg.createImageInfo();
                }
                catch (Exception exception) {
                    object3 = exception;
                    exception.printStackTrace();
                    return null;
                }
                if (f5 == f3) {
                    f5 = f3 + f * 0.35278347f;
                }
                if (f6 == f4) {
                    f6 = f4 - f2 * 0.35278347f;
                }
            } else if (object3 instanceof byte[]) {
                try {
                    pdfCommandImageJpeg.createImageInfo((byte[])object3);
                }
                catch (Exception exception) {
                    object3 = exception;
                    exception.printStackTrace();
                    return null;
                }
            }
            object2 = pdfCommandImageJpeg.getData();
            f = pdfCommandImageJpeg.getWidth();
            f2 = pdfCommandImageJpeg.getHeight();
            if (object2 != null && f > 0.0f && f2 > 0.0f) {
                float f8 = f3 < f5 ? f3 : f5;
                float f9 = f4 < f6 ? f4 : f6;
                return new PathImageJpeg((byte[])object2, f, f2, f8, f9, Math.abs(f5 - f3), Math.abs(f6 - f4), f7);
            }
        }
        return null;
    }

    protected Format createFormat(String object) {
        object = new StringTokenizer((String)object, ", ");
        ((StringTokenizer)object).nextToken();
        if (!((StringTokenizer)object).hasMoreTokens()) {
            return null;
        }
        object = this.mBase + File.separator + "format" + File.separator + ((StringTokenizer)object).nextToken() + "." + "fmt";
        PdfFormatFactory pdfFormatFactory = PdfFormatFactory.getInstance();
        if (this.mAllowFormatLoad) {
            return pdfFormatFactory.getOrCreateFormat((String)object);
        }
        return pdfFormatFactory.getFormat((String)object);
    }

    protected Path createItemText(String object) {
        object = new StringTokenizer((String)object, "#");
        ((StringTokenizer)object).nextToken();
        String string = ((StringTokenizer)object).nextToken();
        object = ((StringTokenizer)object).nextToken().trim();
        object = new StringTokenizer((String)object, "*");
        if (((StringTokenizer)object).countTokens() != 2) {
            return null;
        }
        String string2 = ((StringTokenizer)object).nextToken();
        object = ((StringTokenizer)object).nextToken();
        return new ItemText(string2, (String)object, string);
    }

    protected Path createItemImage(String object) {
        if (((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens() != 4) {
            return null;
        }
        ((StringTokenizer)object).nextToken();
        String string = ((StringTokenizer)object).nextToken();
        String string2 = ((StringTokenizer)object).nextToken();
        object = ((StringTokenizer)object).nextToken();
        PdfCommandImage pdfCommandImage = this.getImage(string);
        if (pdfCommandImage == null) {
            return null;
        }
        int[] nArray = pdfCommandImage.getPixels();
        if (nArray == null) {
            return null;
        }
        return new ItemImage(string2, (String)object, string, nArray, pdfCommandImage.getWidth(), pdfCommandImage.getHeight());
    }

    protected Path createGroupPolygon(String object) {
        int n;
        int n2 = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n2 < 14) {
            return null;
        }
        ((StringTokenizer)object).nextToken();
        Color color = this.parseColor((StringTokenizer)object);
        boolean bl = this.parseFill((StringTokenizer)object);
        int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
        float[][] fArrayArray = new float[n3][];
        for (int i = 0; i < n3; ++i) {
            n = Integer.parseInt(((StringTokenizer)object).nextToken());
            float[] fArray = new float[n << 1];
            for (int j = 0; j < n; ++j) {
                fArray[j << 1] = Float.parseFloat(((StringTokenizer)object).nextToken());
                fArray[(j << 1) + 1] = Float.parseFloat(((StringTokenizer)object).nextToken());
            }
            fArrayArray[i] = fArray;
        }
        float f = Float.parseFloat(((StringTokenizer)object).nextToken());
        LineStyle lineStyle = new LineStyle(f, new DashPattern(this.parseLinePattern((StringTokenizer)object)));
        object = new PathGroupPolygon();
        for (n = 0; n < n3; ++n) {
            ((PathGroupPolygon)object).addPolygon(new PathPolygon(fArrayArray[n], lineStyle, color, bl));
        }
        return object;
    }

    protected Path createPatternedPath(String object) {
        Object object2 = new StringTokenizer((String)object, ", ");
        int n = ((StringTokenizer)object2).countTokens();
        if (n < 3) {
            return null;
        }
        ((StringTokenizer)object2).nextToken();
        object2 = ((StringTokenizer)object2).nextToken();
        n = ((String)object).indexOf((String)object2) + ((String)object2).length() + 1;
        object = this.parseDrawCommand(((String)object).substring(n, ((String)object).length()));
        object.setPattern((String)object2);
        return object;
    }

    protected Path createShadingPath(String object) {
        Object object2 = new StringTokenizer((String)object, ", ");
        int n = ((StringTokenizer)object2).countTokens();
        if (n < 3) {
            return null;
        }
        ((StringTokenizer)object2).nextToken();
        object2 = ((StringTokenizer)object2).nextToken();
        n = ((String)object).indexOf((String)object2) + ((String)object2).length() + 1;
        object = this.parseDrawCommand(((String)object).substring(n, ((String)object).length()));
        object.setShading((String)object2);
        return object;
    }

    @Override
    protected Path create3D(String object) {
        int n = ((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens();
        if (n < 11) {
            return null;
        }
        ((StringTokenizer)object).nextToken();
        String string = "im" + ((StringTokenizer)object).nextToken();
        float f = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
        Color color = this.parseColor((StringTokenizer)object);
        float f6 = Float.parseFloat(((StringTokenizer)object).nextToken());
        float f7 = -1.0f;
        if (n > 11) {
            f7 = Float.parseFloat(((StringTokenizer)object).nextToken());
        }
        object = this.mPdfData.get(string);
        AbstFile abstFile = null;
        if (object != null) {
            try {
                object = this.convertIDTF((byte[])object);
                if (object == null) {
                    return null;
                }
                abstFile = new AbstFile();
                abstFile.InputStreamToBuffer((File)object);
                return new Path3D(abstFile.getData(), f, f2, f3, f4, f5, color, f6, f7);
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected Path createClip(String object) {
        if (((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens() == 5) {
            ((StringTokenizer)object).nextToken();
            float f = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f2 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f3 = Float.parseFloat(((StringTokenizer)object).nextToken());
            float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
            return new PathClip(f < f3 ? f : f3, f2 < f4 ? f2 : f4, Math.abs(f3 - f), Math.abs(f4 - f2));
        }
        return null;
    }

    protected Path createUnclip(String object) {
        if (((StringTokenizer)(object = new StringTokenizer((String)object, ", "))).countTokens() == 1) {
            return new PathClip();
        }
        return null;
    }

    protected PdfCommandImage getImage(String string) {
        if (string == null) {
            return null;
        }
        return new PdfCommandImage(this.getImagePath(string));
    }

    protected String getImagePath(String string) {
        if (string == null) {
            return null;
        }
        return this.mBase + File.separator + IMAGE_DIRECTORY + File.separator + string;
    }

    protected void drawPaths(Contents contents, Vector vector, Vector vector2, Vector vector3) {
        int n;
        this.setAttribute(vector, vector2);
        for (n = 0; n < vector.size(); ++n) {
            ((Format)vector.elementAt(n)).draw(contents);
        }
        for (n = 0; n < vector2.size(); ++n) {
            ((Item)vector2.elementAt(n)).draw(contents);
        }
        for (n = 0; n < vector3.size(); ++n) {
            ((Path)vector3.elementAt(n)).draw(contents);
        }
    }

    protected void setAttribute(Vector vector, Vector vector2) {
        for (int i = 0; i < vector2.size(); ++i) {
            Item item = (Item)vector2.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                Path path = (Format)vector.elementAt(j);
                if (!path.getFormatName().equals(item.getFormatName()) || (path = path.getItemAttribute(item.getItemName())) == null) continue;
                item.setAttribute((ItemAttribute)path);
            }
        }
    }

    protected File convertIDTF(byte[] object) {
        if (mIDTFConverter == null) {
            this.loadProp();
        }
        if (mIDTFConverter == null || mIDTFConverter.length() == 0) {
            return null;
        }
        try {
            File file = this.c == null ? new File(this.b) : new File(this.c);
            Object object2 = File.createTempFile("3dAnot-", ".idtf", file);
            file = File.createTempFile("3dAnot-", ".u3d", file);
            Object object3 = new FileOutputStream((File)object2);
            ((OutputStream)object3).write((byte[])object);
            ((OutputStream)object3).close();
            object = new String[]{mIDTFConverter, "-input", ((File)object2).getAbsolutePath(), "-output", file.getAbsolutePath()};
            object2 = new File(mIDTFConverter).getParentFile();
            object = Runtime.getRuntime().exec((String[])object, null, (File)object2);
            object2 = new StreamGobbler(((Process)object).getErrorStream(), "ERROR");
            object3 = new StreamGobbler(((Process)object).getInputStream(), "OUTPUT");
            ((Thread)object2).start();
            ((Thread)object3).start();
            int n = ((Process)object).waitFor();
            if (n != 0) {
                return null;
            }
            return file;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IDTF covnvert exception", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("IDTF convert exception", interruptedException);
        }
    }

    protected void loadProp() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("nh3dpdf.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            mIDTFConverter = properties.getProperty("nh3d.pdf.idtfconverter");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

