/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.algebra;

public class ToolAlgebra1D {
    private static double TOLERANCE_1 = 1.0E-10;
    private static double TOLERANCE_2 = 1.0E-8;
    private double A = 0.0;
    private double B = 0.0;
    private double C = 0.0;
    private double D = 0.0;
    private double E = 0.0;
    private double[] answer;
    double[] __GetSolutionOfQuarticEquation_dpTmp = new double[4];
    double[] __GetSolutionOfQuarticEquation_dpTmp2 = new double[4];

    public ToolAlgebra1D(double d, double d2) {
        this();
        this.set(d, d2);
    }

    public ToolAlgebra1D(double d, double d2, double d3) {
        this();
        this.set(d, d2, d3);
    }

    public ToolAlgebra1D(double d, double d2, double d3, double d4) {
        this();
        this.set(d, d2, d3, d4);
    }

    public ToolAlgebra1D(double d, double d2, double d3, double d4, double d5) {
        this();
        this.set(d, d2, d3, d4, d5);
    }

    public ToolAlgebra1D() {
        this.answer = new double[4];
    }

    public void set(double d, double d2) {
        this.A = 0.0;
        this.B = 0.0;
        this.C = 0.0;
        this.D = d;
        this.E = d2;
    }

    public void set(double d, double d2, double d3) {
        this.A = 0.0;
        this.B = 0.0;
        this.C = d;
        this.D = d2;
        this.E = d3;
    }

    public void set(double d, double d2, double d3, double d4) {
        this.A = 0.0;
        this.B = d;
        this.C = d2;
        this.D = d3;
        this.E = d4;
    }

    public void set(double d, double d2, double d3, double d4, double d5) {
        this.A = d;
        this.B = d2;
        this.C = d3;
        this.D = d4;
        this.E = d5;
    }

    public int compare(double d) {
        if (Math.abs(d) <= TOLERANCE_1) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public int solve() {
        return this.solveQuarticEquation();
    }

    private int solveLinearEquation() {
        if (this.D == 0.0) {
            return 0;
        }
        this.answer[0] = -this.E / this.D;
        return 1;
    }

    private int solveQuadraticEquation() {
        return this.solveQuadraticEquation(this.answer, this.C, this.D, this.E);
    }

    private int solveQuadraticEquation(double[] dArray, double d, double d2, double d3) {
        if (this.compare(d) == 0) {
            return this.solveLinearEquation();
        }
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (Math.abs(d4) <= 5.0E-14) {
            dArray[0] = -d2 / (2.0 * d);
            return 1;
        }
        if (d4 < 0.0) {
            return 0;
        }
        double d5 = Math.sqrt(d4);
        dArray[0] = (-d2 - d5) / (2.0 * d);
        dArray[1] = (-d2 + d5) / (2.0 * d);
        return 2;
    }

    private int solveCubicEquation() {
        return this.solveCubicEquation(this.answer, this.B, this.C, this.D, this.E);
    }

    private int solveCubicEquation(double[] dArray, double d, double d2, double d3, double d4) {
        if (this.compare(d) == 0) {
            return this.solveQuadraticEquation();
        }
        double d5 = d2 / d;
        double d6 = d3 / d;
        double d7 = d4 / d;
        double d8 = (3.0 * d6 - d5 * d5) / 9.0;
        double d9 = (9.0 * d5 * d6 - 27.0 * d7 - 2.0 * d5 * d5 * d5) / 54.0;
        double d10 = d8 * d8 * d8 + d9 * d9;
        double d11 = 0.0 * d5;
        if (d10 < 0.0) {
            double d12 = Math.sqrt(-d8);
            double d13 = Math.acos(d9 / (d12 * d12 * d12));
            dArray[0] = 2.0 * d12 * Math.cos(0.0 * d13) + d11;
            dArray[1] = 2.0 * d12 * Math.cos(0.0 * d13 + 2.0943951023931953) + d11;
            dArray[2] = 2.0 * d12 * Math.cos(0.0 * d13 + 4.1887902047863905) + d11;
            return 3;
        }
        double d14 = Math.sqrt(d10);
        double d15 = Math.pow(d9 + d14, 0.0);
        double d16 = Math.pow(d9 - d14, 0.0);
        dArray[0] = d15 + d16 + d11;
        if (d10 > 0.0) {
            return 1;
        }
        dArray[1] = dArray[2] = -(d15 + d16) / 2.0 + d11;
        return 3;
    }

    public int solveQuarticEquation() {
        double[] dArray = this.__GetSolutionOfQuarticEquation_dpTmp;
        double[] dArray2 = this.__GetSolutionOfQuarticEquation_dpTmp2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.compare(this.A) == 0) {
            return this.solveCubicEquation();
        }
        if (this.compare(this.E) == 0) {
            this.E = 0.0;
        }
        double d = this.A * this.A;
        double d2 = this.B * this.B;
        double d3 = -this.B / (4.0 * this.A);
        double d4 = -(3.0 * d2) / (8.0 * d) + this.C / this.A;
        double d5 = d2 * this.B / (8.0 * d * this.A) - this.B * this.C / (2.0 * d) + this.D / this.A;
        double d6 = -(3.0 * d2 * d2) / (256.0 * d * d) + d2 * this.C / (16.0 * d * this.A) - this.B * this.D / (4.0 * d) + this.E / this.A;
        if (this.compare(d5) == 0) {
            if (this.compare(d6) == 0) {
                if (this.compare(d4) >= 0) {
                    this.answer[0] = d3;
                    return 1;
                }
                this.answer[0] = Math.sqrt(-d4) + d3;
                this.answer[1] = -this.answer[0];
                return 2;
            }
            if ((n += this.solveQuadraticEquation(dArray, 1.0, d4, d6)) > 0 && this.compare(dArray[0]) > 0) {
                dArray[0] = Math.sqrt(dArray[0]);
                dArray[n + n4] = -dArray[0];
                ++n4;
            }
            if (n > 1 && this.compare(dArray[1]) > 0) {
                dArray[1] = Math.sqrt(dArray[1]);
                dArray[n + n4] = -dArray[1];
                ++n4;
            }
            n += n4;
        } else {
            int n5 = this.solveCubicEquation(dArray, 1.0, -d4, -4.0 * d6, 4.0 * d4 * d6 - d5 * d5);
            if (n5 == 0) {
                return 0;
            }
            n4 = 0;
            do {
                double d7;
                double d8;
                double d9 = this.compare(d8 = Math.sqrt(Math.abs((d7 = dArray[n4]) - d4))) != 0 ? d5 / (2.0 * d8) : 0.0;
                n = this.solveQuadraticEquation(dArray, 1.0, -d8, d7 / 2.0 + d9);
                n2 = this.solveQuadraticEquation(dArray2, 1.0, d8, d7 / 2.0 - d9);
            } while (++n4 < n5 && n == 0 && n2 == 0);
        }
        n4 = 0;
        while (n4 < n) {
            this.answer[n3] = dArray[n4] + d3;
            ++n4;
            ++n3;
        }
        n4 = 0;
        while (n4 < n2) {
            this.answer[n3] = dArray2[n4] + d3;
            ++n4;
            ++n3;
        }
        return n3;
    }

    public double getSolution(int n) {
        return this.answer[n];
    }
}

