/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KMouseEvent;

public class Label2
extends Panel
implements MouseListener {
    public static final short CENTER = 0;
    public static final short LEFT = 1;
    public static final short RIGHT = 2;
    private String mText;
    private KFont mFont;
    private Dimension mSize = new Dimension();
    private Graphics mOffg = null;
    private Image mOffi = null;
    private Color mFrame = null;
    private short mPos;
    private int mWidth = -1;
    private int mInnerWidth = -1;
    private ActionListener mListener = null;
    private boolean mHit = false;
    private String mCommand = null;
    private Color mMouseHitColor = null;

    public Label2(String string, short s, Color color, Color color2, KFont kFont) {
        this(string, s, color, color2, null, -1, -1, kFont);
    }

    public Label2(String string, short s, Color color, Color color2, Color color3, KFont kFont) {
        this(string, s, color, color2, color3, -1, -1, kFont);
    }

    public Label2(String string, short s, Color color, Color color2, Color color3, int n, KFont kFont) {
        this(string, s, color, color2, color3, n, -1, kFont);
    }

    public Label2(String string, short s, Color color, Color color2, Color color3, int n, int n2, KFont kFont) {
        this(string, s, color, color2, color3, n, n2, kFont, null, 0);
    }

    public Label2(String string, short s, Color color, Color color2, Color color3, int n, int n2, KFont kFont, Object object, int n3) {
        this.mText = string;
        this.mFont = kFont;
        this.mPos = s;
        this.mSize.width = kFont.stringWidth(this.mText) + 0;
        this.mSize.height = kFont.getHeight() + 5;
        this.setForeground(color);
        this.setBackground(color2);
        this.mFrame = color3;
        this.mWidth = n;
        this.mInnerWidth = n2;
        this.setFont(this.mFont.getFontObject());
    }

    public void setText(String string) {
        this.mText = string;
    }

    public void setInnerWidth(int n) {
        this.mInnerWidth = n;
    }

    public void addActionListenr(ActionListener actionListener, String string) {
        this.mListener = actionListener;
        this.mCommand = string;
        if (this.mListener != null) {
            this.addMouseListener(this);
        }
    }

    public void setMouseHitColor(Color color) {
        this.mMouseHitColor = color;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = super.getSize();
        if (this.mOffg == null || this.mOffi == null || dimension.width != this.mSize.width || dimension.height != this.mSize.height) {
            if (this.mOffg != null) {
                this.mOffg.dispose();
            }
            if (this.mOffi != null) {
                this.mOffi.flush();
            }
            this.mOffi = this.createImage(dimension.width, dimension.height);
            this.mOffg = this.mOffi.getGraphics();
        }
        this.mSize.width = dimension.width;
        this.mSize.height = dimension.height;
        this.mOffg.setColor(this.getBackground());
        this.mOffg.fillRect(0, 0, this.mSize.width, this.mSize.height);
        int n = this.mInnerWidth > 0 ? this.mInnerWidth : this.mFont.stringWidth(this.mText);
        int n2 = this.mSize.height / 2 + this.mFont.getAscent() / 2;
        float f = this.mPos == 0 ? (float)((this.mSize.width - n) / 2) : (this.mPos == 2 ? (float)(this.mSize.width - n - 1) : 2.0f);
        if (this.mHit && this.mMouseHitColor != null) {
            this.mOffg.setColor(this.mMouseHitColor);
        } else {
            this.mOffg.setColor(this.getForeground());
        }
        graphics.clipRect(1, 1, this.mSize.width - 2, this.mSize.height - 2);
        if (this.mInnerWidth > 0) {
            float f2 = ((float)n - (float)this.mFont.stringWidth(this.mText)) / (float)(this.mText.length() - 1);
            for (int i = 0; i < this.mText.length(); ++i) {
                String string = this.mText.substring(i, i + 1);
                this.mOffg.drawString(string, (int)f, n2);
                f += f2 + (float)this.mFont.stringWidth(string);
            }
        } else {
            this.mOffg.drawString(this.mText, (int)f, n2);
        }
        graphics.setClip(null);
        if (this.mFrame != null) {
            this.mOffg.setColor(this.mFrame);
            this.mOffg.drawRect(0, 0, this.mSize.width - 1, this.mSize.height - 1);
        }
        graphics.drawImage(this.mOffi, 0, 0, null);
    }

    public Dimension getPreferredSize() {
        if (this.mWidth > 0) {
            this.mSize.width = this.mWidth;
        }
        return this.mSize;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mListener != null) {
            this.mHit = true;
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mListener != null) {
            this.mHit = false;
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (KMouseEvent.isRightButtonMask((int)mouseEvent.getModifiers())) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.actionPerformed(new ActionEvent(this, 0, this.mCommand));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

