/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    public static final short DISP_NW = 0;
    public static final short DISP_NE = 1;
    public Image mImage;
    public int mWidth;
    public int mHeight;
    private int mDispPos;

    public ImagePanel() {
        this.mDispPos = 0;
    }

    public void setDispPos(short s) {
        this.mDispPos = s;
    }

    public ImagePanel(Image image, Container container) {
        this.setImage(image, image.getWidth(container), image.getHeight(container));
    }

    public ImagePanel(Image image, int n, int n2) {
        this.setImage(image, n, n2);
    }

    public void setImage(Image image, int n, int n2) {
        this.mImage = image;
        this.mWidth = n;
        this.mHeight = n2;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mImage != null) {
            switch (this.mDispPos) {
                case 0: {
                    graphics.drawImage(this.mImage, 0, 0, null);
                    break;
                }
                case 1: {
                    Dimension dimension = this.getSize();
                    graphics.drawImage(this.mImage, dimension.width - this.mWidth, 0, null);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isVisible()) {
            if (dimension.width < this.mWidth) {
                dimension.width = this.mWidth;
            }
            if (dimension.height < this.mHeight) {
                dimension.height = this.mHeight;
            }
        } else {
            dimension.width = 0;
            dimension.height = 0;
        }
        return dimension;
    }
}

