/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import jp.kitec.kwt.KCursor;
import jp.kitec.richui.TipsMessage;

public class GButton
extends JPanel
implements MouseListener,
FocusListener {
    private ActionListener _actionListener;
    private ActionEvent _actionEvent;
    private Image _imageDef;
    private Image _imageActive;
    private Image _imageDisable;
    private Image _imageHilight;
    private Dimension _imageSize;
    private boolean _pressFlag = false;
    private boolean _innerFlag = false;
    private String mTitle;
    private boolean mEnable;
    private boolean mActive = false;
    private boolean mDrawFrame = false;
    private Color _bacColor;
    private Color _activeBacColor;
    private TipsMessage _tipMes;
    private String _tip = null;
    private boolean mIsRadioMode = false;
    private boolean drawImage = true;
    private static KCursor _handCursor = KCursor.getCursor((int)12);
    private static KCursor _defCursor = KCursor.getCursor((int)0);
    private Image _offImage;
    private Graphics mOffGraphics;
    private boolean _handMode = false;
    private int _pushOffset = 1;
    private int mSizeOffset = 0;
    private Component mProducer;

    public GButton(String string, Image image, Image image2, Image image3, Image image4, Color color, Color color2, Container container, TipsMessage tipsMessage, int n) {
        this._activeBacColor = color2;
        this._bacColor = color;
        this._tipMes = tipsMessage;
        this.mSizeOffset = n;
        this.mProducer = container;
        this.setBackground(this._bacColor);
        this.mTitle = string;
        this.mEnable = true;
        this.setImage(image, image2, image3, image4);
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    public void setImage(Image image, Image image2, Image image3, Image image4) {
        this._imageDef = image;
        this._imageActive = image2 != null ? image2 : this._imageDef;
        this._imageDisable = image3 != null ? image3 : this._imageDef;
        this._imageHilight = image4;
        if (this._imageDef != null && this._imageActive == null) {
            this._imageActive = this._imageDef;
        } else if (this._imageDef == null && this._imageActive != null) {
            this._imageDef = this._imageActive;
        }
        int n = this._imageDef.getWidth(null);
        int n2 = this._imageDef.getHeight(null);
        this._imageSize = new Dimension(n + this.mSizeOffset, n2 + this.mSizeOffset);
        BufferedImage bufferedImage = new BufferedImage(this._imageSize.width, this._imageSize.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this._imageSize.width, this._imageSize.height);
        graphics2D.fill(double_);
        graphics2D.setPaintMode();
        this._offImage = bufferedImage;
        this.mOffGraphics = this._offImage.getGraphics();
    }

    public void setDrawImage(boolean bl) {
        this.drawImage = bl;
        this.repaint();
    }

    public void setActiveBacColor(Color color) {
        this._activeBacColor = color;
    }

    public void setRadioMode(boolean bl) {
        this.mIsRadioMode = bl;
    }

    public void setHandMode(boolean bl) {
        this._handMode = bl;
    }

    public void setDrawFrame(boolean bl) {
        this.mDrawFrame = bl;
        this.repaint();
    }

    public void setPushOffset(int n) {
        this._pushOffset = n;
    }

    public void setTip(String string) {
        this._tip = string;
    }

    public Dimension getPreferredSize() {
        return this._imageSize;
    }

    public Dimension getSize() {
        return this._imageSize;
    }

    public String getLabel() {
        return this.mTitle;
    }

    public void setActive(boolean bl) {
        this.mActive = bl;
        this.repaint();
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setEnabled1(boolean bl) {
        this.mEnable = bl;
        if (!this.mEnable) {
            if (this._handMode) {
                this.setCursor((Cursor)_defCursor);
            }
            this.mActive = false;
        }
        this.repaint();
    }

    public boolean isEnabled1() {
        return this.mEnable;
    }

    public void addActionListener(ActionListener actionListener) {
        this._actionEvent = new ActionEvent(this, 0, null);
        this._actionListener = actionListener;
    }

    public void paintComponent(Graphics graphics) {
        Color color;
        boolean bl;
        super.paintComponent(graphics);
        Image image = null;
        int n = 0;
        boolean bl2 = bl = this.mActive || this._pressFlag;
        if (bl) {
            color = this._activeBacColor;
            image = this._imageActive;
            n = this._pushOffset;
        } else {
            color = this._bacColor;
            image = this.mEnable ? this._imageDef : this._imageDisable;
        }
        if (this._innerFlag && this._imageHilight != null && this.isEnabled1()) {
            image = this._imageHilight;
        }
        if (this.isOpaque()) {
            this.mOffGraphics.setColor(color);
            this.mOffGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            Graphics2D graphics2D = (Graphics2D)this.mOffGraphics;
            graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this._imageSize.width, this._imageSize.height);
            graphics2D.fill(double_);
            graphics2D.setPaintMode();
        }
        if (this.drawImage) {
            this.mOffGraphics.drawImage(image, n, n, this);
            if (this.mDrawFrame && this.mEnable) {
                this.mOffGraphics.setColor(color.darker().darker());
                this.mOffGraphics.drawRect(0, 0, this._imageSize.width - 1, this._imageSize.height - 1);
                this.mOffGraphics.setColor(color.brighter());
                this.mOffGraphics.draw3DRect(1, 1, this._imageSize.width - 3, this._imageSize.height - 3, !bl);
            }
        }
        graphics.drawImage(this._offImage, 0, 0, null);
    }

    private void gogo() {
        if (this.mIsRadioMode) {
            this.setActive(!this.isActive());
            this.repaint();
        }
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(this._actionEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.mEnable || !this.drawImage) {
            return;
        }
        this._pressFlag = true;
        this._innerFlag = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mEnable || !this.drawImage) {
            return;
        }
        if (!this.contains(mouseEvent.getX(), mouseEvent.getY()) && this._innerFlag) {
            this._innerFlag = false;
            this.repaint();
        } else if (this.contains(mouseEvent.getX(), mouseEvent.getY()) && !this._innerFlag) {
            this._innerFlag = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!(this.mEnable && this.drawImage || this._pressFlag)) {
            return;
        }
        if (this._innerFlag && this._pressFlag) {
            this.gogo();
        }
        this._pressFlag = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._tipMes != null && this.drawImage) {
            this._tipMes.setMessage(this._tip);
            this._tipMes.update();
        }
        if (this._handMode) {
            if (!this.mEnable || !this.drawImage) {
                this.setCursor((Cursor)_defCursor);
                return;
            }
            this.setCursor((Cursor)_handCursor);
        }
        this._innerFlag = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseExit();
    }

    protected void mouseExit() {
        if (this._tipMes != null && this.drawImage) {
            this._tipMes.setMessage(null);
            this._tipMes.update();
        }
        if (this._handMode) {
            this.setCursor((Cursor)_defCursor);
        }
        this._innerFlag = false;
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mouseExit();
    }
}

