/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import d.d;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class History {
    private int _maxHistoryNum = 8;
    private Vector<byte[]> _history;
    private byte[] _current;

    public History(int n) {
        this.setMaxHistory(n);
        this._history = new Vector();
        this._current = null;
    }

    public void setMaxHistory(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._maxHistoryNum = n;
    }

    public int getMaxHistory() {
        return this._maxHistoryNum;
    }

    public void flushHistory() {
        this._current = null;
        this._history.removeAllElements();
    }

    public int getHistorySize() {
        return this._history.size();
    }

    public void addHistory(Object object) {
        int n;
        byte[] byArray = History.writeBytes(object);
        if (byArray == null) {
            return;
        }
        if (this._current != null && (n = this._history.indexOf(this._current)) >= 0 && n < this._history.size() - 1) {
            try {
                while (n + 1 <= this._history.size() - 1) {
                    this._history.removeElementAt(n + 1);
                }
            }
            catch (Exception exception) {
                if (d.d) {
                    System.out.println(n);
                }
                exception.printStackTrace();
            }
        }
        this._current = byArray;
        this._history.addElement(byArray);
        while (this._history.size() > this._maxHistoryNum) {
            this._history.removeElementAt(0);
        }
    }

    public boolean hasUndo() {
        if (this._current == null) {
            return false;
        }
        if (this._history.size() == 0) {
            return false;
        }
        int n = this._history.indexOf(this._current);
        return n > 0;
    }

    public boolean hasRedo() {
        if (this._current == null) {
            return false;
        }
        int n = this._history.indexOf(this._current);
        return n >= 0 && n < this._history.size() - 1;
    }

    @Deprecated
    public boolean isHasUndo() {
        return this.hasUndo();
    }

    @Deprecated
    public boolean isHasRedo() {
        return this.hasRedo();
    }

    public Object getLastHistory() {
        if (this._history.size() == 0) {
            return null;
        }
        return this._history.lastElement();
    }

    public Object getCurrentHistory() {
        return this._current;
    }

    public Object undo() {
        if (this._current == null) {
            return null;
        }
        int n = this._history.indexOf(this._current);
        if (n < 0) {
            return null;
        }
        if (n > 0) {
            this._current = this._history.elementAt(n - 1);
            return History.readBytes(this._current);
        }
        return null;
    }

    public Object redo() {
        if (this._current == null) {
            return null;
        }
        int n = this._history.indexOf(this._current);
        if (n < 0) {
            return null;
        }
        if (n >= 0 && n < this._history.size() - 1) {
            this._current = this._history.elementAt(n + 1);
            return History.readBytes(this._current);
        }
        return null;
    }

    private static byte[] writeBytes(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (exception instanceof NotSerializableException) {
                NotSerializableException notSerializableException = (NotSerializableException)exception;
                notSerializableException.fillInStackTrace();
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Object readBytes(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            byteArrayInputStream.close();
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

