/*
 * Decompiled with CFR 0.152.
 */
package com.kt.gui.tree;

import com.kt.gui.event.ActionItem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import jp.kitec.kwt.KFont;

public class NodeItem
implements ActionItem {
    protected KFont mFont;
    private String mTitle;
    protected Image mRegularImage;
    protected Rectangle mPosRect;
    private Object mParent;
    protected int mSpace;
    private boolean mActive = false;
    private Object mNodeObject;
    private boolean mIsVisible = true;
    public int mIndex = -1;

    protected NodeItem(Object object, String string, Image image, int n, KFont kFont) {
        this.mFont = kFont;
        this.mTitle = string != null ? string : "none";
        this.mParent = object;
        this.mRegularImage = image;
        this.mSpace = n;
        this.mPosRect = new Rectangle(0, 0);
        this.mPosRect.width = this.mFont.stringWidth(this.mTitle) + this.mSpace * 2;
        if (this.mRegularImage != null) {
            this.mPosRect.width += this.mRegularImage.getWidth(null) + this.mSpace;
        }
        this.mPosRect.height = this.mFont.getHeight() + this.mSpace * 2;
        if (this.mRegularImage != null) {
            int n2 = this.mRegularImage.getHeight(null) + this.mSpace * 2;
            this.mPosRect.height = this.mPosRect.height > n2 ? this.mPosRect.height : n2;
        }
    }

    public void setNodeObject(Object object) {
        this.mNodeObject = object;
    }

    public Object getNodeObject() {
        return this.mNodeObject;
    }

    public Object getActionObject() {
        return null;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public Rectangle setPosition(int n, int n2) {
        this.mPosRect.x = n;
        this.mPosRect.y = n2;
        return this.mPosRect;
    }

    public Rectangle getPosition() {
        return this.mPosRect;
    }

    public void setParent(Object object) {
        this.mParent = object;
    }

    public Object getParent() {
        return this.mParent;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.mRegularImage);
    }

    public void paint(Graphics graphics, Image image) {
        int n = this.mPosRect.x + this.mSpace;
        int n2 = this.mPosRect.y;
        if (image != null) {
            graphics.drawImage(image, n, n2 + this.mSpace, null);
            n += image.getWidth(null);
        }
        if (this.mActive) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.black);
        }
        n2 = this.mPosRect.y + this.mPosRect.height - this.mSpace - (this.mPosRect.height - this.mFont.getAscent()) / 2;
        graphics.drawString(this.mTitle, n + this.mSpace, n2);
    }

    public void setActive(boolean bl) {
        this.mActive = bl;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public Object getSource() {
        return this;
    }

    public String getPath(String string) {
        string = string != null ? this.mTitle + "\\" + string : this.mTitle;
        if (this.mParent != null) {
            string = ((NodeItem)this.mParent).getPath(string);
        }
        return string;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setVisible(boolean bl) {
        this.mIsVisible = bl;
    }
}

