/*
 * Decompiled with CFR 0.152.
 */
package option.jsgroup.server;

import com.kt.dao.ObjectFolderDao;
import com.kt.io.FileIOUtil;
import com.kt.util.CompressData;
import com.kt.util.StringUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import nethome.ui.MainApplicationCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSGUrlConfUtil {
    private static final Log log = LogFactory.getLog(JSGUrlConfUtil.class);
    public static final String URL_GET_SERVLET = "urlget";
    public static final String KEY_PREFIX = "jsgroup.servlet.url.";
    public static final String KEY_JUDGE = ".judge";
    private static final String KEY_HTTP_JUDGE = "http://";
    private static final String ENCODING = "UTF-8";

    public static Map<String, String> requestURL(MainApplicationCore mainApplicationCore) {
        return JSGUrlConfUtil.requestURL(mainApplicationCore, URL_GET_SERVLET);
    }

    public static Map<String, String> requestURLUnsafe(MainApplicationCore mainApplicationCore) {
        return JSGUrlConfUtil.requestURLUnsafe(mainApplicationCore, URL_GET_SERVLET);
    }

    public static Map<String, String> requestURL(MainApplicationCore mainApplicationCore, String string) {
        return JSGUrlConfUtil.requestURL(mainApplicationCore, string, ".*");
    }

    public static Map<String, String> requestURLUnsafe(MainApplicationCore mainApplicationCore, String string) {
        return JSGUrlConfUtil.requestURLUnsafe(mainApplicationCore, string, ".*");
    }

    public static Map<String, String> requestURL(MainApplicationCore mainApplicationCore, String string, String string2) {
        byte[] byArray = null;
        try {
            byArray = mainApplicationCore.inquiry(string, string2.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (byArray == null) {
            return null;
        }
        ObjectFolderDao objectFolderDao = new ObjectFolderDao();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        objectFolderDao.setInput((InputStream)byteArrayInputStream);
        ObjectFolder objectFolder = objectFolderDao.load(ENCODING);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ObjectNode objectNode : objectFolder.getChildren()) {
            hashMap.put(objectNode.getName(), ObjectNode.getNodeString((ObjectNode)objectNode));
        }
        return hashMap;
    }

    public static Map<String, String> requestURLUnsafe(MainApplicationCore mainApplicationCore, String string, String string2) {
        Object object = null;
        try {
            Class<?> clazz = mainApplicationCore.getClass();
            Method method = clazz.getMethod("getCodeBase", new Class[0]);
            URL uRL = (URL)method.invoke((Object)mainApplicationCore, new Object[0]);
            object = JSGUrlConfUtil.inquiryUnsafe(uRL, string, string2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (object == null || !(object instanceof Map)) {
            return null;
        }
        return (Map)object;
    }

    private static Object inquiryUnsafe(URL uRL, String string, Object object) {
        Object object2;
        block5: {
            object2 = null;
            ObjectOutputStream objectOutputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    URL uRL2 = new URL(uRL, string);
                    log.debug((Object)("url[" + uRL2 + "]"));
                    URLConnection uRLConnection = uRL2.openConnection();
                    uRLConnection.setDoOutput(true);
                    uRLConnection.setDoInput(true);
                    uRLConnection.setUseCaches(false);
                    uRLConnection.setRequestProperty("Content-type", "application/octet-stream");
                    objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
                    byte[] byArray = CompressData.compressUnsafe((Object)object);
                    objectOutputStream.writeObject(byArray);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
                    byte[] byArray2 = (byte[])objectInputStream.readObject();
                    object2 = byArray2 == null ? null : CompressData.decompressUnsafe((Object)byArray2);
                }
                catch (Exception exception) {
                    log.error((Object)"", (Throwable)exception);
                    FileIOUtil.close(objectInputStream);
                    FileIOUtil.close(objectOutputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileIOUtil.close(objectInputStream);
                FileIOUtil.close(objectOutputStream);
                throw throwable;
            }
            FileIOUtil.close((InputStream)objectInputStream);
            FileIOUtil.close((OutputStream)objectOutputStream);
        }
        return object2;
    }

    public static String findURL(URL uRL, Map<?, ?> map, String string) {
        String string2;
        if (uRL == null) {
            return null;
        }
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        Map.Entry<String, String> entry = JSGUrlConfUtil.findKeyByCodeBase(uRL, map);
        String string3 = "default";
        if (entry != null) {
            string2 = entry.getKey();
            int n = string2.indexOf(KEY_PREFIX);
            assert (n != -1);
            int n2 = string2.indexOf(KEY_JUDGE);
            assert (n2 != -1);
            string3 = string2.substring(KEY_PREFIX.length(), n2);
        }
        log.debug((Object)("groupName[" + string3 + "]"));
        string2 = map.get(KEY_PREFIX + string3 + "." + string);
        if (StringUtil.isEmpty((String)string2)) {
            return null;
        }
        log.debug((Object)("path[" + string2 + "]"));
        if (string2.startsWith(KEY_HTTP_JUDGE)) {
            return string2;
        }
        return String.valueOf(uRL.getProtocol()) + ":" + "//" + uRL.getAuthority() + string2;
    }

    private static Map.Entry<String, String> findKeyByCodeBase(URL uRL, Map<String, String> map) {
        if (uRL == null) {
            return null;
        }
        if (map == null || map.isEmpty()) {
            return null;
        }
        String string = uRL.getHost();
        Map.Entry<String, String> entry = null;
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            String string2;
            String string3 = entry2.getKey();
            if (StringUtil.isEmpty((String)string3) || !string3.startsWith(KEY_PREFIX) || !string3.endsWith(KEY_JUDGE) || !string.matches(string2 = entry2.getValue())) continue;
            entry = entry2;
            break;
        }
        return entry;
    }

    public static String createURL(URL uRL) {
        int n = uRL.getPort();
        if (n == -1) {
            n = 80;
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(String.valueOf(uRL.getProtocol()) + ":");
        stringBuffer.append("//" + uRL.getHost());
        if (n != 80) {
            stringBuffer.append(":" + n);
        }
        stringBuffer.append("/urlget");
        return stringBuffer.toString();
    }
}

