/*
 * Decompiled with CFR 0.152.
 */
package option.misc.gui;

import com.kt.util.UtilString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.kitec.kwt.KFont;
import option.misc.gui.DkTipMessage;

public class DkMultiLineStatusBar
extends JPanel
implements DkTipMessage {
    protected String mStr = null;
    protected String mSubStr = null;
    protected String mConstantStr = "";
    protected int mTextSize = 12;
    protected KFont mFont;
    protected JLabel[] mMain;

    public DkMultiLineStatusBar(Color color, Color color2) {
        this(color, color2, 1, 12);
    }

    public DkMultiLineStatusBar(Color color, Color color2, int n) {
        this(color, color2, n, 12);
    }

    public DkMultiLineStatusBar(Color color, Color color2, int n, int n2) {
        this.setForeground(color);
        this.mTextSize = n2;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.mFont = KFont.getFont((String)"MS UI Gothic", (int)KFont.PLAIN, (float)this.mTextSize);
        this.setFont(this.mFont.getFontObject());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.mMain = new JLabel[n];
        for (int i = 0; i < n; ++i) {
            this.mMain[i] = new JLabel(" ");
            this.mMain[i].setFont(this.mFont.getFontObject());
            this.add((Component)this.mMain[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DkMultiLineStatusBar.this.update();
            }
        });
    }

    public void setConstantMessage(String string) {
        this.mConstantStr = string;
        this.update();
    }

    public String getConstantMessage() {
        return this.mConstantStr;
    }

    public void setMessage(String string) {
        if (UtilString.isDiff((String)this.mStr, (String)string)) {
            this.mStr = string;
            this.update();
        }
    }

    public void setMessage(String string, String string2) {
        this.mStr = string + "\n" + string2;
    }

    public void setMessage2(String string) {
    }

    public void update() {
        String string = null;
        string = this.mStr != null ? this.mStr : (this.mConstantStr != null ? this.mConstantStr : "");
        int n = this.mMain[0].getWidth();
        if (string.length() == 0) {
            for (int i = 0; i < this.mMain.length; ++i) {
                this.mMain[i].setText("  ");
            }
        } else {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.mFont.getFontObject());
            Graphics2D graphics2D = (Graphics2D)this.mMain[0].getGraphics();
            if (graphics2D == null) {
                return;
            }
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D.getFontRenderContext());
            for (int i = 0; i < this.mMain.length; ++i) {
                String string2 = string.substring(lineBreakMeasurer.getPosition(), lineBreakMeasurer.nextOffset(n));
                if (string2.length() > 0) {
                    this.mMain[i].setText(string2);
                } else {
                    this.mMain[i].setText(" ");
                }
                this.mMain[i].setToolTipText(string);
                TextLayout textLayout = lineBreakMeasurer.nextLayout(n);
            }
            graphics2D.dispose();
        }
    }

    public Component getComponenet() {
        return this;
    }

    public void close() {
    }
}

