/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import option.gad.client.gui.GdJPanel;
import option.gad.client.gui.GdTitleProcessor;
import option.gad.client.util.SwingUtil;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractConfigItemComponent<TYPE, INFO>
extends GdJPanel {
    protected boolean mInitCompleted = false;
    protected JPanel mRootComp;
    protected JPanel mMainComp;
    protected TYPE mSelectedType;
    protected INFO mConfigInfo;
    protected ArrayList<Closure<Object, Void>> mListenerList = new ArrayList();
    protected ArrayList<Closure<Object, Void>> mKeyListenerList = new ArrayList();

    public GdAbstractConfigItemComponent() {
        GdInjector.getInstance().inject((Object)this);
        this.setVisible(false);
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.mMainComp = this.createMainComponent();
        GdTitleProcessor gdTitleProcessor = this.configTitleProcessor();
        this.mRootComp = gdTitleProcessor != null ? gdTitleProcessor.process(this.mMainComp, this.configTitle(), this.configTitleDimension()) : this.mMainComp;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.mRootComp, gridBagConstraints);
        this.setEnabled(this.isEnabled());
        this.mInitCompleted = true;
    }

    protected abstract JPanel createMainComponent();

    protected abstract GdTitleProcessor configTitleProcessor();

    protected abstract String configTitle();

    protected Dimension configTitleDimension() {
        return new Dimension(50, 10);
    }

    protected abstract TYPE configDefaultType();

    protected abstract void typeChanged(TYPE var1);

    protected void updateComponents() {
    }

    public void addListener(Closure<Object, Void> closure) {
        this.mListenerList.add(closure);
    }

    public void addKeyListener(Closure<Object, Void> closure) {
        this.mKeyListenerList.add(closure);
    }

    protected void fireChanged(TYPE TYPE) {
        this.typeChanged(TYPE);
        this.itemChanged();
    }

    protected void itemChanged() {
        for (Closure<Object, Void> closure : this.mListenerList) {
            closure.execute(null);
        }
    }

    protected void keyReleasedAction() {
        for (Closure<Object, Void> closure : this.mKeyListenerList) {
            closure.execute(null);
        }
    }

    protected void initValues() {
    }

    public boolean isValueValid() {
        return true;
    }

    public void updateTypeState() {
    }

    public void setConfigInfo(INFO INFO) {
        this.mConfigInfo = INFO;
        if (!this.mInitCompleted) {
            this.initValues();
            this.initComponents();
        }
        this.updateComponents();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.mInitCompleted) {
            this.initValues();
            this.initComponents();
            this.updateComponents();
        }
        super.setVisible(bl);
    }

    public void setEditable(boolean bl) {
    }

    @Override
    public void setOpaque(boolean bl) {
        List<JComponent> list = SwingUtil.findManyComponent(this, JComponent.class);
        for (JComponent jComponent : list) {
            if (jComponent == this) continue;
            jComponent.setOpaque(bl);
        }
    }
}

