/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {
    public static final int SECOND_OF_DAY = 86400;
    public static final long MILLISECOND_OF_DAY = 86400000L;
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";

    private TimeUtil() {
    }

    public static long getTime() {
        return new Date().getTime();
    }

    public static Timestamp createTimestamp() {
        return TimeUtil.createTimestamp(TimeUtil.getTime());
    }

    public static Timestamp createTimestamp(long l) {
        return new Timestamp(l);
    }

    public static long parseLong(String object, String string) {
        long l = 0L;
        try {
            if (string == null || string.equals("")) {
                return 0L;
            }
            object = new SimpleDateFormat((String)object);
            ((DateFormat)object).setLenient(false);
            l = ((DateFormat)object).parse(string).getTime();
        }
        catch (Exception exception) {}
        return l;
    }

    public static Timestamp parseTimestamp(String string, String string2) {
        return new Timestamp(TimeUtil.parseLong(string, string2));
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static long add(long l, int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        calendar.add(n, n2);
        return calendar.getTimeInMillis();
    }

    public static Timestamp add(Timestamp timestamp, int n, int n2) {
        return TimeUtil.createTimestamp(TimeUtil.add(timestamp.getTime(), n, n2));
    }

    public static Timestamp addDay(Timestamp timestamp, int n) {
        return TimeUtil.add(timestamp, 5, n);
    }

    public static Timestamp addMonth(Timestamp timestamp, int n) {
        return TimeUtil.add(timestamp, 2, n);
    }

    public static long truncate(long l, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        if (n == 14) {
            return calendar.getTimeInMillis();
        }
        calendar.set(14, 0);
        if (n == 13) {
            return calendar.getTimeInMillis();
        }
        calendar.set(13, 0);
        if (n == 12) {
            return calendar.getTimeInMillis();
        }
        calendar.set(12, 0);
        if (n == 11) {
            return calendar.getTimeInMillis();
        }
        calendar.set(11, 0);
        if (n == 5) {
            return calendar.getTimeInMillis();
        }
        calendar.set(5, 1);
        if (n == 2) {
            return calendar.getTimeInMillis();
        }
        calendar.set(2, 0);
        return calendar.getTimeInMillis();
    }

    public static Timestamp truncate(Timestamp timestamp, int n) {
        return TimeUtil.createTimestamp(TimeUtil.truncate(timestamp.getTime(), n));
    }

    public static Timestamp truncateTime(Timestamp timestamp) {
        return TimeUtil.createTimestamp(TimeUtil.truncate(timestamp.getTime(), 5));
    }

    public static int diff(long l, long l2, int n) {
        long l3 = TimeUtil.truncate(l, n);
        long l4 = TimeUtil.truncate(l2, n);
        int n2 = 0;
        if (l3 != l4) {
            n2 = l3 < l4 ? 1 : -1;
        }
        return n2;
    }

    public static int diff(Timestamp timestamp, Timestamp timestamp2, int n) {
        long l = timestamp == null ? 0L : timestamp.getTime();
        long l2 = timestamp2 == null ? 0L : timestamp2.getTime();
        return TimeUtil.diff(l, l2, n);
    }
}

