/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.util.ArrayList;
import java.util.Collection;
import option.gad.core.util.EnumWithId;
import option.gad.core.util.EnumWithName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtil {
    protected EnumUtil() {
    }

    public static final boolean matchOR(Enum<?> enum_, Enum<?> ... enumArray) {
        if (enum_ == null) {
            return false;
        }
        if (enumArray == null) {
            return false;
        }
        if (enumArray.length == 0) {
            return false;
        }
        for (Enum<?> enum_2 : enumArray) {
            if (enum_2 != enum_) continue;
            return true;
        }
        return false;
    }

    public static final boolean matchAND(Enum<?> enum_, Enum<?> ... enumArray) {
        if (enum_ == null) {
            return false;
        }
        if (enumArray == null) {
            return false;
        }
        if (enumArray.length == 0) {
            return false;
        }
        boolean bl = true;
        for (Enum<?> enum_2 : enumArray) {
            bl &= enum_2 == enum_;
        }
        return bl;
    }

    public static <T extends Enum<?>> T prev(T t) {
        int n = ((Enum[])t.getClass().getEnumConstants()).length;
        int n2 = t.ordinal();
        n = n2 == 0 ? n - 1 : n2 - 1;
        return (T)((Enum[])t.getClass().getEnumConstants())[n];
    }

    public static <T extends Enum<?>> T next(T t) {
        int n = ((Enum[])t.getClass().getEnumConstants()).length;
        int n2 = t.ordinal();
        n = n2 == n - 1 ? 0 : n2 + 1;
        return (T)((Enum[])t.getClass().getEnumConstants())[n];
    }

    public static <T extends Enum<?>> T getById(Class<T> enumArray, Integer n) {
        Enum enum_ = null;
        for (Enum enum_2 : (Enum[])enumArray.getEnumConstants()) {
            if (!((EnumWithId)((Object)enum_2)).getId().equals(n)) continue;
            enum_ = enum_2;
            break;
        }
        return (T)enum_;
    }

    public static <T extends Enum<?>> T getByName(Class<T> enumArray, String string) {
        Enum enum_ = null;
        for (Enum enum_2 : (Enum[])enumArray.getEnumConstants()) {
            if (!((EnumWithName)((Object)enum_2)).getName().equals(string)) continue;
            enum_ = enum_2;
            break;
        }
        return (T)enum_;
    }

    public static <T extends Enum<?>> Integer getId(T t) {
        return EnumUtil.getId(t, null);
    }

    public static <T extends Enum<?>> Integer getId(T t, Integer n) {
        if (t == null) {
            return n;
        }
        return ((EnumWithId)((Object)t)).getId();
    }

    public static <T extends Enum<?>> Collection<Integer> getIds(Class<T> enumArray) {
        enumArray = (Enum[])enumArray.getEnumConstants();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Enum enum_ : enumArray) {
            arrayList.add(((EnumWithId)((Object)enum_)).getId());
        }
        return arrayList;
    }

    public static <T extends Enum<?>> String getName(T t) {
        return EnumUtil.getName(t, null);
    }

    public static <T extends Enum<?>> String getName(T t, String string) {
        if (t == null) {
            return string;
        }
        return ((EnumWithName)((Object)t)).getName();
    }

    public static <T extends Enum<?>> Collection<String> getNames(Class<T> enumArray) {
        enumArray = (Enum[])enumArray.getEnumConstants();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Enum enum_ : enumArray) {
            arrayList.add(((EnumWithName)((Object)enum_)).getName());
        }
        return arrayList;
    }

    public static <T extends Enum<?>> Integer[] getIdArray(Class<T> enumArray) {
        enumArray = (Enum[])enumArray.getEnumConstants();
        Integer[] integerArray = new Integer[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            integerArray[i] = ((EnumWithId)((Object)enumArray[i])).getId();
        }
        return integerArray;
    }

    public static <T extends Enum<?>> String[] getNameArray(Class<T> enumArray) {
        enumArray = (Enum[])enumArray.getEnumConstants();
        String[] stringArray = new String[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            stringArray[i] = ((EnumWithName)((Object)enumArray[i])).getName();
        }
        return stringArray;
    }
}

