/*
 * Decompiled with CFR 0.152.
 */
package option.threed.render;

import java.awt.Color;
import java.util.Vector;
import option.threed.render.ImageUpdater;
import option.threed.render.J3DMatrix;
import option.threed.render.J3DObject;
import option.threed.render.J3DPrimitive;
import option.threed.render.J3DTLVertex;
import option.threed.render.J3DVector;
import option.threed.render.J3DVertex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderSL {
    public static final int STATE_TEXTURE = 1;
    public static final int STATE_LIGHTING = 2;
    public static final int STATE_LINE = 8;
    public static final int STATE_STENCIL = 16;
    public static final int STATE_CASH = 256;
    public static int BGCOLOR = -1;
    public static int LINE_COLOR = -10461088;
    private Log mLog = LogFactory.getLog(RenderSL.class);
    private static final int XPSHIFT = 16;
    private static final int XPBASE = 65536;
    public static final int ATT_ALPHABLEND = 2048;
    private static final int STATE_HILIGHT = 64;
    private static final int STATE_SHADOW = 128;
    private static final int MAX_TRIANGLE = 256;
    private static final int MAX_VERTEX = 256;
    private static int DEFAULT_MAX_ALPHA_PMV_SIZE = 1024;
    private int BUFFERW;
    private int BUFFERH;
    private J3DTLVertex[] mMin;
    private J3DTLVertex[] mMax;
    private Vector mDObjects = new Vector();
    private Vector mSObjects = new Vector();
    private Vector mXObjects = new Vector();
    private J3DPrimitive[] mAlphaPmv = null;
    private int mMaxAlphaPmvSize = DEFAULT_MAX_ALPHA_PMV_SIZE;
    private int mAlphaPmvCount = 0;
    private int mRenderState = 0;
    private boolean ss_reductmode = false;
    private boolean ss_reductline = true;
    private int ss_drawingstate = 0;
    private int ss_samplegrid = 3;
    private boolean ss_drawedge = true;
    private boolean ss_shadecolor = true;
    private J3DTLVertex[] mTLVertex;
    private J3DVertex[] mVertexBuf;
    private J3DVertex[] mVertexBuf1;
    private J3DVertex[] mVertexBuf2;
    private J3DMatrix mMaster = new J3DMatrix();
    private J3DMatrix mView = new J3DMatrix();
    private J3DMatrix mProj = new J3DMatrix();
    private J3DVector mCameraPos = new J3DVector();
    private J3DVector mCameraTarget = new J3DVector();
    private J3DVector mCameraUp = new J3DVector();
    private J3DVector mBCameraPos = new J3DVector();
    private J3DVector mBCameraTarget = new J3DVector();
    private float mPers;
    private J3DVector mLight = new J3DVector();
    private int mAmbColor = 0;
    private int mDifColor = 0;
    private J3DPrimitive[] mPmvBuffer = null;
    public boolean ANTI_ALIAS = false;
    private J3DVector nn = new J3DVector();
    private boolean mLineMode = false;
    private int[] ss_rgb;
    private int[] ss_current;
    private int[] ss_zbuffer;
    private boolean ss_draw = false;

    public RenderSL(int n, int n2) {
        this.init(n, n2, DEFAULT_MAX_ALPHA_PMV_SIZE);
    }

    public RenderSL(int n, int n2, int n3) {
        this.init(n, n2, n3);
    }

    protected void init(int n, int n2, int n3) {
        this.mMaxAlphaPmvSize = n3;
        this.mAlphaPmv = new J3DPrimitive[n3];
        this.mPmvBuffer = new J3DPrimitive[n3];
        this.ss_samplegrid = 2;
        this.ANTI_ALIAS = true;
        this.resize(n, n2);
        this.mTLVertex = new J3DTLVertex[256];
        this.mVertexBuf = new J3DVertex[256];
        this.mVertexBuf1 = new J3DVertex[256];
        this.mVertexBuf2 = new J3DVertex[256];
        int n4 = 0;
        while (n4 < 256) {
            this.mTLVertex[n4] = new J3DTLVertex();
            this.mVertexBuf[n4] = new J3DVertex();
            ++n4;
        }
        this.setState(259);
        this.setCameraUp(0.0f, 0.0f, 1.0f);
        this.setCameraPosition(0.0f, 0.0f, 500.0f);
        this.setCameraTarget(0.0f, 0.0f, 0.0f);
        this.setPers(0.7853982f);
        this.setLight(0.2f, 0.6f, 0.4f, 0xFFFFFF, 0x404040);
    }

    public void addObject(J3DObject j3DObject) {
        switch (j3DObject.mAttribute) {
            case 0: {
                this.mSObjects.addElement(j3DObject);
                break;
            }
            case 1: {
                this.mDObjects.addElement(j3DObject);
                break;
            }
            case 2: 
            case 3: {
                this.mXObjects.addElement(j3DObject);
            }
        }
        Vector vector = j3DObject.getPrimitives();
        int n = 0;
        while (n < vector.size()) {
            J3DPrimitive j3DPrimitive = (J3DPrimitive)vector.elementAt(n);
            j3DPrimitive.light = this.lighting(j3DPrimitive.normal);
            switch (j3DObject.mAttribute) {
                case 0: {
                    j3DPrimitive.alpha = (short)255;
                    break;
                }
                case 1: {
                    if (j3DPrimitive.alpha == 255) break;
                    j3DPrimitive.att = (short)(j3DPrimitive.att | 0x800);
                    break;
                }
                case 2: {
                    j3DPrimitive.att = (short)(j3DPrimitive.att | 0x880);
                    break;
                }
                case 3: {
                    j3DPrimitive.att = (short)(j3DPrimitive.att | 0x840);
                }
            }
            ++n;
        }
    }

    public void getDoublePoints(Vector vector) {
        this.getDoublePoints(vector, this.mDObjects);
        this.getDoublePoints(vector, this.mSObjects);
        this.getDoublePoints(vector, this.mXObjects);
    }

    private void getDoublePoints(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector2.size()) {
            J3DObject j3DObject = (J3DObject)vector2.elementAt(n);
            Vector vector3 = j3DObject.getPrimitives();
            int n2 = 0;
            while (n2 < vector3.size()) {
                J3DPrimitive j3DPrimitive = (J3DPrimitive)vector3.elementAt(n2);
                int n3 = 0;
                while (n3 < j3DPrimitive.vtx.length) {
                    vector.addElement(new double[]{j3DPrimitive.vtx[n3].x, j3DPrimitive.vtx[n3].y, j3DPrimitive.vtx[n3].z});
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void removeAllObject(int n) {
        switch (n) {
            case 0: {
                this.mSObjects.removeAllElements();
                break;
            }
            case 1: {
                this.mDObjects.removeAllElements();
                break;
            }
            case 2: 
            case 3: {
                this.mXObjects.removeAllElements();
            }
        }
    }

    public void removeAllObject() {
        this.removeAllObject(0);
        this.removeAllObject(1);
        this.removeAllObject(2);
    }

    public void removeObject(int n) {
        Vector vector = new Vector();
        this.removeObject(n, this.mSObjects, vector);
        this.removeObject(n, this.mDObjects, vector);
        this.removeObject(n, this.mXObjects, vector);
    }

    private void removeObject(int n, Vector vector, Vector vector2) {
        int n2 = 0;
        while (n2 < vector.size()) {
            J3DObject j3DObject = (J3DObject)vector.elementAt(n2);
            if (j3DObject.mId == n) {
                vector2.addElement(j3DObject);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            vector.remove(vector2.elementAt(n2));
            ++n2;
        }
        vector2.removeAllElements();
    }

    public void resize(int n, int n2) {
        if (this.BUFFERW == n && this.BUFFERH == n2) {
            return;
        }
        if (n <= 0) {
            n = 10;
        }
        if (n2 <= 0) {
            n2 = 10;
        }
        this.BUFFERW = n;
        this.BUFFERH = n2;
        this.ss_zbuffer = new int[this.BUFFERW * this.BUFFERH];
        this.ss_current = new int[this.BUFFERW * this.BUFFERH];
        this.mMin = new J3DTLVertex[this.BUFFERH];
        this.mMax = new J3DTLVertex[this.BUFFERH];
        int n3 = 0;
        while (n3 < this.BUFFERH) {
            this.mMin[n3] = new J3DTLVertex();
            this.mMax[n3] = new J3DTLVertex();
            this.mMin[n3].x = Integer.MAX_VALUE;
            this.mMax[n3].x = -2147483647;
            ++n3;
        }
        this.setPers(this.mPers);
    }

    private int getBlend(int n, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 >> 16 & 0xFF;
        int n7 = n2 >> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        n3 = (n3 + n6) / 2;
        n4 = (n4 + n7) / 2;
        n5 = (n5 + n8) / 2;
        return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
    }

    public void setCameraPosition(float f, float f2, float f3) {
        this.mCameraPos.x = f;
        this.mCameraPos.y = f2;
        this.mCameraPos.z = f3;
        this.mView.view(this.mCameraPos, this.mCameraTarget, this.mCameraUp);
    }

    public void setCameraTarget(float f, float f2, float f3) {
        this.mCameraTarget.x = f;
        this.mCameraTarget.y = f2;
        this.mCameraTarget.z = f3;
        this.mView.view(this.mCameraPos, this.mCameraTarget, this.mCameraUp);
    }

    public void setCameraUp(float f, float f2, float f3) {
        this.mCameraUp.x = f;
        this.mCameraUp.y = f2;
        this.mCameraUp.z = f3;
        this.mView.view(this.mCameraPos, this.mCameraTarget, this.mCameraUp);
    }

    public void setPers(float f) {
        this.mPers = f;
        J3DMatrix j3DMatrix = new J3DMatrix();
        this.mProj.initialize();
        j3DMatrix.projection(this.mPers, (float)this.BUFFERH / (float)this.BUFFERW);
        this.mProj.mult(j3DMatrix);
        j3DMatrix.clip(-1.0, 1.0, 2.0, 2.0, 100.0, 4000.0);
        this.mProj.mult(j3DMatrix);
        j3DMatrix.viewPort(0.0, 0.0, this.BUFFERW * this.ss_samplegrid, this.BUFFERH * this.ss_samplegrid);
        this.mProj.mult(j3DMatrix);
    }

    public void setState(int n) {
        this.mRenderState = n;
    }

    public void setReductMode(boolean bl) {
        this.ss_reductmode = bl;
    }

    public void setSample(int n) {
        if (n < 1) {
            n = 1;
        }
        if (5 < n) {
            n = 5;
        }
        this.ss_samplegrid = n;
        this.setPers(this.mPers);
    }

    public int getSample() {
        return this.ss_samplegrid;
    }

    public int getState() {
        return this.mRenderState;
    }

    public void setLight(float f, float f2, float f3, int n, int n2) {
        this.mLight.x = f;
        this.mLight.y = f2;
        this.mLight.z = f3;
        this.mLight.normalize();
        this.mDifColor = n;
        this.mAmbColor = n2;
    }

    private int lighting(J3DVector j3DVector) {
        int n;
        float f = 0.1f;
        float f2 = (float)j3DVector.dotProduct(this.mLight);
        if ((f2 = f2 * (1.0f - f) + f) > 0.0f) {
            int n2 = (int)((float)(this.mDifColor >> 16 & 0xFF) * f2) + (this.mAmbColor >> 16 & 0xFF);
            int n3 = (int)((float)(this.mDifColor >> 8 & 0xFF) * f2) + (this.mAmbColor >> 8 & 0xFF);
            int n4 = (int)((float)(this.mDifColor & 0xFF) * f2) + (this.mAmbColor & 0xFF);
            if (n2 > 255) {
                n2 = 255;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            n = n2 << 16 | n3 << 8 | n4;
        } else {
            n = this.mAmbColor;
        }
        return n | 0xFF000000;
    }

    private void drawObjects(Vector vector) {
        this.mLineMode = false;
        this.mMaster.initialize();
        this.mMaster.mult(this.mView);
        this.mMaster.mult(this.mProj);
        int n = 0;
        while (n < vector.size()) {
            J3DObject j3DObject = (J3DObject)vector.elementAt(n);
            Vector vector2 = j3DObject.getPrimitives();
            int n2 = 0;
            while (n2 < vector2.size()) {
                this.drawPrimitive((J3DPrimitive)vector2.elementAt(n2), j3DObject.mPosX, j3DObject.mPosY, j3DObject.mPosZ);
                ++n2;
            }
            ++n;
        }
    }

    private void drawAlphaPrimitives() {
        J3DPrimitive j3DPrimitive;
        int n;
        J3DPrimitive[] j3DPrimitiveArray = this.mPmvBuffer;
        int n2 = 0;
        J3DPrimitive j3DPrimitive2 = this.mAlphaPmv[0];
        int n3 = 0;
        while (n3 < this.mAlphaPmvCount) {
            if (n3 + 1 >= this.mMaxAlphaPmvSize) {
                this.mLog.info((Object)"The 'alpha array' isn't enough.");
                break;
            }
            if ((this.mAlphaPmv[n3].att & 0x10) != 0) {
                this.mAlphaPmv[n3].next = this.mAlphaPmv[n3 + 1];
            } else {
                this.mAlphaPmv[n3].next = null;
                j3DPrimitiveArray[n2++] = j3DPrimitive2;
                j3DPrimitive2.z = 0;
                n = 0;
                while (n < j3DPrimitive2.tvtx.length) {
                    if (j3DPrimitive2.z < j3DPrimitive2.tvtx[n].z) {
                        j3DPrimitive2.z = j3DPrimitive2.tvtx[n].z;
                    }
                    ++n;
                }
                j3DPrimitive2 = this.mAlphaPmv[n3 + 1];
            }
            ++n3;
        }
        int n4 = 1;
        while (n4 < n2 / 9) {
            n4 = n4 * 3 + 1;
        }
        while (n4 > 0) {
            n3 = n4;
            while (n3 < n2) {
                if (n3 >= this.mMaxAlphaPmvSize) {
                    this.mLog.info((Object)"The 'alpha array' isn't enough.");
                    break;
                }
                n = n3;
                while (n >= n4 && j3DPrimitiveArray[n - n4].z < j3DPrimitiveArray[n].z) {
                    j3DPrimitive = j3DPrimitiveArray[n];
                    j3DPrimitiveArray[n] = j3DPrimitiveArray[n - n4];
                    j3DPrimitiveArray[n - n4] = j3DPrimitive;
                    n -= n4;
                }
                n3 += n4;
            }
            n4 /= 3;
        }
        n3 = 0;
        while (n3 < n2) {
            j3DPrimitive = j3DPrimitiveArray[n3];
            do {
                this.drawAlphaPolygon(j3DPrimitive, j3DPrimitive.tvtx, j3DPrimitive.tvtx.length);
            } while ((j3DPrimitive = j3DPrimitive.next) != null);
            ++n3;
        }
        this.mAlphaPmvCount = 0;
    }

    private void drawPrimitive(J3DPrimitive j3DPrimitive, float f, float f2, float f3) {
        float f4;
        J3DVertex j3DVertex;
        Object object;
        J3DMatrix j3DMatrix = this.mMaster;
        J3DVertex[] j3DVertexArray = this.mVertexBuf1;
        J3DVertex[] j3DVertexArray2 = this.mVertexBuf2;
        J3DVertex[] j3DVertexArray3 = this.mVertexBuf;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f5 = 0.0f;
        float f6 = this.BUFFERW * this.ss_samplegrid;
        float f7 = 0.0f;
        float f8 = this.BUFFERH * this.ss_samplegrid;
        float f9 = j3DPrimitive.tex != null ? j3DPrimitive.tex.w : 0;
        float f10 = j3DPrimitive.tex != null ? j3DPrimitive.tex.h : 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < j3DPrimitive.vtx.length) {
            object = j3DVertexArray3[n3++];
            j3DVertex = j3DPrimitive.vtx[n5];
            float f11 = j3DVertex.x + f;
            f4 = j3DVertex.y + f2;
            float f12 = j3DVertex.z + f3;
            ((J3DVertex)object).z = (float)(j3DMatrix.m03 * (double)f11 + j3DMatrix.m13 * (double)f4 + j3DMatrix.m23 * (double)f12 + j3DMatrix.m33);
            ((J3DVertex)object).w = 1.0f / ((J3DVertex)object).z;
            ((J3DVertex)object).x = (float)((j3DMatrix.m00 * (double)f11 + j3DMatrix.m10 * (double)f4 + j3DMatrix.m20 * (double)f12 + j3DMatrix.m30) * (double)((J3DVertex)object).w);
            ((J3DVertex)object).y = (float)((j3DMatrix.m01 * (double)f11 + j3DMatrix.m11 * (double)f4 + j3DMatrix.m21 * (double)f12 + j3DMatrix.m31) * (double)(-((J3DVertex)object).w));
            ((J3DVertex)object).u = j3DVertex.u * f9 * ((J3DVertex)object).w;
            ((J3DVertex)object).v = j3DVertex.v * f10 * ((J3DVertex)object).w;
            ((J3DVertex)object).edge = j3DVertex.edge;
            if (((J3DVertex)object).x < f5) {
                n4 |= 1;
            } else if (((J3DVertex)object).x > f6) {
                n4 |= 2;
            }
            if (((J3DVertex)object).y < f7) {
                n4 |= 4;
            } else if (((J3DVertex)object).y > f8) {
                n4 |= 8;
            }
            if (((J3DVertex)object).z < 1.0f) {
                n4 |= 0x10;
            }
            j3DVertexArray2[n2++] = object;
            ++n5;
        }
        if ((n4 & 0x10) != 0) {
            J3DVertex[] j3DVertexArray4 = j3DVertexArray;
            j3DVertexArray = j3DVertexArray2;
            j3DVertexArray2 = j3DVertexArray4;
            n = n2;
            n2 = 0;
            int n6 = 0;
            while (n6 < n) {
                j3DVertex = j3DVertexArray[n6];
                J3DVertex j3DVertex2 = j3DVertexArray[(n6 + 1) % n];
                if (j3DVertex.z >= 1.0f) {
                    j3DVertexArray2[n2++] = j3DVertex;
                }
                if (j3DVertex.z >= 1.0f && j3DVertex2.z < 1.0f || j3DVertex.z < 1.0f && j3DVertex2.z >= 1.0f) {
                    J3DVertex j3DVertex3 = j3DPrimitive.vtx[n6];
                    J3DVertex j3DVertex4 = j3DPrimitive.vtx[(n6 + 1) % j3DPrimitive.vtx.length];
                    float f13 = (j3DVertex.z - 1.0f) / (j3DVertex.z - j3DVertex2.z);
                    float f14 = j3DVertex3.x + f13 * (j3DVertex4.x - j3DVertex3.x);
                    float f15 = j3DVertex3.y + f13 * (j3DVertex4.y - j3DVertex3.y);
                    float f16 = j3DVertex3.z + f13 * (j3DVertex4.z - j3DVertex3.z);
                    float f17 = j3DVertex3.u + f13 * (j3DVertex4.u - j3DVertex3.u);
                    float f18 = j3DVertex3.v + f13 * (j3DVertex4.v - j3DVertex3.v);
                    J3DVertex j3DVertex5 = j3DVertexArray3[n3++];
                    j3DVertex5.x = (float)(j3DMatrix.m00 * (double)f14 + j3DMatrix.m10 * (double)f15 + j3DMatrix.m20 * (double)f16 + j3DMatrix.m30);
                    j3DVertex5.y = (float)(-(j3DMatrix.m01 * (double)f14 + j3DMatrix.m11 * (double)f15 + j3DMatrix.m21 * (double)f16 + j3DMatrix.m31));
                    j3DVertex5.z = 1.0f;
                    j3DVertex5.w = 1.0f;
                    j3DVertex5.u = f17 * f9;
                    j3DVertex5.v = f18 * f10;
                    if (j3DVertex5.x < f5) {
                        n4 |= 1;
                    } else if (j3DVertex5.x > f6) {
                        n4 |= 2;
                    }
                    if (j3DVertex5.y < f7) {
                        n4 |= 4;
                    } else if (j3DVertex5.y > f8) {
                        n4 |= 8;
                    }
                    j3DVertexArray2[n2++] = j3DVertex5;
                }
                ++n6;
            }
            if (n2 < 3) {
                return;
            }
        }
        if ((n4 & 1) != 0) {
            J3DVertex[] j3DVertexArray5 = j3DVertexArray;
            j3DVertexArray = j3DVertexArray2;
            j3DVertexArray2 = j3DVertexArray5;
            n = n2;
            n2 = 0;
            int n7 = 0;
            while (n7 < n) {
                j3DVertex = j3DVertexArray[n7];
                J3DVertex j3DVertex6 = j3DVertexArray[(n7 + 1) % n];
                if (j3DVertex.x >= f5) {
                    j3DVertexArray2[n2++] = j3DVertex;
                }
                if (j3DVertex.x >= f5 && j3DVertex6.x < f5 || j3DVertex.x < f5 && j3DVertex6.x >= f5) {
                    f4 = (j3DVertex.x - f5) / (j3DVertex.x - j3DVertex6.x);
                    J3DVertex j3DVertex7 = j3DVertexArray3[n3++];
                    j3DVertex7.x = f5;
                    j3DVertex7.y = j3DVertex.y + f4 * (j3DVertex6.y - j3DVertex.y);
                    j3DVertex7.z = j3DVertex.z + f4 * (j3DVertex6.z - j3DVertex.z);
                    j3DVertex7.w = j3DVertex.w + f4 * (j3DVertex6.w - j3DVertex.w);
                    j3DVertex7.u = j3DVertex.u + f4 * (j3DVertex6.u - j3DVertex.u);
                    j3DVertex7.v = j3DVertex.v + f4 * (j3DVertex6.v - j3DVertex.v);
                    if (j3DVertex7.x > f6) {
                        n4 |= 2;
                    }
                    if (j3DVertex7.y < f7) {
                        n4 |= 4;
                    } else if (j3DVertex7.y > f8) {
                        n4 |= 8;
                    }
                    j3DVertexArray2[n2++] = j3DVertex7;
                }
                ++n7;
            }
            if (n2 < 3) {
                return;
            }
        }
        if ((n4 & 2) != 0) {
            J3DVertex[] j3DVertexArray6 = j3DVertexArray;
            j3DVertexArray = j3DVertexArray2;
            j3DVertexArray2 = j3DVertexArray6;
            n = n2;
            n2 = 0;
            int n8 = 0;
            while (n8 < n) {
                j3DVertex = j3DVertexArray[n8];
                J3DVertex j3DVertex8 = j3DVertexArray[(n8 + 1) % n];
                if (j3DVertex.x < f6) {
                    j3DVertexArray2[n2++] = j3DVertex;
                }
                if (j3DVertex.x < f6 && j3DVertex8.x >= f6 || j3DVertex.x >= f6 && j3DVertex8.x < f6) {
                    f4 = (j3DVertex.x - f6) / (j3DVertex.x - j3DVertex8.x);
                    J3DVertex j3DVertex9 = j3DVertexArray3[n3++];
                    j3DVertex9.x = f6 - 1.0f;
                    j3DVertex9.y = j3DVertex.y + f4 * (j3DVertex8.y - j3DVertex.y);
                    j3DVertex9.z = j3DVertex.z + f4 * (j3DVertex8.z - j3DVertex.z);
                    j3DVertex9.w = j3DVertex.w + f4 * (j3DVertex8.w - j3DVertex.w);
                    j3DVertex9.u = j3DVertex.u + f4 * (j3DVertex8.u - j3DVertex.u);
                    j3DVertex9.v = j3DVertex.v + f4 * (j3DVertex8.v - j3DVertex.v);
                    if (j3DVertex9.y < f7) {
                        n4 |= 4;
                    } else if (j3DVertex9.y > f8) {
                        n4 |= 8;
                    }
                    j3DVertexArray2[n2++] = j3DVertex9;
                }
                ++n8;
            }
            if (n2 < 3) {
                return;
            }
        }
        if ((n4 & 4) != 0) {
            J3DVertex[] j3DVertexArray7 = j3DVertexArray;
            j3DVertexArray = j3DVertexArray2;
            j3DVertexArray2 = j3DVertexArray7;
            n = n2;
            n2 = 0;
            int n9 = 0;
            while (n9 < n) {
                j3DVertex = j3DVertexArray[n9];
                J3DVertex j3DVertex10 = j3DVertexArray[(n9 + 1) % n];
                if (j3DVertex.y >= f7) {
                    j3DVertexArray2[n2++] = j3DVertex;
                }
                if (j3DVertex.y >= f7 && j3DVertex10.y < f7 || j3DVertex.y < f7 && j3DVertex10.y >= f7) {
                    f4 = (j3DVertex.y - f7) / (j3DVertex.y - j3DVertex10.y);
                    J3DVertex j3DVertex11 = j3DVertexArray3[n3++];
                    j3DVertex11.x = j3DVertex.x + f4 * (j3DVertex10.x - j3DVertex.x);
                    j3DVertex11.y = f7;
                    j3DVertex11.z = j3DVertex.z + f4 * (j3DVertex10.z - j3DVertex.z);
                    j3DVertex11.w = j3DVertex.w + f4 * (j3DVertex10.w - j3DVertex.w);
                    j3DVertex11.u = j3DVertex.u + f4 * (j3DVertex10.u - j3DVertex.u);
                    j3DVertex11.v = j3DVertex.v + f4 * (j3DVertex10.v - j3DVertex.v);
                    if (j3DVertex11.y > f8) {
                        n4 |= 8;
                    }
                    j3DVertexArray2[n2++] = j3DVertex11;
                }
                ++n9;
            }
            if (n2 < 3) {
                return;
            }
        }
        if ((n4 & 8) != 0) {
            J3DVertex[] j3DVertexArray8 = j3DVertexArray;
            j3DVertexArray = j3DVertexArray2;
            j3DVertexArray2 = j3DVertexArray8;
            n = n2;
            n2 = 0;
            int n10 = 0;
            while (n10 < n) {
                j3DVertex = j3DVertexArray[n10];
                J3DVertex j3DVertex12 = j3DVertexArray[(n10 + 1) % n];
                if (j3DVertex.y < f8) {
                    j3DVertexArray2[n2++] = j3DVertex;
                }
                if (j3DVertex.y < f8 && j3DVertex12.y >= f8 || j3DVertex.y >= f8 && j3DVertex12.y < f8) {
                    f4 = (j3DVertex.y - f8) / (j3DVertex.y - j3DVertex12.y);
                    J3DVertex j3DVertex13 = j3DVertexArray3[n3++];
                    j3DVertex13.x = j3DVertex.x + f4 * (j3DVertex12.x - j3DVertex.x);
                    j3DVertex13.y = f8 - 1.0f;
                    j3DVertex13.z = j3DVertex.z + f4 * (j3DVertex12.z - j3DVertex.z);
                    j3DVertex13.w = j3DVertex.w + f4 * (j3DVertex12.w - j3DVertex.w);
                    j3DVertex13.u = j3DVertex.u + f4 * (j3DVertex12.u - j3DVertex.u);
                    j3DVertex13.v = j3DVertex.v + f4 * (j3DVertex12.v - j3DVertex.v);
                    j3DVertexArray2[n2++] = j3DVertex13;
                }
                ++n10;
            }
        }
        if (n2 < 3) {
            return;
        }
        if ((j3DPrimitive.att & 0x400) == 0 && this.curring(j3DVertexArray2, n2)) {
            return;
        }
        if ((this.mRenderState & 8) != 0 || this.ss_reductline && this.ss_reductmode) {
            int[] nArray = new int[n2];
            object = new int[n2];
            int n11 = 0;
            while (n11 < n2) {
                nArray[n11] = (int)(j3DVertexArray2[n11].x / (float)this.ss_samplegrid);
                object[n11] = (int)(j3DVertexArray2[n11].y / (float)this.ss_samplegrid);
                ++n11;
            }
            this.ss_drawPolygon(nArray, (int[])object, Color.LIGHT_GRAY, n2);
        } else if ((j3DPrimitive.att & 0x800) != 0) {
            j3DPrimitive.tvtx = new J3DTLVertex[n2];
            int n12 = 0;
            while (n12 < n2) {
                object = new J3DTLVertex();
                j3DVertex = j3DVertexArray2[n12];
                ((J3DTLVertex)object).x = (int)(j3DVertex.x * 65536.0f);
                ((J3DTLVertex)object).y = (int)(j3DVertex.y * 65536.0f);
                ((J3DTLVertex)object).z = (int)(j3DVertex.w * 2.6843546E8f) ^ 0xFFFFFFF;
                ((J3DTLVertex)object).w = j3DVertex.w;
                ((J3DTLVertex)object).u = j3DVertex.u;
                ((J3DTLVertex)object).v = j3DVertex.v;
                ((J3DTLVertex)object).edge = j3DVertex.edge;
                j3DPrimitive.tvtx[n12] = object;
                this.translateLighting(j3DPrimitive, j3DVertex, (J3DTLVertex)object);
                ++n12;
            }
            if (this.mAlphaPmvCount < this.mMaxAlphaPmvSize) {
                this.mAlphaPmv[this.mAlphaPmvCount++] = j3DPrimitive;
            } else {
                this.mLog.info((Object)"The 'alpha array' isn't enough.");
            }
        } else {
            int n13 = 0;
            while (n13 < n2) {
                object = this.mTLVertex[n13];
                j3DVertex = j3DVertexArray2[n13];
                ((J3DTLVertex)object).x = (int)(j3DVertex.x * 65536.0f);
                ((J3DTLVertex)object).y = (int)(j3DVertex.y * 65536.0f);
                ((J3DTLVertex)object).z = (int)(j3DVertex.w * 2.6843546E8f) ^ 0xFFFFFFF;
                ((J3DTLVertex)object).w = j3DVertex.w;
                ((J3DTLVertex)object).u = j3DVertex.u;
                ((J3DTLVertex)object).v = j3DVertex.v;
                ((J3DTLVertex)object).edge = j3DVertex.edge;
                this.translateLighting(j3DPrimitive, j3DVertex, (J3DTLVertex)object);
                ++n13;
            }
            if (this.mLineMode) {
                this.drawWire(j3DPrimitive, this.mTLVertex, n2);
            } else {
                this.drawPolygon(j3DPrimitive, this.mTLVertex, n2);
            }
        }
    }

    private void translateLighting(J3DPrimitive j3DPrimitive, J3DVertex j3DVertex, J3DTLVertex j3DTLVertex) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = this.mBCameraPos.x - this.mBCameraTarget.x;
        double d2 = this.mBCameraPos.y - this.mBCameraTarget.y;
        double d3 = this.mBCameraPos.z - this.mBCameraTarget.z;
        this.nn.set(d, d2, d3);
        this.nn.normalize();
        d = this.nn.x;
        d2 = this.nn.y;
        d3 = this.nn.z;
        double d4 = this.mLight.dotProduct(j3DPrimitive.normal);
        n = (int)((double)(this.mDifColor >> 16 & 0xFF) * d4) + (this.mAmbColor >> 16 & 0xFF);
        n2 = (int)((double)(this.mDifColor >> 8 & 0xFF) * d4) + (this.mAmbColor >> 8 & 0xFF);
        n3 = (int)((double)(this.mDifColor & 0xFF) * d4) + (this.mAmbColor & 0xFF);
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        J3DVector j3DVector = new J3DVector(d, d2, d3);
        j3DVector.normalize();
        j3DVector.set(0.0, 0.0, 1.0);
        this.nn.set(j3DPrimitive.normal.x, j3DPrimitive.normal.y, j3DPrimitive.normal.z);
        this.nn.normalize();
        this.nn.x = this.nn.x * 2.0 * d4 - j3DVector.x;
        this.nn.y = this.nn.y * 2.0 * d4 - j3DVector.y;
        this.nn.z = this.nn.z * 2.0 * d4 - j3DVector.z;
        this.nn.normalize();
        J3DVector j3DVector2 = new J3DVector(d, d2, d3);
        j3DVector2.normalize();
        double d5 = this.nn.dotProduct(j3DVector2);
        if (d5 > 0.0) {
            d5 *= d5;
            d5 *= d5;
            n4 = (int)(d5 * 0.2 * 255.0 * 65535.0);
            n5 = (int)(d5 * 0.2 * 255.0 * 65535.0);
            n6 = (int)(d5 * 0.2 * 255.0 * 65535.0);
        } else {
            n4 = 0;
            n5 = 0;
            n6 = 0;
        }
        j3DTLVertex.r = n;
        j3DTLVertex.g = n2;
        j3DTLVertex.b = n3;
        j3DTLVertex.sr = n4;
        j3DTLVertex.sg = n5;
        j3DTLVertex.sb = n6;
    }

    private boolean curring(J3DVertex[] j3DVertexArray, int n) {
        int n2 = 2;
        while (n2 < n) {
            if ((j3DVertexArray[n2 - 1].x - j3DVertexArray[0].x) * (j3DVertexArray[n2].y - j3DVertexArray[0].y) - (j3DVertexArray[n2 - 1].y - j3DVertexArray[0].y) * (j3DVertexArray[n2].x - j3DVertexArray[0].x) <= 0.0f) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void drawPolygon(J3DPrimitive j3DPrimitive, J3DTLVertex[] j3DTLVertexArray, int n) {
        int n2 = (this.mRenderState | j3DPrimitive.att) & 0xFF;
        if (j3DPrimitive.tex == null) {
            n2 &= 0xFFFFFFFE;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            this.scanEdge(j3DTLVertexArray[n3], j3DTLVertexArray[n3 + 1], n2);
            ++n3;
        }
        this.scanEdge(j3DTLVertexArray[n - 1], j3DTLVertexArray[0], n2);
        n3 = 0;
        int[] nArray = this.ss_zbuffer;
        int[] nArray2 = this.ss_current;
        switch (n2) {
            case 0: 
            case 2: {
                int n4 = 0;
                while (n4 < this.BUFFERH) {
                    if (!(this.ss_reductmode & n4 % 2 == 0) && this.mMin[n4].x != Integer.MAX_VALUE) {
                        J3DTLVertex j3DTLVertex = this.mMin[n4];
                        J3DTLVertex j3DTLVertex2 = this.mMax[n4];
                        int n5 = j3DTLVertex2.x - j3DTLVertex.x;
                        if (n5 > 0) {
                            int n6 = (j3DTLVertex2.r - j3DTLVertex.r) / n5;
                            int n7 = (j3DTLVertex2.g - j3DTLVertex.g) / n5;
                            int n8 = (j3DTLVertex2.b - j3DTLVertex.b) / n5;
                            int n9 = (j3DTLVertex2.sr - j3DTLVertex.sr) / n5;
                            int n10 = (j3DTLVertex2.sg - j3DTLVertex.sg) / n5;
                            int n11 = (j3DTLVertex2.sb - j3DTLVertex.sb) / n5;
                            int n12 = j3DTLVertex.r;
                            int n13 = j3DTLVertex.g;
                            int n14 = j3DTLVertex.b;
                            int n15 = j3DTLVertex.sr;
                            int n16 = j3DTLVertex.sg;
                            int n17 = j3DTLVertex.sb;
                            int n18 = 0;
                            j3DTLVertex.x += n3;
                            j3DTLVertex2.x += n3;
                            int n19 = j3DTLVertex.x;
                            while (n19 < j3DTLVertex2.x) {
                                int n20 = j3DTLVertex.z + n18 * (j3DTLVertex2.z - j3DTLVertex.z) / n5;
                                if (nArray[n19] > n20) {
                                    int n21;
                                    if (this.ss_shadecolor) {
                                        int n22 = j3DPrimitive.color;
                                        int n23 = ((n12 & 0xFF) * (n22 >> 16 & 0xFF) >> 8) + (n15 >> 16);
                                        int n24 = ((n13 & 0xFF) * (n22 >> 8 & 0xFF) >> 8) + (n16 >> 16);
                                        int n25 = ((n14 & 0xFF) * (n22 & 0xFF) >> 8) + (n17 >> 16);
                                        if (n23 > 255) {
                                            n23 = 255;
                                        }
                                        if (n24 > 255) {
                                            n24 = 255;
                                        }
                                        if (n25 > 255) {
                                            n25 = 255;
                                        }
                                        n21 = n23 << 16 | n24 << 8 | n25 | 0xFF000000;
                                    } else {
                                        n21 = BGCOLOR;
                                    }
                                    nArray2[n19] = n21;
                                    nArray[n19] = n20;
                                } else {
                                    int n26 = n19;
                                    nArray[n26] = nArray[n26] & Integer.MAX_VALUE;
                                }
                                ++n19;
                                ++n18;
                                n12 += n6;
                                n13 += n7;
                                n14 += n8;
                                n15 += n9;
                                n16 += n10;
                                n17 += n11;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex2.x = -2147483647;
                    }
                    ++n4;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 3: {
                int[] nArray3 = j3DPrimitive.tex.buf;
                int n27 = j3DPrimitive.tex.w - 1;
                int n28 = j3DPrimitive.tex.h - 1;
                int n29 = j3DPrimitive.tex.shift;
                int n30 = 0;
                while (n30 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n30 % 2 == 0 || this.mMin[n30].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n30];
                        J3DTLVertex j3DTLVertex3 = this.mMax[n30];
                        int n31 = j3DTLVertex3.x - j3DTLVertex.x;
                        if (n31 > 0) {
                            int n32 = (j3DTLVertex3.r - j3DTLVertex.r) / n31;
                            int n33 = (j3DTLVertex3.g - j3DTLVertex.g) / n31;
                            int n34 = (j3DTLVertex3.b - j3DTLVertex.b) / n31;
                            int n35 = j3DTLVertex.r;
                            int n36 = j3DTLVertex.g;
                            int n37 = j3DTLVertex.b;
                            int n38 = (j3DTLVertex3.sr - j3DTLVertex.sr) / n31;
                            int n39 = (j3DTLVertex3.sg - j3DTLVertex.sg) / n31;
                            int n40 = (j3DTLVertex3.sb - j3DTLVertex.sb) / n31;
                            int n41 = j3DTLVertex.sr;
                            int n42 = j3DTLVertex.sg;
                            int n43 = j3DTLVertex.sb;
                            float f = (j3DTLVertex3.u - j3DTLVertex.u) / (float)n31;
                            float f2 = (j3DTLVertex3.v - j3DTLVertex.v) / (float)n31;
                            float f3 = (j3DTLVertex3.w - j3DTLVertex.w) / (float)n31;
                            float f4 = j3DTLVertex.u;
                            float f5 = j3DTLVertex.v;
                            float f6 = j3DTLVertex.w;
                            j3DTLVertex.x += n3;
                            j3DTLVertex3.x += n3;
                            int n44 = 0;
                            int n45 = j3DTLVertex.x;
                            while (n45 < j3DTLVertex3.x) {
                                int n46 = j3DTLVertex.z + n44 * (j3DTLVertex3.z - j3DTLVertex.z) / n31;
                                if (nArray[n45] > n46) {
                                    if (this.ss_shadecolor) {
                                        double d = 1.0f / f6;
                                        int n47 = (int)((double)f4 * d);
                                        int n48 = (int)((double)f5 * d);
                                        int n49 = nArray3[(n48 & n28) << n29 | n47 & n27];
                                        int n50 = n49 >> 16 & 0xFF;
                                        int n51 = n49 >> 8 & 0xFF;
                                        int n52 = n49 & 0xFF;
                                        int n53 = ((n35 & 0xFF) * n50 >> 8) + (n41 >> 16);
                                        int n54 = ((n36 & 0xFF) * n51 >> 8) + (n42 >> 16);
                                        int n55 = ((n37 & 0xFF) * n52 >> 8) + (n43 >> 16);
                                        if (n53 > 255) {
                                            n53 = 255;
                                        }
                                        if (n54 > 255) {
                                            n54 = 255;
                                        }
                                        if (n55 > 255) {
                                            n55 = 255;
                                        }
                                        nArray2[n45] = n53 << 16 | n54 << 8 | n55 | 0xFF000000;
                                    } else {
                                        nArray2[n45] = BGCOLOR;
                                    }
                                    nArray[n45] = n46;
                                } else {
                                    int n56 = n45;
                                    nArray[n56] = nArray[n56] & Integer.MAX_VALUE;
                                }
                                ++n45;
                                f4 += f;
                                f5 += f2;
                                f6 += f3;
                                ++n44;
                                n35 += n32;
                                n36 += n33;
                                n37 += n34;
                                n41 += n38;
                                n42 += n39;
                                n43 += n40;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex3.x = -2147483647;
                    }
                    ++n30;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 1: {
                int[] nArray4 = j3DPrimitive.tex.buf;
                int n57 = j3DPrimitive.tex.w - 1;
                int n58 = j3DPrimitive.tex.h - 1;
                int n59 = j3DPrimitive.tex.shift;
                int n60 = 0;
                while (n60 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n60 % 2 == 0 || this.mMin[n60].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n60];
                        J3DTLVertex j3DTLVertex4 = this.mMax[n60];
                        int n61 = j3DTLVertex4.x - j3DTLVertex.x;
                        if (n61 > 0) {
                            float f = (j3DTLVertex4.u - j3DTLVertex.u) / (float)n61;
                            float f7 = (j3DTLVertex4.v - j3DTLVertex.v) / (float)n61;
                            float f8 = (j3DTLVertex4.w - j3DTLVertex.w) / (float)n61;
                            float f9 = j3DTLVertex.u;
                            float f10 = j3DTLVertex.v;
                            float f11 = j3DTLVertex.w;
                            j3DTLVertex.x += n3;
                            j3DTLVertex4.x += n3;
                            int n62 = 0;
                            int n63 = j3DTLVertex.x;
                            while (n63 < j3DTLVertex4.x) {
                                int n64 = j3DTLVertex.z + n62 * (j3DTLVertex4.z - j3DTLVertex.z) / n61;
                                if (nArray[n63] > n64) {
                                    double d = 1.0f / f11;
                                    int n65 = (int)((double)f9 * d);
                                    int n66 = (int)((double)f10 * d);
                                    nArray2[n63] = this.ss_shadecolor ? nArray4[(n66 & n58) << n59 | n65 & n57] : BGCOLOR;
                                    nArray[n63] = n64;
                                } else {
                                    int n67 = n63;
                                    nArray[n67] = nArray[n67] & Integer.MAX_VALUE;
                                }
                                ++n63;
                                f9 += f;
                                f10 += f7;
                                f11 += f8;
                                ++n62;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex4.x = -2147483647;
                    }
                    ++n60;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                int n68 = 0;
                while (n68 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n68 % 2 == 0 || this.mMin[n68].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n68];
                        J3DTLVertex j3DTLVertex5 = this.mMax[n68];
                        if (j3DTLVertex5.x - j3DTLVertex.x > 0) {
                            j3DTLVertex.x += n3;
                            j3DTLVertex5.x += n3;
                            int n69 = j3DTLVertex.x;
                            while (n69 < j3DTLVertex5.x) {
                                int n70 = n69++;
                                nArray[n70] = nArray[n70] | Integer.MIN_VALUE;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex5.x = -2147483647;
                    }
                    ++n68;
                    n3 += this.BUFFERW;
                }
                break;
            }
        }
    }

    private void drawWirePolygon(J3DPrimitive j3DPrimitive, J3DTLVertex[] j3DTLVertexArray, int n) {
    }

    private void drawAlphaPolygon(J3DPrimitive j3DPrimitive, J3DTLVertex[] j3DTLVertexArray, int n) {
        if (!this.ss_shadecolor) {
            return;
        }
        int n2 = (this.mRenderState | j3DPrimitive.att) & 0xFF;
        if (j3DPrimitive.tex == null) {
            n2 &= 0xFFFFFFFE;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            this.scanEdge(j3DTLVertexArray[n3], j3DTLVertexArray[n3 + 1], n2);
            ++n3;
        }
        this.scanEdge(j3DTLVertexArray[n - 1], j3DTLVertexArray[0], n2);
        n3 = 0;
        int[] nArray = this.ss_zbuffer;
        int[] nArray2 = this.ss_current;
        switch (n2) {
            case 0: 
            case 2: {
                int n4 = j3DPrimitive.color;
                if ((n2 & 2) != 0) {
                    n4 = (n4 >> 16 & 0xFF) * (j3DPrimitive.light >> 16 & 0xFF) >> 8 << 16 | (n4 >> 8 & 0xFF) * (j3DPrimitive.light >> 8 & 0xFF) >> 8 << 8 | (n4 & 0xFF) * (j3DPrimitive.light & 0xFF) >> 8 | 0xFF000000;
                }
                int n5 = j3DPrimitive.alpha / 2;
                int n6 = 0;
                while (n6 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n6 % 2 == 0 || this.mMin[n6].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n6];
                        J3DTLVertex j3DTLVertex2 = this.mMax[n6];
                        int n7 = j3DTLVertex2.x - j3DTLVertex.x;
                        if (n7 > 0) {
                            int n8 = (j3DTLVertex2.z - j3DTLVertex.z) / n7;
                            int n9 = j3DTLVertex.z;
                            int n10 = (j3DTLVertex2.r - j3DTLVertex.r) / n7;
                            int n11 = (j3DTLVertex2.g - j3DTLVertex.g) / n7;
                            int n12 = (j3DTLVertex2.b - j3DTLVertex.b) / n7;
                            int n13 = (j3DTLVertex2.sr - j3DTLVertex.sr) / n7;
                            int n14 = (j3DTLVertex2.sg - j3DTLVertex.sg) / n7;
                            int n15 = (j3DTLVertex2.sb - j3DTLVertex.sb) / n7;
                            int n16 = j3DTLVertex.r;
                            int n17 = j3DTLVertex.g;
                            int n18 = j3DTLVertex.b;
                            int n19 = j3DTLVertex.sr;
                            int n20 = j3DTLVertex.sg;
                            int n21 = j3DTLVertex.sb;
                            j3DTLVertex.x += n3;
                            j3DTLVertex2.x += n3;
                            int n22 = j3DTLVertex.x;
                            while (n22 < j3DTLVertex2.x) {
                                if (nArray[n22] > n9) {
                                    int n23 = nArray2[n22];
                                    if (this.ss_shadecolor) {
                                        int n24 = j3DPrimitive.color;
                                        int n25 = n23 >> 16 & 0xFF;
                                        int n26 = n23 >> 8 & 0xFF;
                                        int n27 = n23 & 0xFF;
                                        int n28 = ((n16 & 0xFF) * (n24 >> 16 & 0xFF) >> 8) + (n19 >> 16);
                                        int n29 = ((n17 & 0xFF) * (n24 >> 8 & 0xFF) >> 8) + (n20 >> 16);
                                        int n30 = ((n18 & 0xFF) * (n24 & 0xFF) >> 8) + (n21 >> 16);
                                        int n31 = ((n28 - n25) * n5 >> 7) + n25 + (n19 >> 16);
                                        int n32 = ((n29 - n26) * n5 >> 7) + n26 + (n20 >> 16);
                                        int n33 = ((n30 - n27) * n5 >> 7) + n27 + (n21 >> 16);
                                        if (n31 > 255) {
                                            n31 = 255;
                                        }
                                        if (n32 > 255) {
                                            n32 = 255;
                                        }
                                        if (n33 > 255) {
                                            n33 = 255;
                                        }
                                        nArray2[n22] = n31 << 16 | n32 << 8 | n33 | 0xFF000000;
                                    } else {
                                        nArray2[n22] = BGCOLOR;
                                    }
                                } else {
                                    int n34 = n22;
                                    nArray[n34] = nArray[n34] & Integer.MAX_VALUE;
                                }
                                ++n22;
                                n9 += n8;
                                n16 += n10;
                                n17 += n11;
                                n18 += n12;
                                n19 += n13;
                                n20 += n14;
                                n21 += n15;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex2.x = -2147483647;
                    }
                    ++n6;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 3: {
                int n35;
                int[] nArray3 = j3DPrimitive.tex.buf;
                int n36 = j3DPrimitive.tex.w - 1;
                int n37 = j3DPrimitive.tex.h - 1;
                int n38 = j3DPrimitive.tex.shift;
                int n39 = n35 = j3DPrimitive.alpha / 2;
                int n40 = 0;
                while (n40 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n40 % 2 == 0 || this.mMin[n40].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n40];
                        J3DTLVertex j3DTLVertex3 = this.mMax[n40];
                        int n41 = j3DTLVertex3.x - j3DTLVertex.x;
                        if (n41 > 0) {
                            int n42 = (j3DTLVertex3.r - j3DTLVertex.r) / n41;
                            int n43 = (j3DTLVertex3.g - j3DTLVertex.g) / n41;
                            int n44 = (j3DTLVertex3.b - j3DTLVertex.b) / n41;
                            int n45 = j3DTLVertex.r;
                            int n46 = j3DTLVertex.g;
                            int n47 = j3DTLVertex.b;
                            int n48 = (j3DTLVertex3.sr - j3DTLVertex.sr) / n41;
                            int n49 = (j3DTLVertex3.sg - j3DTLVertex.sg) / n41;
                            int n50 = (j3DTLVertex3.sb - j3DTLVertex.sb) / n41;
                            int n51 = j3DTLVertex.sr;
                            int n52 = j3DTLVertex.sg;
                            int n53 = j3DTLVertex.sb;
                            float f = (j3DTLVertex3.u - j3DTLVertex.u) / (float)n41;
                            float f2 = (j3DTLVertex3.v - j3DTLVertex.v) / (float)n41;
                            float f3 = (j3DTLVertex3.w - j3DTLVertex.w) / (float)n41;
                            float f4 = j3DTLVertex.u;
                            float f5 = j3DTLVertex.v;
                            float f6 = j3DTLVertex.w;
                            j3DTLVertex.x += n3;
                            j3DTLVertex3.x += n3;
                            int n54 = 0;
                            int n55 = j3DTLVertex.x;
                            while (n55 < j3DTLVertex3.x) {
                                int n56 = j3DTLVertex.z + n54 * (j3DTLVertex3.z - j3DTLVertex.z) / n41;
                                if (nArray[n55] > n56) {
                                    int n57 = nArray2[n55];
                                    if (this.ss_shadecolor) {
                                        double d = 1.0f / f6;
                                        int n58 = (int)((double)f4 * d);
                                        int n59 = (int)((double)f5 * d);
                                        int n60 = nArray3[(n59 & n37) << n38 | n58 & n36];
                                        int n61 = n60 >> 16 & 0xFF;
                                        int n62 = n60 >> 8 & 0xFF;
                                        int n63 = n60 & 0xFF;
                                        int n64 = n60 >> 24 & 0xFF;
                                        n39 = n35;
                                        n39 = n64 != 255 ? n35 / 2 : 128;
                                        int n65 = ((n45 & 0xFF) * n61 >> 8) + (n51 >> 16);
                                        int n66 = ((n46 & 0xFF) * n62 >> 8) + (n52 >> 16);
                                        int n67 = ((n47 & 0xFF) * n63 >> 8) + (n53 >> 16);
                                        int n68 = n57 >> 16 & 0xFF;
                                        int n69 = n57 >> 8 & 0xFF;
                                        int n70 = n57 & 0xFF;
                                        int n71 = ((n65 - n68) * n39 >> 7) + n68 + (n51 >> 16);
                                        int n72 = ((n66 - n69) * n39 >> 7) + n69 + (n52 >> 16);
                                        int n73 = ((n67 - n70) * n39 >> 7) + n70 + (n53 >> 16);
                                        if (n71 > 255) {
                                            n71 = 255;
                                        }
                                        if (n72 > 255) {
                                            n72 = 255;
                                        }
                                        if (n73 > 255) {
                                            n73 = 255;
                                        }
                                        nArray2[n55] = n71 << 16 | n72 << 8 | n73 | 0xFF000000;
                                    } else {
                                        nArray2[n55] = BGCOLOR;
                                    }
                                    nArray[n55] = n56;
                                } else {
                                    int n74 = n55;
                                    nArray[n74] = nArray[n74] & Integer.MAX_VALUE;
                                }
                                ++n55;
                                f4 += f;
                                f5 += f2;
                                f6 += f3;
                                ++n54;
                                n45 += n42;
                                n46 += n43;
                                n47 += n44;
                                n51 += n48;
                                n52 += n49;
                                n53 += n50;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex3.x = -2147483647;
                    }
                    ++n40;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 1: {
                int[] nArray4 = j3DPrimitive.tex.buf;
                int n75 = j3DPrimitive.tex.w - 1;
                int n76 = j3DPrimitive.tex.h - 1;
                int n77 = j3DPrimitive.tex.shift;
                short s = j3DPrimitive.alpha;
                int n78 = 0;
                while (n78 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n78 % 2 == 0 || this.mMin[n78].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n78];
                        J3DTLVertex j3DTLVertex4 = this.mMax[n78];
                        int n79 = j3DTLVertex4.x - j3DTLVertex.x;
                        if (n79 > 0) {
                            int n80 = (j3DTLVertex4.z - j3DTLVertex.z) / n79;
                            float f = (j3DTLVertex4.u - j3DTLVertex.u) / (float)n79;
                            float f7 = (j3DTLVertex4.v - j3DTLVertex.v) / (float)n79;
                            float f8 = (j3DTLVertex4.w - j3DTLVertex.w) / (float)n79;
                            int n81 = j3DTLVertex.z;
                            float f9 = j3DTLVertex.u;
                            float f10 = j3DTLVertex.v;
                            float f11 = j3DTLVertex.w;
                            j3DTLVertex.x += n3;
                            j3DTLVertex4.x += n3;
                            int n82 = j3DTLVertex.x;
                            while (n82 < j3DTLVertex4.x) {
                                if (nArray[n82] > n81) {
                                    double d = 1.0f / f11;
                                    int n83 = (int)((double)f9 * d);
                                    int n84 = (int)((double)f10 * d);
                                    int n85 = nArray4[(n84 & n76) << n77 | n83 & n75];
                                    int n86 = nArray2[n82];
                                    if (this.ss_shadecolor) {
                                        int n87 = n86 >> 16 & 0xFF;
                                        int n88 = n86 >> 8 & 0xFF;
                                        int n89 = n86 & 0xFF;
                                        nArray2[n82] = (((n85 & 0xFF) - n89) * s >> 7) + n89 | (((n85 >> 8 & 0xFF) - n88) * s >> 7) + n88 << 8 | (((n85 >> 16 & 0xFF) - n87) * s >> 7) + n87 << 16 | 0xFF000000;
                                    } else {
                                        nArray2[n82] = BGCOLOR;
                                    }
                                } else {
                                    int n90 = n82;
                                    nArray[n90] = nArray[n90] & Integer.MAX_VALUE;
                                }
                                ++n82;
                                n81 += n80;
                                f9 += f;
                                f10 += f7;
                                f11 += f8;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex4.x = -2147483647;
                    }
                    ++n78;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                int n91 = j3DPrimitive.color;
                int n92 = n91 & 0xFF;
                int n93 = n91 >> 8 & 0xFF;
                int n94 = n91 >> 16 & 0xFF;
                short s = j3DPrimitive.alpha;
                int n95 = 0;
                while (n95 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n95 % 2 == 0 || this.mMin[n95].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n95];
                        J3DTLVertex j3DTLVertex5 = this.mMax[n95];
                        int n96 = j3DTLVertex5.x - j3DTLVertex.x;
                        if (n96 > 0) {
                            int n97 = (j3DTLVertex5.z - j3DTLVertex.z) / n96;
                            int n98 = j3DTLVertex.z;
                            int n99 = Math.abs(n97 * 2) + 500;
                            j3DTLVertex.x += n3;
                            j3DTLVertex5.x += n3;
                            int n100 = j3DTLVertex.x;
                            while (n100 < j3DTLVertex5.x) {
                                if (nArray[n100] > n98 - n99) {
                                    if (this.ss_shadecolor) {
                                        int n101 = nArray2[n100];
                                        int n102 = n101 >> 16 & 0xFF;
                                        int n103 = n101 >> 8 & 0xFF;
                                        int n104 = n101 & 0xFF;
                                        nArray2[n100] = ((n92 - n104) * s >> 7) + n104 | ((n93 - n103) * s >> 7) + n103 << 8 | ((n94 - n102) * s >> 7) + n102 << 16 | 0xFF000000;
                                    } else {
                                        nArray2[n100] = BGCOLOR;
                                    }
                                }
                                ++n100;
                                n98 += n97;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex5.x = -2147483647;
                    }
                    ++n95;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int n105 = j3DPrimitive.color;
                int n106 = 0;
                while (n106 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n106 % 2 == 0 || this.mMin[n106].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n106];
                        J3DTLVertex j3DTLVertex6 = this.mMax[n106];
                        int n107 = j3DTLVertex6.x - j3DTLVertex.x;
                        if (n107 > 0) {
                            int n108 = (j3DTLVertex6.z - j3DTLVertex.z) / n107;
                            int n109 = j3DTLVertex.z;
                            int n110 = Math.abs(n108 * 2) + 500;
                            j3DTLVertex.x += n3;
                            j3DTLVertex6.x += n3;
                            int n111 = j3DTLVertex.x;
                            while (n111 < j3DTLVertex6.x) {
                                if (nArray[n111] > n109 - n110) {
                                    if (this.ss_shadecolor) {
                                        int n112;
                                        int n113 = nArray2[n111];
                                        int n114 = n112 = (n105 & 0xFEFEFE) + (n113 & 0xFEFEFE);
                                        n114 &= 0x1010100;
                                        n114 -= n114 >> 8;
                                        nArray2[n111] = n114 | n112 | 0xFF000000;
                                    } else {
                                        nArray2[n111] = BGCOLOR;
                                    }
                                } else {
                                    int n115 = n111;
                                    nArray[n115] = nArray[n115] & Integer.MAX_VALUE;
                                }
                                ++n111;
                                n109 += n108;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex6.x = -2147483647;
                    }
                    ++n106;
                    n3 += this.BUFFERW;
                }
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                int n116 = 0;
                while (n116 < this.BUFFERH) {
                    if (!(this.ss_reductmode && n116 % 2 == 0 || this.mMin[n116].x == Integer.MAX_VALUE)) {
                        J3DTLVertex j3DTLVertex = this.mMin[n116];
                        J3DTLVertex j3DTLVertex7 = this.mMax[n116];
                        if (j3DTLVertex7.x - j3DTLVertex.x > 0) {
                            j3DTLVertex.x += n3;
                            j3DTLVertex7.x += n3;
                            int n117 = j3DTLVertex.x;
                            while (n117 < j3DTLVertex7.x) {
                                int n118 = n117++;
                                nArray[n118] = nArray[n118] | Integer.MIN_VALUE;
                            }
                        }
                        j3DTLVertex.x = Integer.MAX_VALUE;
                        j3DTLVertex7.x = -2147483647;
                    }
                    ++n116;
                    n3 += this.BUFFERW;
                }
                break;
            }
        }
    }

    private int getColor(int n, float f) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        float f2 = 0.8f + 0.3f * f;
        n2 = (int)((0.8 * (double)n2 + 0.2 * (double)f * 254.0) / (double)f2);
        n3 = (int)((0.8 * (double)n3 + 0.2 * (double)f * 254.0) / (double)f2);
        n4 = (int)((0.8 * (double)n4 + 0.2 * (double)f * 245.0) / (double)f2);
        return n2 << 16 | n3 << 8 | n4 | 0xFF000000;
    }

    private void scanEdge(J3DTLVertex j3DTLVertex, J3DTLVertex j3DTLVertex2, int n) {
        block18: {
            int n2;
            block14: {
                n2 = Math.abs((j3DTLVertex2.y >> 16) - (j3DTLVertex.y >> 16));
                if (n2 == 0) {
                    return;
                }
                if ((n & 1) == 0) break block14;
                int n3 = (j3DTLVertex2.x - j3DTLVertex.x) / n2;
                int n4 = (j3DTLVertex2.y - j3DTLVertex.y) / n2;
                float f = (j3DTLVertex2.u - j3DTLVertex.u) / (float)n2;
                float f2 = (j3DTLVertex2.v - j3DTLVertex.v) / (float)n2;
                float f3 = (j3DTLVertex2.w - j3DTLVertex.w) / (float)n2;
                int n5 = (j3DTLVertex2.r - j3DTLVertex.r) / n2;
                int n6 = (j3DTLVertex2.g - j3DTLVertex.g) / n2;
                int n7 = (j3DTLVertex2.b - j3DTLVertex.b) / n2;
                int n8 = j3DTLVertex.r;
                int n9 = j3DTLVertex.g;
                int n10 = j3DTLVertex.b;
                int n11 = (j3DTLVertex2.sr - j3DTLVertex.sr) / n2;
                int n12 = (j3DTLVertex2.sg - j3DTLVertex.sg) / n2;
                int n13 = (j3DTLVertex2.sb - j3DTLVertex.sb) / n2;
                int n14 = j3DTLVertex.sr;
                int n15 = j3DTLVertex.sg;
                int n16 = j3DTLVertex.sb;
                int n17 = j3DTLVertex.x;
                int n18 = j3DTLVertex.y;
                int n19 = j3DTLVertex.z;
                float f4 = j3DTLVertex.u;
                float f5 = j3DTLVertex.v;
                float f6 = j3DTLVertex.w;
                int n20 = 0;
                while (n20 <= n2) {
                    block16: {
                        int n21;
                        int n22;
                        int n23;
                        block17: {
                            block15: {
                                n23 = n18 >> 16;
                                n22 = n17 >> 16;
                                if (!this.ss_reductmode) break block15;
                                if (n23 % (this.ss_samplegrid * 2) != this.ss_samplegrid) break block16;
                                n22 /= this.ss_samplegrid;
                                break block17;
                            }
                            n21 = n23 % this.ss_samplegrid;
                            int n24 = this.ss_drawingstate / this.ss_samplegrid;
                            if (n21 != n24) break block16;
                            n21 = this.ss_drawingstate % this.ss_samplegrid;
                            n22 = (n22 - n21) / this.ss_samplegrid;
                        }
                        n21 = n23 / this.ss_samplegrid;
                        J3DTLVertex j3DTLVertex3 = this.mMin[n21];
                        J3DTLVertex j3DTLVertex4 = this.mMax[n21];
                        if (j3DTLVertex3.x > n22) {
                            j3DTLVertex3.x = n22;
                            j3DTLVertex3.z = n19 + (j3DTLVertex2.z - j3DTLVertex.z) * n20 / n2;
                            j3DTLVertex3.u = f4;
                            j3DTLVertex3.v = f5;
                            j3DTLVertex3.w = f6;
                            j3DTLVertex3.r = n8;
                            j3DTLVertex3.g = n9;
                            j3DTLVertex3.b = n10;
                            j3DTLVertex3.sr = n14;
                            j3DTLVertex3.sg = n15;
                            j3DTLVertex3.sb = n16;
                            j3DTLVertex3.edge = j3DTLVertex.edge;
                        }
                        if (j3DTLVertex4.x < n22) {
                            j3DTLVertex4.x = n22;
                            j3DTLVertex4.z = n19 + (j3DTLVertex2.z - j3DTLVertex.z) * n20 / n2;
                            j3DTLVertex4.u = f4;
                            j3DTLVertex4.v = f5;
                            j3DTLVertex4.w = f6;
                            j3DTLVertex4.r = n8;
                            j3DTLVertex4.g = n9;
                            j3DTLVertex4.b = n10;
                            j3DTLVertex4.sr = n14;
                            j3DTLVertex4.sg = n15;
                            j3DTLVertex4.sb = n16;
                            j3DTLVertex4.edge = j3DTLVertex.edge;
                        }
                    }
                    ++n20;
                    n17 += n3;
                    n18 += n4;
                    f4 += f;
                    f5 += f2;
                    f6 += f3;
                    n14 += n11;
                    n15 += n12;
                    n16 += n13;
                    n8 += n5;
                    n9 += n6;
                    n10 += n7;
                }
                break block18;
            }
            int n25 = (j3DTLVertex2.x - j3DTLVertex.x) / n2;
            int n26 = (j3DTLVertex2.y - j3DTLVertex.y) / n2;
            int n27 = j3DTLVertex.x;
            int n28 = j3DTLVertex.y;
            int n29 = j3DTLVertex.z;
            int n30 = (j3DTLVertex2.r - j3DTLVertex.r) / n2;
            int n31 = (j3DTLVertex2.g - j3DTLVertex.g) / n2;
            int n32 = (j3DTLVertex2.b - j3DTLVertex.b) / n2;
            int n33 = j3DTLVertex.r;
            int n34 = j3DTLVertex.g;
            int n35 = j3DTLVertex.b;
            int n36 = (j3DTLVertex2.sr - j3DTLVertex.sr) / n2;
            int n37 = (j3DTLVertex2.sg - j3DTLVertex.sg) / n2;
            int n38 = (j3DTLVertex2.sb - j3DTLVertex.sb) / n2;
            int n39 = j3DTLVertex.sr;
            int n40 = j3DTLVertex.sg;
            int n41 = j3DTLVertex.sb;
            int n42 = 0;
            while (n42 <= n2) {
                block20: {
                    int n43;
                    int n44;
                    int n45;
                    block21: {
                        block19: {
                            n45 = n28 >> 16;
                            n44 = n27 >> 16;
                            if (!this.ss_reductmode) break block19;
                            if (n45 % (this.ss_samplegrid * 2) != this.ss_samplegrid) break block20;
                            n44 /= this.ss_samplegrid;
                            break block21;
                        }
                        n43 = n45 % this.ss_samplegrid;
                        int n46 = this.ss_drawingstate / this.ss_samplegrid;
                        if (n43 != n46) break block20;
                        n43 = this.ss_drawingstate % this.ss_samplegrid;
                        n44 = (n44 - n43) / this.ss_samplegrid;
                    }
                    n43 = n45 / this.ss_samplegrid;
                    if (this.mMin.length <= n43) {
                        System.out.println(String.valueOf(this.mMin.length) + " < " + n43);
                    }
                    J3DTLVertex j3DTLVertex5 = this.mMin[n43];
                    J3DTLVertex j3DTLVertex6 = this.mMax[n43];
                    if (j3DTLVertex5.x > n44) {
                        j3DTLVertex5.x = n44;
                        j3DTLVertex5.z = n29 + (j3DTLVertex2.z - j3DTLVertex.z) * n42 / n2;
                        j3DTLVertex5.r = n33;
                        j3DTLVertex5.g = n34;
                        j3DTLVertex5.b = n35;
                        j3DTLVertex5.sr = n39;
                        j3DTLVertex5.sg = n40;
                        j3DTLVertex5.sb = n41;
                        j3DTLVertex5.edge = j3DTLVertex.edge;
                    }
                    if (j3DTLVertex6.x < n44) {
                        j3DTLVertex6.x = n44;
                        j3DTLVertex6.z = n29 + (j3DTLVertex2.z - j3DTLVertex.z) * n42 / n2;
                        j3DTLVertex6.r = n33;
                        j3DTLVertex6.g = n34;
                        j3DTLVertex6.b = n35;
                        j3DTLVertex6.sr = n39;
                        j3DTLVertex6.sg = n40;
                        j3DTLVertex6.sb = n41;
                        j3DTLVertex6.edge = j3DTLVertex.edge;
                    }
                }
                ++n42;
                n27 += n25;
                n28 += n26;
                n39 += n36;
                n40 += n37;
                n41 += n38;
                n33 += n30;
                n34 += n31;
                n35 += n32;
            }
        }
    }

    public void setDrawLine(boolean bl) {
        this.ss_reductline = bl;
    }

    public boolean isDrawLine() {
        return this.ss_reductline;
    }

    private void drawWire(J3DPrimitive j3DPrimitive, J3DTLVertex[] j3DTLVertexArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            J3DTLVertex j3DTLVertex = j3DTLVertexArray[n2];
            int n3 = n2 == n - 1 ? 0 : n2 + 1;
            J3DTLVertex j3DTLVertex2 = j3DTLVertexArray[n3];
            if (j3DTLVertex.edge) {
                this.drawLine(j3DTLVertex, j3DTLVertex2, LINE_COLOR);
            }
            ++n2;
        }
    }

    private void drawLine(J3DTLVertex j3DTLVertex, J3DTLVertex j3DTLVertex2, int n) {
        int n2;
        int[] nArray = this.ss_current;
        int n3 = Math.abs((j3DTLVertex2.x >> 16) - (j3DTLVertex.x >> 16));
        if (n3 < (n2 = Math.abs((j3DTLVertex2.y >> 16) - (j3DTLVertex.y >> 16)))) {
            if (n2 == 0) {
                ++n2;
            }
            int n4 = (j3DTLVertex2.x - j3DTLVertex.x) / n2;
            int n5 = j3DTLVertex2.y - j3DTLVertex.y >> 31 | 1;
            int n6 = j3DTLVertex.x;
            int n7 = j3DTLVertex.y >> 16;
            int n8 = 0;
            while (n8 < n2) {
                int n9 = n6 >> 16;
                int n10 = n7 / this.ss_samplegrid;
                int n11 = this.ss_drawingstate / this.ss_samplegrid;
                int n12 = n7 % this.ss_samplegrid;
                if (n11 == n12) {
                    n12 = this.ss_drawingstate % this.ss_samplegrid;
                    int n13 = (n9 - n12) / this.ss_samplegrid;
                    int n14 = n10 * this.BUFFERW + n13;
                    float f = (float)j3DTLVertex.z + (float)((j3DTLVertex2.z - j3DTLVertex.z) * n8) / (float)n2;
                    int n15 = (int)f;
                    boolean bl = false;
                    if (n15 <= this.ss_zbuffer[n14] + 10) {
                        bl = true;
                    }
                    if (bl) {
                        nArray[n14] = this.getBlend(this.ss_current[n14], n);
                    }
                }
                ++n8;
                n6 += n4;
                n7 += n5;
            }
        } else {
            if (n3 == 0) {
                ++n3;
            }
            int n16 = (j3DTLVertex2.y - j3DTLVertex.y) / n3;
            int n17 = j3DTLVertex2.x - j3DTLVertex.x >> 31 | 1;
            int n18 = j3DTLVertex.x >> 16;
            int n19 = j3DTLVertex.y;
            int n20 = 0;
            while (n20 < n3) {
                int n21 = n19 >> 16;
                int n22 = n21 / this.ss_samplegrid;
                int n23 = this.ss_drawingstate / this.ss_samplegrid;
                int n24 = n19 % this.ss_samplegrid;
                if (n23 == n24) {
                    n24 = this.ss_drawingstate % this.ss_samplegrid;
                    int n25 = (n18 - n24) / this.ss_samplegrid;
                    int n26 = n22 * this.BUFFERW + n25;
                    float f = (float)j3DTLVertex.z + (float)((j3DTLVertex2.z - j3DTLVertex.z) * n20) / (float)n3;
                    int n27 = (int)f;
                    boolean bl = false;
                    if (n27 <= this.ss_zbuffer[n26] + 10) {
                        bl = true;
                    }
                    if (bl) {
                        nArray[n26] = this.getBlend(this.ss_current[n26], n);
                    }
                }
                ++n20;
                n18 += n17;
                n19 += n16;
            }
        }
    }

    private void drawWireFrame(Vector vector) {
        this.mLineMode = true;
        this.mMaster.initialize();
        this.mMaster.mult(this.mView);
        this.mMaster.mult(this.mProj);
        int n = 0;
        while (n < vector.size()) {
            J3DObject j3DObject = (J3DObject)vector.elementAt(n);
            Vector vector2 = j3DObject.getPrimitives();
            int n2 = 0;
            while (n2 < vector2.size()) {
                J3DPrimitive j3DPrimitive = (J3DPrimitive)vector2.elementAt(n2);
                this.drawPrimitive(j3DPrimitive, 0.0f, 0.0f, 0.0f);
                ++n2;
            }
            ++n;
        }
        this.checkZ(this.ss_current);
    }

    private void checkZ(int[] nArray) {
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < this.ss_zbuffer.length) {
            int n4 = this.ss_zbuffer[n3];
            if (n4 != Integer.MAX_VALUE) {
                if (n4 < n2) {
                    n2 = n4;
                }
                if (n < n4) {
                    n = n4;
                }
            }
            ++n3;
        }
        double d = n - n2;
        int n5 = 1;
        while (n5 < this.BUFFERH - 1) {
            int n6 = 1;
            while (n6 < this.BUFFERW - 1) {
                int n7 = n5 * this.BUFFERW + n6;
                int n8 = this.ss_zbuffer[n7];
                double d2 = (double)(n8 - this.ss_zbuffer[n7 - 1]) / d;
                double d3 = (double)(this.ss_zbuffer[n7 + 1] - n8) / d;
                double d4 = (double)(n8 - this.ss_zbuffer[n7 - this.BUFFERW]) / d;
                double d5 = (double)(this.ss_zbuffer[n7 + this.BUFFERW] - n8) / d;
                double d6 = 0.02;
                if (Math.abs(d2 - d3) > d6) {
                    if (nArray[n7] == BGCOLOR) {
                        nArray[n7] = this.getBlend(nArray[n7], LINE_COLOR);
                    }
                } else if (Math.abs(d4 - d5) > d6 && nArray[n7] == BGCOLOR) {
                    nArray[n7] = this.getBlend(nArray[n7], LINE_COLOR);
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void setDrawEdge(boolean bl) {
        this.ss_drawedge = bl;
    }

    public boolean isDrawEdge() {
        return this.ss_drawedge;
    }

    public void setShadeColor(boolean bl) {
        this.ss_shadecolor = bl;
        if (!this.ss_shadecolor) {
            this.ss_drawedge = true;
        }
    }

    public boolean isShadeColor() {
        return this.ss_shadecolor;
    }

    public void updateObjects(int n, int n2, boolean bl) {
        Vector vector = new Vector();
        int n3 = 0;
        while (n3 < this.mSObjects.size()) {
            vector.addElement(this.mSObjects.elementAt(n3));
            ++n3;
        }
        n3 = 0;
        while (n3 < this.mDObjects.size()) {
            vector.addElement(this.mDObjects.elementAt(n3));
            ++n3;
        }
        n3 = 0;
        while (n3 < this.mXObjects.size()) {
            vector.addElement(this.mXObjects.elementAt(n3));
            ++n3;
        }
        this.mXObjects.removeAllElements();
        this.mSObjects.removeAllElements();
        this.mDObjects.removeAllElements();
        n3 = 0;
        while (n3 < vector.size()) {
            J3DObject j3DObject = (J3DObject)vector.elementAt(n3);
            j3DObject.changeColor(n, n2, bl);
            this.addObject(j3DObject);
            ++n3;
        }
    }

    public void ss_draw(int n, int n2, int[] nArray, int n3, ImageUpdater imageUpdater) {
        this.ss_draw = true;
        this.resize(n, n2);
        this.ss_rgb = nArray;
        if (this.ss_reductmode) {
            this.ss_drawReduct(imageUpdater);
        } else {
            this.ss_drawFull(imageUpdater);
        }
        this.ss_rgb = null;
        this.ss_draw = false;
    }

    public void ss_drawReduct(ImageUpdater imageUpdater) {
        this.ss_drawingstate = 0;
        this.ss_draw();
        this.ss_interpolate();
        this.ss_add(0, 0);
    }

    public void ss_interpolate() {
        int n = 2;
        while (n < this.BUFFERH - 2) {
            int n2 = 0;
            while (n2 < this.BUFFERW) {
                this.ss_current[n * this.BUFFERW + n2] = this.getBlend(this.ss_current[(n - 1) * this.BUFFERW + n2], this.ss_current[(n + 1) * this.BUFFERW + n2]);
                ++n2;
            }
            n += 2;
        }
    }

    public void ss_drawFull(ImageUpdater imageUpdater) {
        int n = this.ss_samplegrid * this.ss_samplegrid;
        int n2 = 0;
        while (n2 < n) {
            this.ss_drawEach(n2);
            this.ss_add(n2, n);
            if (imageUpdater != null && n2 != n - 1) {
                imageUpdater.updateImage();
            }
            ++n2;
        }
    }

    public void ss_drawEach(int n) {
        this.ss_drawingstate = n;
        this.ss_draw();
    }

    public void ss_draw() {
        if ((this.mRenderState & 8) != 0 || this.ss_reductline) {
            // empty if block
        }
        if ((this.mRenderState & 0x100) > 0 && this.mCameraPos.compare(this.mBCameraPos) && this.mCameraTarget.compare(this.mBCameraTarget)) {
            int n = 0;
            while (n < this.BUFFERW * this.BUFFERH) {
                this.ss_current[n] = BGCOLOR;
                this.ss_zbuffer[n] = Integer.MAX_VALUE;
                ++n;
            }
            this.drawObjects(this.mSObjects);
            this.drawObjects(this.mDObjects);
            this.drawObjects(this.mXObjects);
            if (this.ss_drawedge) {
                this.drawWireFrame(this.mSObjects);
                this.drawWireFrame(this.mDObjects);
                this.drawWireFrame(this.mXObjects);
            }
            this.drawAlphaPrimitives();
        } else {
            int n = 0;
            while (n < this.BUFFERW * this.BUFFERH) {
                this.ss_current[n] = BGCOLOR;
                this.ss_zbuffer[n] = Integer.MAX_VALUE;
                ++n;
            }
            this.drawObjects(this.mSObjects);
            this.drawObjects(this.mDObjects);
            this.drawObjects(this.mXObjects);
            if (this.ss_drawedge) {
                this.drawWireFrame(this.mSObjects);
                this.drawWireFrame(this.mDObjects);
                this.drawWireFrame(this.mXObjects);
            }
            this.drawAlphaPrimitives();
            this.mBCameraPos.initialize(this.mCameraPos);
            this.mBCameraTarget.initialize(this.mCameraTarget);
        }
    }

    public void ss_add(int n, int n2) {
        if (n == 0) {
            int n3 = 0;
            while (n3 < this.ss_rgb.length) {
                this.ss_rgb[n3] = this.ss_current[n3];
                ++n3;
            }
            return;
        }
        int n4 = 0;
        while (n4 < this.ss_rgb.length) {
            int n5 = this.ss_current[n4];
            int n6 = n5 >> 16 & 0xFF;
            int n7 = n5 >> 8 & 0xFF;
            int n8 = n5 & 0xFF;
            int n9 = this.ss_rgb[n4];
            int n10 = n9 >> 16 & 0xFF;
            int n11 = n9 >> 8 & 0xFF;
            int n12 = n9 & 0xFF;
            n10 = (this.ss_drawingstate * n10 + n6) / (this.ss_drawingstate + 1);
            n11 = (this.ss_drawingstate * n11 + n7) / (this.ss_drawingstate + 1);
            n12 = (this.ss_drawingstate * n12 + n8) / (this.ss_drawingstate + 1);
            if (n10 > 255) {
                n10 = 255;
            }
            if (n11 > 255) {
                n11 = 255;
            }
            if (n12 > 255) {
                n12 = 255;
            }
            this.ss_rgb[n4] = 0xFF000000 | n10 << 16 | n11 << 8 | n12;
            ++n4;
        }
    }

    private void ss_drawPolygon(int[] nArray, int[] nArray2, Color color, int n) {
    }
}

