/*
 * Decompiled with CFR 0.152.
 */
package option.threed;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JPanel;
import option.threed.IScreen3D;

public class ProtoPanel3D
extends JPanel
implements MouseMotionListener,
MouseListener,
KeyListener,
MouseWheelListener {
    private static final int DEF_WIDTH = 280;
    private static final int DEF_HEIGHT = 210;
    private int width;
    private int height;
    private BufferedImage image;
    private int[] rgb;
    private IScreen3D screen = null;

    public ProtoPanel3D() {
        this(280, 210);
    }

    public ProtoPanel3D(int n, int n2) {
        this.setBackground(Color.WHITE);
        this.width = n;
        this.height = n2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                ProtoPanel3D.this.sizeChanged();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void add3DUI(IScreen3D iScreen3D) {
        this.screen = iScreen3D;
        if (this.screen != null) {
            this.getRGB();
            this.screen.updateBuffer(this.rgb, this.width, this.height);
        }
    }

    public void remove3DUI(IScreen3D iScreen3D) {
        this.screen = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    private void sizeChanged() {
        if (!this.isShowing()) {
            return;
        }
        this.checkImage();
    }

    public void paint(Graphics graphics) {
        if (this.checkImage() && this.screen == null) {
            return;
        }
        graphics.drawImage(this.image, 0, 0, null);
    }

    private boolean checkImage() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        this.width = dimension.width;
        this.height = dimension.height;
        boolean bl = false;
        if (this.image == null) {
            bl = true;
        } else if (this.image.getWidth() != this.width || this.image.getHeight() != this.height) {
            bl = true;
        }
        if (bl) {
            this.image = new BufferedImage(this.width, this.height, 1);
            this.rgb = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            if (this.rgb != null && this.screen == null) {
                int n = 0;
                while (n < this.rgb.length) {
                    this.rgb[n] = -1;
                    ++n;
                }
            }
            if (this.screen != null) {
                this.screen.updateBuffer(this.rgb, this.width, this.height);
            }
        }
        return bl;
    }

    public int[] getRGB() {
        if (this.rgb == null) {
            this.checkImage();
        }
        return this.rgb;
    }

    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.update(graphics);
        }
    }

    public void repaintTemporary() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.screen != null) {
            this.screen.mouseDragged(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.screen != null) {
            this.screen.mouseMoved(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.screen != null) {
            this.screen.mouseReleased(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.screen != null) {
            this.screen.mouseEntered(mouseEvent.getX(), mouseEvent.getY());
        }
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.screen != null) {
            this.screen.mouseExited(mouseEvent.getX(), mouseEvent.getY());
        }
        this.transferFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.screen != null) {
            this.screen.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.screen != null) {
            this.screen.keyReleased(keyEvent.getKeyCode());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.screen != null) {
            int n = mouseWheelEvent.getWheelRotation();
            this.screen.mouseWheelMoved(n);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.requestFocus();
        } else {
            this.transferFocus();
        }
    }
}

