/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    protected final Class<? extends Annotation> supportedAnnotationType;
    protected Context ctx;

    protected AbstractProcessor(Class<? extends Annotation> supportedAnnotationType) {
        this.supportedAnnotationType = supportedAnnotationType;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.ctx = new Context(processingEnv);
        this.ctx.init();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected void handleTypeElement(TypeElement element, Consumer<TypeElement> handler) {
        this.handleElement(element, handler, () -> element.getQualifiedName().toString());
    }

    protected void handleExecutableElement(ExecutableElement element, Consumer<ExecutableElement> handler) {
        this.handleElement(element, handler, () -> {
            Element owner = element.getEnclosingElement();
            return owner + "#" + element.getSimpleName();
        });
    }

    private <E extends Element> void handleElement(E element, Consumer<E> handler, Supplier<String> elementNameSupplier) {
        Annotation annotation = element.getAnnotation(this.supportedAnnotationType);
        if (annotation == null) {
            return;
        }
        if (this.ctx.getOptions().isDebugEnabled()) {
            this.ctx.getReporter().debug((MessageResource)Message.DOMA4090, new Object[]{this.getClass().getName(), elementNameSupplier.get()});
        }
        try {
            handler.accept(element);
        }
        catch (AptException e) {
            this.ctx.getReporter().report(e);
        }
        catch (AptIllegalOptionException e) {
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, e.getMessage(), element);
            throw e;
        }
        catch (AptIllegalStateException e) {
            String stackTrace = this.getStackTraceAsString(e);
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4039, element, new Object[]{stackTrace});
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            String stackTrace = this.getStackTraceAsString((Throwable)e);
            this.ctx.getReporter().report(Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4016, element, new Object[]{stackTrace});
            throw e;
        }
        if (this.ctx.getOptions().isDebugEnabled()) {
            this.ctx.getReporter().debug((MessageResource)Message.DOMA4091, new Object[]{this.getClass().getName(), elementNameSupplier.get()});
        }
    }

    private String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return ((Object)stringWriter).toString();
    }
}

