/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.util.AssertionUtil;

public abstract class AbstractCtType
implements CtType {
    protected final Context ctx;
    protected final TypeMirror type;
    protected final TypeElement typeElement;
    private final String qualifiedName;
    protected final String simpleName;

    protected AbstractCtType(Context ctx, TypeMirror type) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)type);
        this.ctx = ctx;
        this.type = type;
        this.typeElement = ctx.getMoreTypes().toTypeElement(type);
        if (this.typeElement != null) {
            this.qualifiedName = this.typeElement.getQualifiedName().toString();
            this.simpleName = this.typeElement.getSimpleName().toString();
        } else {
            this.simpleName = this.qualifiedName = ctx.getMoreTypes().getTypeName(type);
        }
    }

    @Override
    public TypeMirror getType() {
        return this.type;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public boolean isEnum() {
        return this.typeElement != null && this.typeElement.getKind() == ElementKind.ENUM;
    }

    @Override
    public boolean isPrimitive() {
        return this.type.getKind().isPrimitive();
    }

    @Override
    public boolean isNone() {
        return this.type.getKind() == TypeKind.NONE;
    }

    @Override
    public boolean isWildcard() {
        return this.type.getKind() == TypeKind.WILDCARD;
    }

    @Override
    public boolean isArray() {
        return this.type.getKind() == TypeKind.ARRAY;
    }

    @Override
    public boolean isTypevar() {
        return this.type.getKind() == TypeKind.TYPEVAR;
    }

    @Override
    public boolean isSameType(CtType other) {
        return this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, other.getType());
    }

    @Override
    public boolean hasTypeParameter() {
        return this.typeElement != null && !this.typeElement.getTypeParameters().isEmpty();
    }
}

