/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class SequenceGeneratorAnnot
extends AbstractAnnot {
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String SEQUENCE = "sequence";
    private static final String INITIAL_VALUE = "initialValue";
    private static final String ALLOCATION_SIZE = "allocationSize";
    private static final String IMPLEMENTER = "implementer";
    private final AnnotationValue catalog;
    private final AnnotationValue schema;
    private final AnnotationValue sequence;
    private final AnnotationValue initialValue;
    private final AnnotationValue allocationSize;
    private final AnnotationValue implementer;

    SequenceGeneratorAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.catalog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)CATALOG);
        this.schema = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SCHEMA);
        this.sequence = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SEQUENCE);
        this.initialValue = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)INITIAL_VALUE);
        this.allocationSize = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)ALLOCATION_SIZE);
        this.implementer = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)IMPLEMENTER);
    }

    public AnnotationValue getCatalog() {
        return this.catalog;
    }

    public AnnotationValue getSchema() {
        return this.schema;
    }

    public AnnotationValue getSequence() {
        return this.sequence;
    }

    public AnnotationValue getInitialValue() {
        return this.initialValue;
    }

    public AnnotationValue getAllocationSize() {
        return this.allocationSize;
    }

    public AnnotationValue getImplementer() {
        return this.implementer;
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException(CATALOG);
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException(SCHEMA);
        }
        return value;
    }

    public String getSequenceValue() {
        String value = AnnotationValueUtil.toString(this.sequence);
        if (value == null) {
            throw new AptIllegalStateException(SEQUENCE);
        }
        return value;
    }

    public Long getInitialValueValue() {
        Long value = AnnotationValueUtil.toLong(this.initialValue);
        if (value == null) {
            throw new AptIllegalStateException(INITIAL_VALUE);
        }
        return value;
    }

    public Long getAllocationSizeValue() {
        Long value = AnnotationValueUtil.toLong(this.allocationSize);
        if (value == null) {
            throw new AptIllegalStateException(ALLOCATION_SIZE);
        }
        return value;
    }

    public TypeMirror getImplementerValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.implementer);
        if (value == null) {
            throw new AptIllegalStateException(IMPLEMENTER);
        }
        return value;
    }
}

