/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DomainConvertersAnnot
extends AbstractAnnot {
    private static final String VALUE = "value";
    private final AnnotationValue value;

    DomainConvertersAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.value = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)VALUE);
    }

    public AnnotationValue getValue() {
        return this.value;
    }

    public List<TypeMirror> getValueValue() {
        List<TypeMirror> typeList = AnnotationValueUtil.toTypeList(this.value);
        if (typeList == null) {
            throw new AptIllegalStateException(VALUE);
        }
        return typeList;
    }
}

