/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.AccessLevel;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DaoAnnot
extends AbstractAnnot {
    private static final String CONFIG = "config";
    private static final String ACCESS_LEVEL = "accessLevel";
    private final AnnotationValue config;
    private final AnnotationValue accessLevel;
    private final boolean hasUserDefinedConfig;

    DaoAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.config = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)CONFIG);
        this.accessLevel = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)ACCESS_LEVEL);
        this.hasUserDefinedConfig = annotationMirror.getElementValues().keySet().stream().anyMatch(e -> e.getSimpleName().contentEquals(CONFIG));
    }

    public AnnotationValue getConfig() {
        return this.config;
    }

    public AnnotationValue getAccessLevel() {
        return this.accessLevel;
    }

    public TypeMirror getConfigValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.config);
        if (value == null) {
            throw new AptIllegalStateException(CONFIG);
        }
        return value;
    }

    public AccessLevel getAccessLevelValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.accessLevel);
        if (enumConstant == null) {
            throw new AptIllegalStateException(ACCESS_LEVEL);
        }
        return AccessLevel.valueOf((String)enumConstant.getSimpleName().toString());
    }

    public boolean hasUserDefinedConfig() {
        return this.hasUserDefinedConfig;
    }
}

