/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.sql.Statement;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.InsertQuery;
import org.seasar.doma.jdbc.query.SqlFileModifyQuery;

public class SqlFileInsertQuery
extends SqlFileModifyQuery
implements InsertQuery {
    protected boolean nullExcluded;
    protected EntityHandler<?> entityHandler;

    public SqlFileInsertQuery() {
        super(SqlKind.INSERT);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.sqlFilePath);
        this.preInsert();
        this.prepareOptions();
        this.prepareExecutable();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preInsert() {
        if (this.entityHandler != null) {
            this.entityHandler.preInsert();
        }
    }

    protected void prepareExecutable() {
        this.executable = true;
        this.sqlExecutionSkipCause = null;
    }

    @Override
    public void generateId(Statement statement) {
    }

    public <E> E getEntity(Class<E> entityType) {
        if (this.entityHandler != null) {
            return this.entityHandler.entity;
        }
        return null;
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postInsert();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(String name, E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(name, entity, entityType);
    }

    public void setNullExcluded(boolean nullExcluded) {
        this.nullExcluded = nullExcluded;
    }

    protected static class SqlFilePostInsertContext<E>
    extends AbstractPostInsertContext<E> {
        public SqlFilePostInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class SqlFilePreInsertContext<E>
    extends AbstractPreInsertContext<E> {
        public SqlFilePreInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected class EntityHandler<E> {
        protected final String name;
        protected E entity;
        protected final EntityType<E> entityType;

        protected EntityHandler(String name, E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull((Object)name, entity, entityType);
            this.name = name;
            this.entity = entity;
            this.entityType = entityType;
        }

        protected void preInsert() {
            SqlFilePreInsertContext<E> context = new SqlFilePreInsertContext<E>(this.entityType, SqlFileInsertQuery.this.method, SqlFileInsertQuery.this.config);
            this.entityType.preInsert(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
                SqlFileInsertQuery.this.addParameterInternal(this.name, this.entityType.getEntityClass(), this.entity);
            }
        }

        protected void postInsert() {
            SqlFilePostInsertContext<E> context = new SqlFilePostInsertContext<E>(this.entityType, SqlFileInsertQuery.this.method, SqlFileInsertQuery.this.config);
            this.entityType.postInsert(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
            }
        }
    }
}

