/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.command.MappedResultStreamHandler;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.declaration.OrderByIndexDeclaration;
import org.seasar.doma.jdbc.criteria.statement.AbstractSetOperand;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlSetTerminal;
import org.seasar.doma.jdbc.criteria.statement.SetOperand;
import org.seasar.doma.jdbc.criteria.statement.SetOperator;
import org.seasar.doma.jdbc.query.SelectQuery;

public class NativeSqlSetStarting<ELEMENT>
extends AbstractSetOperand<NativeSqlSetStarting<ELEMENT>, ELEMENT>
implements SetOperator<ELEMENT> {
    private final SetOperationContext<ELEMENT> context;

    public NativeSqlSetStarting(Config config, SetOperationContext<ELEMENT> context, Function<SelectQuery, ObjectProvider<ELEMENT>> objectProviderFactory) {
        super(Objects.requireNonNull(config), Objects.requireNonNull(objectProviderFactory));
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public SetOperand<ELEMENT> orderBy(Consumer<OrderByIndexDeclaration> block) {
        Objects.requireNonNull(block);
        OrderByIndexDeclaration declaration = new OrderByIndexDeclaration(this.context);
        block.accept(declaration);
        return this;
    }

    @Override
    public SetOperationContext<ELEMENT> getContext() {
        return this.context;
    }

    @Override
    public <RESULT> RESULT mapStream(Function<Stream<ELEMENT>, RESULT> streamMapper) {
        Objects.requireNonNull(streamMapper);
        NativeSqlSetTerminal<RESULT> terminal = this.createNativeSqlSetTerminal(streamMapper);
        return terminal.execute();
    }

    @Override
    protected Command<List<ELEMENT>> createCommand() {
        NativeSqlSetTerminal<List> terminal = this.createNativeSqlSetTerminal(stream -> stream.collect(Collectors.toList()));
        return terminal.createCommand();
    }

    private <RESULT> NativeSqlSetTerminal<RESULT> createNativeSqlSetTerminal(Function<Stream<ELEMENT>, RESULT> streamMapper) {
        MappedResultStreamHandler<ELEMENT, RESULT> handler = new MappedResultStreamHandler<ELEMENT, RESULT>(streamMapper, this.objectProviderFactory);
        return new NativeSqlSetTerminal(this.config, this.context, handler);
    }
}

