/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.DeleteCommand;
import org.seasar.doma.jdbc.criteria.context.DeleteContext;
import org.seasar.doma.jdbc.criteria.context.DeleteSettings;
import org.seasar.doma.jdbc.criteria.declaration.DeleteDeclaration;
import org.seasar.doma.jdbc.criteria.query.CriteriaQuery;
import org.seasar.doma.jdbc.criteria.query.DeleteBuilder;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EmptyWhereClauseException;

public class NativeSqlDeleteTerminal
extends AbstractStatement<NativeSqlDeleteTerminal, Integer> {
    private final DeleteDeclaration declaration;

    public NativeSqlDeleteTerminal(Config config, DeleteDeclaration declaration) {
        super(Objects.requireNonNull(config));
        Objects.requireNonNull(declaration);
        this.declaration = declaration;
    }

    @Override
    public Integer execute() {
        return (Integer)super.execute();
    }

    @Override
    protected Command<Integer> createCommand() {
        final DeleteContext context = this.declaration.getContext();
        final DeleteSettings settings = context.getSettings();
        DeleteBuilder builder = new DeleteBuilder(this.config, context, this.createCommenter(settings.getComment()), settings.getSqlLogType());
        PreparedSql sql = builder.build();
        CriteriaQuery query = new CriteriaQuery(this.config, sql, this.getClass().getName(), "execute");
        query.setQueryTimeout(settings.getQueryTimeout());
        return new DeleteCommand(query){

            @Override
            public Integer execute() {
                if (!settings.getAllowEmptyWhere() && context.where.isEmpty()) {
                    throw new EmptyWhereClauseException(this.sql);
                }
                return super.execute();
            }
        };
    }
}

