/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.expression;

import java.util.Objects;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public interface StringExpression<PROPERTY>
extends PropertyMetamodel<PROPERTY> {

    public static interface Visitor {
        public void visit(Concat<?> var1);

        public void visit(Lower<?> var1);

        public void visit(Ltrim<?> var1);

        public void visit(Rtrim<?> var1);

        public void visit(Trim<?> var1);

        public void visit(Upper<?> var1);
    }

    public static class Upper<PROPERTY>
    extends OneArgumentStringExpression<PROPERTY> {
        public Upper(PropertyMetamodel<?> propertyMetamodel) {
            super("upper", propertyMetamodel);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Trim<PROPERTY>
    extends OneArgumentStringExpression<PROPERTY> {
        public Trim(PropertyMetamodel<?> propertyMetamodel) {
            super("trim", propertyMetamodel);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Rtrim<PROPERTY>
    extends OneArgumentStringExpression<PROPERTY> {
        public Rtrim(PropertyMetamodel<?> propertyMetamodel) {
            super("rtrim", propertyMetamodel);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Ltrim<PROPERTY>
    extends OneArgumentStringExpression<PROPERTY> {
        public Ltrim(PropertyMetamodel<?> propertyMetamodel) {
            super("ltrim", propertyMetamodel);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Lower<PROPERTY>
    extends OneArgumentStringExpression<PROPERTY> {
        public Lower(PropertyMetamodel<?> propertyMetamodel) {
            super("lower", propertyMetamodel);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Concat<PROPERTY>
    extends TwoArgumentsStringExpression<PROPERTY> {
        public Concat(PropertyMetamodel<?> propertyMetamodel, Operand left, Operand right) {
            super("concat", propertyMetamodel, left, right);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static abstract class TwoArgumentsStringExpression<PROPERTY>
    implements StringExpression<PROPERTY> {
        private final String name;
        private final PropertyMetamodel<?> propertyMetamodel;
        public final Operand first;
        public final Operand second;

        protected TwoArgumentsStringExpression(String name, PropertyMetamodel<?> propertyMetamodel, Operand first, Operand second) {
            this.name = Objects.requireNonNull(name);
            this.propertyMetamodel = Objects.requireNonNull(propertyMetamodel);
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> asClass() {
            return this.propertyMetamodel.asClass();
        }

        @Override
        public EntityPropertyType<?, ?> asType() {
            return this.propertyMetamodel.asType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TwoArgumentsStringExpression)) {
                return false;
            }
            TwoArgumentsStringExpression that = (TwoArgumentsStringExpression)o;
            return this.propertyMetamodel.equals(that.propertyMetamodel) && this.first.equals(that.first) && this.second.equals(that.second);
        }

        public int hashCode() {
            return Objects.hash(this.propertyMetamodel, this.first, this.second);
        }
    }

    public static abstract class OneArgumentStringExpression<PROPERTY>
    implements StringExpression<PROPERTY> {
        private final String name;
        public final PropertyMetamodel<?> argument;

        protected OneArgumentStringExpression(String name, PropertyMetamodel<?> argument) {
            this.name = Objects.requireNonNull(name);
            this.argument = Objects.requireNonNull(argument);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> asClass() {
            return this.argument.asClass();
        }

        @Override
        public EntityPropertyType<?, ?> asType() {
            return this.argument.asType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OneArgumentStringExpression)) {
                return false;
            }
            OneArgumentStringExpression that = (OneArgumentStringExpression)o;
            return this.argument.equals(that.argument);
        }

        public int hashCode() {
            return Objects.hash(this.argument);
        }
    }
}

