/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.expression;

import java.util.Objects;
import java.util.function.Function;
import org.seasar.doma.jdbc.criteria.expression.BasicPropertyType;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public class LiteralExpression<PROPERTY>
implements PropertyMetamodel<PROPERTY> {
    private final PROPERTY value;
    private final BasicPropertyType<PROPERTY> propertyType;

    public LiteralExpression(PROPERTY value, Function<PROPERTY, BasicPropertyType<PROPERTY>> factory) {
        this.value = Objects.requireNonNull(value);
        Objects.requireNonNull(factory);
        this.propertyType = factory.apply(value);
    }

    @Override
    public EntityPropertyType<?, ?> asType() {
        return this.propertyType;
    }

    @Override
    public Class<?> asClass() {
        return this.value.getClass();
    }

    @Override
    public String getName() {
        return this.value.toString();
    }

    @Override
    public void accept(PropertyMetamodel.Visitor visitor) {
        if (visitor instanceof Visitor) {
            Visitor v = (Visitor)((Object)visitor);
            v.visit(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralExpression that = (LiteralExpression)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static interface Visitor {
        public void visit(LiteralExpression<?> var1);
    }
}

