/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.criteria.context.OrderByItem;
import org.seasar.doma.jdbc.criteria.context.SelectContext;

public interface SetOperationContext<ELEMENT> {
    public <R> R accept(Visitor<R> var1);

    public static interface Visitor<R> {
        public R visit(Select<?> var1);

        public R visit(Union<?> var1);

        public R visit(UnionAll<?> var1);
    }

    public static class UnionAll<ELEMENT>
    implements SetOperationContext<ELEMENT> {
        public final SetOperationContext<ELEMENT> left;
        public final SetOperationContext<ELEMENT> right;
        public final List<Pair<OrderByItem.Index, String>> orderBy = new ArrayList<Pair<OrderByItem.Index, String>>();

        public UnionAll(SetOperationContext<ELEMENT> left, SetOperationContext<ELEMENT> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Union<ELEMENT>
    implements SetOperationContext<ELEMENT> {
        public final SetOperationContext<ELEMENT> left;
        public final SetOperationContext<ELEMENT> right;
        public final List<Pair<OrderByItem.Index, String>> orderBy = new ArrayList<Pair<OrderByItem.Index, String>>();

        public Union(SetOperationContext<ELEMENT> left, SetOperationContext<ELEMENT> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Select<ELEMENT>
    implements SetOperationContext<ELEMENT> {
        public final SelectContext context;

        public Select(SelectContext context) {
            this.context = Objects.requireNonNull(context);
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }
}

