/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.context;

import java.util.Objects;
import java.util.function.Supplier;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.jdbc.scalar.Scalars;
import org.seasar.doma.internal.jdbc.sql.ScalarInParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;

public interface Operand {
    public <R> R accept(Visitor<R> var1);

    public static interface Visitor<R> {
        public R visit(Param var1);

        public R visit(Prop var1);
    }

    public static final class Prop
    implements Operand {
        public final PropertyMetamodel<?> value;

        public Prop(PropertyMetamodel<?> value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Prop)) {
                return false;
            }
            Prop prop = (Prop)o;
            return this.value.equals(prop.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static final class Param
    implements Operand {
        private final PropertyMetamodel<?> propertyMetamodel;
        private final Object value;

        public Param(PropertyMetamodel<?> propertyMetamodel, Object value) {
            this.propertyMetamodel = Objects.requireNonNull(propertyMetamodel);
            this.value = value;
        }

        public InParameter<?> createInParameter(Config config) {
            Class<?> clazz = this.propertyMetamodel.asClass();
            Supplier<Scalar<?, ?>> supplier = Scalars.wrap(this.value, clazz, false, config.getClassHelper());
            return new ScalarInParameter(supplier.get());
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Param)) {
                return false;
            }
            Param param = (Param)o;
            return this.propertyMetamodel.equals(param.propertyMetamodel) && Objects.equals(this.value, param.value);
        }

        public int hashCode() {
            return Objects.hash(this.propertyMetamodel, this.value);
        }
    }
}

