/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.criteria.command.EntityData;
import org.seasar.doma.jdbc.criteria.command.EntityKey;
import org.seasar.doma.jdbc.criteria.command.EntityPool;
import org.seasar.doma.jdbc.criteria.command.FetchSupport;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.Query;

public class EntityPoolProvider
implements ObjectProvider<EntityPool> {
    private final Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> projectionEntityMetamodels;
    private final FetchSupport fetchSupport;

    public EntityPoolProvider(Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> projectionEntityMetamodels, Query query) {
        this.projectionEntityMetamodels = Objects.requireNonNull(projectionEntityMetamodels);
        Objects.requireNonNull(query);
        this.fetchSupport = new FetchSupport(query);
    }

    @Override
    public EntityPool get(ResultSet resultSet) throws SQLException {
        Objects.requireNonNull(resultSet);
        EntityPool entityPool = new EntityPool();
        int index = 1;
        for (Map.Entry<EntityMetamodel<?>, List<PropertyMetamodel<?>>> entry : this.projectionEntityMetamodels.entrySet()) {
            EntityKey key;
            EntityMetamodel<?> entityMetamodel = entry.getKey();
            List<PropertyMetamodel<?>> projectionTargets = entry.getValue();
            EntityType<?> entityType = entityMetamodel.asType();
            List propertyTypes = projectionTargets.stream().map(PropertyMetamodel::asType).collect(Collectors.toList());
            ArrayList<Prop> props = new ArrayList<Prop>(propertyTypes.size());
            for (EntityPropertyType propertyType : propertyTypes) {
                Property property = propertyType.createProperty();
                Object rawValue = this.fetchSupport.fetch(resultSet, property, index++);
                props.add(new Prop(propertyType, property, rawValue));
            }
            if (props.stream().allMatch(p -> ((Prop)p).rawValue == null)) continue;
            if (entityType.getIdPropertyTypes().isEmpty()) {
                key = new EntityKey(entityMetamodel, Collections.singletonList(new Object()));
            } else {
                List items = props.stream().filter(it -> ((Prop)it).propType.isId()).map(it -> ((Prop)it).prop.getWrapper().get()).collect(Collectors.toList());
                key = new EntityKey(entityMetamodel, items);
            }
            Map<String, Property<Object, ?>> states = props.stream().collect(Collectors.toMap(p -> ((Prop)p).propType.getName(), p -> ((Prop)p).prop));
            EntityData data = new EntityData(states);
            entityPool.put(key, data);
        }
        return entityPool;
    }

    private static class Prop {
        private final EntityPropertyType<?, ?> propType;
        private final Property<Object, ?> prop;
        private final Object rawValue;

        public Prop(EntityPropertyType<?, ?> propType, Property<Object, ?> prop, Object rawValue) {
            this.propType = propType;
            this.prop = prop;
            this.rawValue = rawValue;
        }
    }
}

