/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.builder.ParamIndex;

class BatchParam<P> {
    final String name;
    final Class<P> paramClass;
    final List<P> params = new ArrayList<P>();
    final boolean literal;

    BatchParam(Class<P> paramClass, ParamIndex index, boolean literal) {
        this.paramClass = paramClass;
        this.name = "p" + index.getValue();
        this.literal = literal;
    }

    BatchParam(BatchParam<?> baseParam, Class<P> paramClass) {
        AssertionUtil.assertEquals(Object.class, baseParam.paramClass);
        this.name = baseParam.name;
        this.paramClass = paramClass;
        this.literal = baseParam.literal;
        baseParam.params.forEach(e -> {
            AssertionUtil.assertNull(e);
            this.params.add(null);
        });
    }

    void add(P param) {
        this.params.add(param);
    }
}

