/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;

public final class Zip {
    public static <T, U> Stream<Pair<T, U>> stream(Stream<T> first, Stream<U> second) {
        AssertionUtil.assertNotNull(first, second);
        return Zip.streamInternal(first.iterator(), second.iterator());
    }

    public static <T, U> Stream<Pair<T, U>> stream(Iterable<T> first, Iterable<U> second) {
        AssertionUtil.assertNotNull(first, second);
        return Zip.streamInternal(first.iterator(), second.iterator());
    }

    public static <T, U> Stream<Pair<T, U>> streamInternal(final Iterator<T> first, final Iterator<U> second) {
        Iterator iterator = new Iterator<Pair<T, U>>(){

            @Override
            public boolean hasNext() {
                return first.hasNext() && second.hasNext();
            }

            @Override
            public Pair<T, U> next() {
                return new Pair(first.next(), second.next());
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }
}

